/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb;

import java.io.PrintStream;
import java.io.PrintWriter;

public class EJBException
extends RuntimeException {
    private static final long serialVersionUID = 796770993296843510L;
    private Exception causeException = null;

    public EJBException() {
    }

    public EJBException(String message) {
        super(message);
    }

    public EJBException(Exception ex) {
        super(ex);
        this.causeException = ex;
    }

    public EJBException(String message, Exception ex) {
        super(message, ex);
        this.causeException = ex;
    }

    public Exception getCausedByException() {
        return (Exception)this.getCause();
    }

    public String getMessage() {
        return super.getMessage();
    }

    public Throwable getCause() {
        Throwable ex = super.getCause();
        if (ex != null) {
            return ex;
        }
        return this.causeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        if (super.getCause() == null) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                super.printStackTrace(ps);
                if (this.causeException != null) {
                    ps.println("Caused by: " + this.causeException.toString());
                    this.causeException.printStackTrace(ps);
                }
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        if (super.getCause() == null) {
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                super.printStackTrace(pw);
                if (this.causeException != null) {
                    pw.println("Caused by: " + this.causeException.toString());
                    this.causeException.printStackTrace(pw);
                }
            }
        } else {
            super.printStackTrace(pw);
        }
    }
}

