/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;

public abstract class ConnectionFactory {
    private static final String CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactoryClass";
    private static final String DEFAULT_CONNECTION_FACTORY = "jeus.webservices.registry.uddi.ConnectionFactoryImpl";

    public abstract void setProperties(Properties var1) throws JAXRException;

    public abstract Properties getProperties() throws JAXRException;

    public abstract Connection createConnection() throws JAXRException;

    public abstract FederatedConnection createFederatedConnection(Collection var1) throws JAXRException;

    public static ConnectionFactory newInstance() throws JAXRException {
        try {
            return (ConnectionFactory)ConnectionFactory.find(CONNECTION_FACTORY_CLASS, DEFAULT_CONNECTION_FACTORY);
        }
        catch (Exception exception) {
            throw new JAXRException("Unable to create ConnectionFactory: " + exception.getMessage());
        }
    }

    private static Object newInstance(String s, ClassLoader classloader) throws JAXRException {
        try {
            Class<?> class1 = classloader == null ? Class.forName(s) : classloader.loadClass(s);
            return class1.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new JAXRException("Provider " + s + " not found", ex);
        }
        catch (Exception ex) {
            throw new JAXRException("Provider " + s + " could not be instantiated: " + ex, ex);
        }
    }

    static Object find(String s, String s1) throws JAXRException {
        ClassLoader classloader;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new JAXRException(exception.toString(), exception);
        }
        try {
            String s2 = System.getProperty(s);
            if (s2 != null) {
                return ConnectionFactory.newInstance(s2, classloader);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String obj = System.getProperty("java.home");
            String s3 = obj + File.separator + "lib" + File.separator + "jaxr.properties";
            File file = new File(s3);
            if (file.exists()) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(file));
                String s5 = properties.getProperty(s);
                return ConnectionFactory.newInstance(s5, classloader);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String obj = "META-INF/services/" + s;
            InputStream inputstream = null;
            inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(obj) : classloader.getResourceAsStream(obj);
            if (inputstream != null) {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                String s4 = bufferedreader.readLine();
                bufferedreader.close();
                if (s4 != null && !"".equals(s4)) {
                    return ConnectionFactory.newInstance(s4, classloader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s1 == null) {
            throw new JAXRException("Provider for " + s + " cannot be found", null);
        }
        return ConnectionFactory.newInstance(s1, classloader);
    }
}

