/*
 * Decompiled with CFR 0.152.
 */
package jeus.corba;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.ORBUtil;
import jeus.security.base.DecryptionException;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoggerUtil;
import jeus.transaction.ots.Configuration;
import jeus.transaction.ots.CoordinatorResourceServantActivator;
import jeus.transaction.ots.RecoveryCoordinatorServantActivator;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_CORBA;
import jeus.util.message.JeusMessage_OTS0;
import jeus.util.message.JeusMessage_Security;
import jeus.util.properties.JeusEJBProperties;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.jeusDD.KeystoreConfigType;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantManager;

public class ORBManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.corba");
    private static final String ORB_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String ORB_SE_SINGLETON_CLASS = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static final String IIOP_SSL_SOCKET_FACTORY_CLASS = "jeus.ejb.interop.csi.CSISocketFactoryFor5";
    private static final String RMI_UTIL_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.Util";
    private static final String RMI_STUB_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl";
    private static final String RMI_PRO_CLASS = "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject";
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    public static final String SUN_USER_CONFIGURATOR_PREFIX = "com.sun.corba.ee.ORBUserConfigurators.";
    public static final String SUN_ORB_ID_PROPERTY = "org.omg.CORBA.ORBId";
    public static final String SUN_ORB_SERVER_HOST_PROPERTY = "com.sun.corba.ee.ORBServerHost";
    public static final String SUN_ORB_SERVER_PORT_PROPERTY = "com.sun.corba.ee.ORBServerPort";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBSocketFactoryClass";
    public static final String SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY = "com.sun.corba.ee.transport.ORBIORToSocketInfoClass";
    public static final String SUN_MAX_CONNECTIONS_PROPERTY = "com.sun.corba.ee.connection.ORBHighWaterMark";
    public static final String ORB_LISTEN_SOCKET_PROPERTY = "com.sun.corba.ee.transport.ORBListenSocket";
    public static final String ORB_DISABLED_PORTS_PROPERTY = "com.sun.CORBA.connection.ORBDisabledListenPorts";
    private static Vector<ORBReceiver> orbReceivers = new Vector();
    private static ORB interopORB;
    private static ORB defaultORB;
    private static boolean enableInterop;
    private static ArrayList trustHosts;
    private static Hashtable ejbDescs;
    private static int orbPort;
    private static int orbSSLPort;
    private static int orbSSLMutualAuthPort;
    private static POA m_rootPOA;
    private static POA m_recoveryPOA;
    private static POA coordinatorPOA;
    private static final String JEUS_INTEROP_ORB = "jeus.ejb.interop.csi.CSIEJBORB";

    public static void setORB(ORB orb) {
        for (int i = 0; i < orbReceivers.size(); ++i) {
            ORBReceiver orbReceiver = orbReceivers.get(i);
            orbReceiver.setORB(orb);
        }
        ORBUtil.initORB(orb);
    }

    public static void initContainerORB(boolean enableInterop, KeystoreConfigType sslConfig) throws JeusException {
        if (sslConfig != null) {
            sslConfig.strip();
            if (sslConfig.isSetKeystorePath()) {
                JeusManagerProperties.INTEROP_SSL_KEYSTORE = sslConfig.getKeystorePath();
            }
            if (sslConfig.isSetKeystorePassword()) {
                try {
                    JeusManagerProperties.INTEROP_SSL_KEYPASS = EncryptionUtil.decryptPassword(sslConfig.getKeystorePassword());
                }
                catch (DecryptionException e) {
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._73_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._73_LEVEL, JeusMessage_Security._73, (Throwable)e);
                    }
                    throw new JeusException(e);
                }
            }
            if (sslConfig.isSetTruststorePath()) {
                JeusManagerProperties.INTEROP_SSL_TRUSTSTORE = sslConfig.getTruststorePath();
            }
            if (sslConfig.isSetTruststorePassword()) {
                try {
                    JeusManagerProperties.INTEROP_SSL_TRUSTPASS = EncryptionUtil.decryptPassword(sslConfig.getTruststorePassword());
                }
                catch (DecryptionException e) {
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._73_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._73_LEVEL, JeusMessage_Security._73, (Throwable)e);
                    }
                    throw new JeusException(e);
                }
            }
        }
        ORBManager._initContainerORB(enableInterop, sslConfig);
    }

    private static void _initContainerORB(boolean useEEORB, KeystoreConfigType sslConfig) throws JeusException {
        try {
            Properties props = new Properties();
            if (useEEORB) {
                int containerBasePort = JeusManagerPropertyValues.getContainerBasePort();
                orbPort = containerBasePort + 1;
                orbSSLPort = containerBasePort + 2;
                orbSSLMutualAuthPort = containerBasePort + 3;
                ORBManager.setORBSystemProperties();
                props.put(OMG_ORB_CLASS_PROPERTY, JEUS_INTEROP_ORB);
                props.put("org.omg.CORBA.ORBServerId", "1");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.jeus.ejb.interop.EJBORBInitializer", "");
                if (JeusManagerPropertyValues.shouldListenServiceIpAddressOnly()) {
                    props.put(SUN_ORB_SERVER_HOST_PROPERTY, JeusManagerPropertyValues.getServerServiceIpAddress());
                }
                props.put(SUN_ORB_SERVER_PORT_PROPERTY, String.valueOf(orbPort));
                props.put("com.sun.corba.ee.POA.ORBPersistentServerPort", String.valueOf(orbPort));
                props.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, IIOP_SSL_SOCKET_FACTORY_CLASS);
                if (sslConfig != null) {
                    props.put(ORB_LISTEN_SOCKET_PROPERTY, "SSL:" + orbSSLPort + "," + "SSL_MUTUALAUTH" + ":" + orbSSLMutualAuthPort);
                }
                props.put(SUN_ORB_IOR_TO_SOCKETINFO_CLASS_PROPERTY, "jeus.ejb.interop.csi.CSIIORToSocketInfo");
                props.put("com.sun.corba.ee.giop.ORBFragmentSize", "4096");
                StringUtil.setPropertiesToMap(JeusEJBProperties.CORBA_PROP, props);
                if (logger.isLoggable(JeusMessage_CORBA._1001_LEVEL)) {
                    logger.log(JeusMessage_CORBA._1001_LEVEL, JeusMessage_CORBA._1001, (Object)props.toString());
                }
                ORB orb = ORB.init((String[])new String[0], (Properties)props);
                ORBManager.setORB(orb);
                interopORB = orb;
                defaultORB = orb;
                m_rootPOA = (POA)interopORB.resolve_initial_references("RootPOA");
                ORBManager.initOTS();
                m_rootPOA.the_POAManager().activate();
                enableInterop = true;
                if (logger.isLoggable(JeusMessage_CORBA._1002_LEVEL)) {
                    logger.log(JeusMessage_CORBA._1002_LEVEL, JeusMessage_CORBA._1002, (Object)("EE-ORB-" + orbPort));
                }
            } else {
                ORB orb;
                props.put("com.sun.CORBA.ORBServerPort", "0");
                defaultORB = orb = ORB.init((String[])new String[0], (Properties)props);
                m_rootPOA = (POA)orb.resolve_initial_references("RootPOA");
                if (logger.isLoggable(JeusMessage_CORBA._1002_LEVEL)) {
                    logger.log(JeusMessage_CORBA._1002_LEVEL, JeusMessage_CORBA._1002, (Object)"SE-ORB");
                }
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_CORBA._1003_LEVEL)) {
                logger.log(JeusMessage_CORBA._1003_LEVEL, JeusMessage_CORBA._1003, t);
            }
            throw new JeusException(JeusMessage_CORBA._1003, t);
        }
    }

    public static ORB createServerORB(int orbPort) throws JeusException {
        try {
            Properties props = new Properties();
            props.put(OMG_ORB_CLASS_PROPERTY, JEUS_INTEROP_ORB);
            props.put("org.omg.CORBA.ORBServerId", "1");
            if (JeusManagerPropertyValues.shouldListenServiceIpAddressOnly()) {
                props.put(SUN_ORB_SERVER_HOST_PROPERTY, JeusManagerPropertyValues.getServerServiceIpAddress());
            }
            props.put(SUN_ORB_SERVER_PORT_PROPERTY, String.valueOf(orbPort));
            props.put("com.sun.corba.ee.POA.ORBPersistentServerPort", String.valueOf(orbPort));
            props.put(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, IIOP_SSL_SOCKET_FACTORY_CLASS);
            props.put("com.sun.corba.ee.giop.ORBFragmentSize", "4096");
            if (logger.isLoggable(JeusMessage_CORBA._1001_LEVEL)) {
                logger.log(JeusMessage_CORBA._1001_LEVEL, JeusMessage_CORBA._1001, (Object)props.toString());
            }
            ORB orb = ORB.init((String[])new String[0], (Properties)props);
            POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            rootPOA.the_POAManager().activate();
            if (logger.isLoggable(JeusMessage_CORBA._1002_LEVEL)) {
                logger.log(JeusMessage_CORBA._1002_LEVEL, JeusMessage_CORBA._1002, (Object)("EE-ORB-" + orbPort));
            }
            return orb;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_CORBA._1003_LEVEL)) {
                logger.log(JeusMessage_CORBA._1003_LEVEL, JeusMessage_CORBA._1003, t);
            }
            throw new JeusException(JeusMessage_CORBA._1003, t);
        }
    }

    public static ORB createClientORB(boolean useEEORB, boolean isDefault) throws JeusException {
        try {
            ORB orb;
            Properties props = new Properties();
            if (useEEORB) {
                if (isDefault) {
                    ORBManager.setORBSystemProperties();
                }
                props.put(OMG_ORB_CLASS_PROPERTY, JEUS_INTEROP_ORB);
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.jeus.ejb.interop.EJBORBInitializer", "");
                props.put("com.sun.corba.ee.giop.ORBFragmentSize", "4096");
                StringUtil.setPropertiesToMap(JeusEJBProperties.CORBA_PROP, props);
                if (logger.isLoggable(JeusMessage_CORBA._1001_LEVEL)) {
                    logger.log(JeusMessage_CORBA._1001_LEVEL, JeusMessage_CORBA._1001, (Object)props.toString());
                }
                orb = ORB.init((String[])new String[0], (Properties)props);
                ORBManager.setORB(orb);
                if (logger.isLoggable(JeusMessage_CORBA._1002_LEVEL)) {
                    logger.log(JeusMessage_CORBA._1002_LEVEL, JeusMessage_CORBA._1002, (Object)"Client-EE-ORB");
                }
            } else {
                props.put("com.sun.CORBA.ORBServerPort", "0");
                orb = ORB.init((String[])new String[0], (Properties)props);
                if (logger.isLoggable(JeusMessage_CORBA._1002_LEVEL)) {
                    logger.log(JeusMessage_CORBA._1002_LEVEL, JeusMessage_CORBA._1002, (Object)"Client-SE-ORB");
                }
            }
            if (isDefault) {
                defaultORB = orb;
            }
            return orb;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_CORBA._1003_LEVEL)) {
                logger.log(JeusMessage_CORBA._1003_LEVEL, JeusMessage_CORBA._1003, t);
            }
            throw new JeusException(JeusMessage_CORBA._1003, t);
        }
    }

    public static void setORBSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty(ORBManager.OMG_ORB_CLASS_PROPERTY) == null) {
                    System.setProperty(ORBManager.OMG_ORB_CLASS_PROPERTY, ORBManager.JEUS_INTEROP_ORB);
                }
                if (System.getProperty(ORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY) == null) {
                    System.setProperty(ORBManager.OMG_ORB_SINGLETON_CLASS_PROPERTY, ORBManager.ORB_SINGLETON_CLASS);
                }
                System.setProperty(ORBManager.ORB_UTIL_CLASS_PROPERTY, ORBManager.RMI_UTIL_CLASS);
                System.setProperty(ORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, ORBManager.RMI_STUB_CLASS);
                System.setProperty(ORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, ORBManager.RMI_PRO_CLASS);
                return null;
            }
        });
    }

    public static ORB getDefaultORB() {
        return defaultORB;
    }

    public static ORB getORB() {
        if (interopORB == null) {
            throw new JeusRuntimeException("Interoperable ORB is not initialized. Please check server configuration.");
        }
        return interopORB;
    }

    public static ORB getORBForNaming(boolean isInServer) {
        if (!isInServer) {
            ORBManager.initClientORB();
        }
        return defaultORB;
    }

    public static int getORBPort() {
        return orbPort;
    }

    public static int getORBSSLPort() {
        return orbSSLPort;
    }

    public static int getORBSSLMutualAuthPort() {
        return orbSSLMutualAuthPort;
    }

    public static POA getRootPOA() {
        if (!enableInterop) {
            throw new JeusRuntimeException("Interoperable ORB is not initialized. Please check server configuration.");
        }
        return m_rootPOA;
    }

    public static synchronized void initClientORB() {
        if (defaultORB != null) {
            return;
        }
        try {
            ORBManager.createClientORB(JeusEJBProperties.CLIENT_INTEROP, true);
        }
        catch (JeusException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isEnableInterop() {
        return enableInterop;
    }

    public static void destroy() {
        try {
            if (defaultORB != null) {
                defaultORB.destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        defaultORB = null;
        interopORB = null;
        orbReceivers.clear();
    }

    public static void addORBReceiver(ORBReceiver interceptor) {
        orbReceivers.add(interceptor);
    }

    public static boolean isTrustedHost(String ipAddr) {
        return trustHosts.indexOf(ipAddr) != -1;
    }

    public static SecurityInteropType getEJBCSIDescriptor(String ejbName) {
        return (SecurityInteropType)ejbDescs.get(ejbName);
    }

    public static void addEJBCSIDescriptor(String ejbName, SecurityInteropType desc) {
        ejbDescs.put(ejbName, desc);
    }

    public static void removeEJBCSIDescriptor(String ejbName) {
        ejbDescs.remove(ejbName);
    }

    private static void initOTS() {
        try {
            Configuration.setORB(interopORB);
            coordinatorPOA = ORBManager.createCoordinatorPOA(m_rootPOA);
            m_recoveryPOA = ORBManager.createRecoveryPOA(m_rootPOA);
            coordinatorPOA.the_POAManager().activate();
            if (logger.isLoggable(JeusMessage_OTS0._1001_LEVEL)) {
                logger.log(JeusMessage_OTS0._1001_LEVEL, JeusMessage_OTS0._1001);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static POA createRecoveryPOA(POA rootPOA) throws InvalidPolicy, AdapterAlreadyExists, WrongPolicy {
        Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
        POA rcoordPOA = rootPOA.create_POA("OTSrecoveryPOA", rootPOA.the_POAManager(), policies);
        Configuration.setPOA("OTSrecoveryPOA", rcoordPOA);
        RecoveryCoordinatorServantActivator rcrsa = new RecoveryCoordinatorServantActivator(interopORB);
        rcoordPOA.set_servant_manager((ServantManager)rcrsa);
        return rcoordPOA;
    }

    private static POA createCoordinatorPOA(POA rootPOA) throws InvalidPolicy, AdapterAlreadyExists, WrongPolicy {
        Policy[] tpolicy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
        POA coordPOA = rootPOA.create_POA("OTSCoordinatorPOA", null, tpolicy);
        Configuration.setPOA("OTSCoordinatorPOA", coordPOA);
        CoordinatorResourceServantActivator crsa = new CoordinatorResourceServantActivator(interopORB);
        coordPOA.set_servant_manager((ServantManager)crsa);
        return coordPOA;
    }

    public static POA getCoordinatorPOA() {
        return coordinatorPOA;
    }

    public static POA getRecoveryPOA() {
        return m_recoveryPOA;
    }

    static {
        trustHosts = new ArrayList();
        ejbDescs = new Hashtable();
        String temp = JeusEJBProperties.CSI_TRUSTHOSTS;
        if (temp != null) {
            int idx;
            while ((idx = temp.indexOf(59)) != -1) {
                trustHosts.add(temp.substring(0, idx));
                temp = temp.substring(idx + 1);
            }
            trustHosts.add(temp);
        }
    }
}

