/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.file.FileUtils;

public class ArchiveHelper {
    public static AbstractArchive openArchive(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
            path = file.getPath();
        }
        AbstractArchive archive = file.isDirectory() ? FileArchiveFactory.openArchiveStatic(path) : JarArchiveFactory.openArchiveStatic(path);
        return archive;
    }

    public static AbstractArchive[] openArchives(String[] pathes) {
        if (pathes == null) {
            throw new NullPointerException("pathes is null");
        }
        AbstractArchive[] archives = new AbstractArchive[pathes.length];
        for (int i = 0; i < pathes.length; ++i) {
            try {
                archives[i] = ArchiveHelper.openArchive(pathes[i]);
                continue;
            }
            catch (IOException e) {
                for (int j = 0; j < i; ++j) {
                    try {
                        archives[j].close();
                        continue;
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw new JeusRuntimeException("Could not open the archive: " + pathes[i], (Throwable)e);
            }
        }
        return archives;
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        ArchiveHelper.copyWithoutClose(is, os);
    }

    public static void copy(AbstractArchive source, AbstractArchive target, String[] excludeList) throws IOException {
        Enumeration e = source.entries();
        InputStream is = null;
        OutputStream os = null;
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (StringUtil.isMemberOf(entry, excludeList)) continue;
            is = source.getEntry(entry);
            os = target.addEntry(entry);
            if (os instanceof ZipOutputStream) {
                ArchiveHelper.copy(is, (ZipOutputStream)os);
                continue;
            }
            ArchiveHelper.copy(is, os);
        }
    }

    public static void copyWithoutClose(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        os.flush();
    }

    public static void copyWithTimePreservation(InputStream is, String entryName, long prevModifiedTime, ZipOutputStream out) throws IOException {
        ZipEntry ze = new ZipEntry(entryName);
        ze.setTime(prevModifiedTime);
        out.putNextEntry(ze);
        ArchiveHelper.copyWithoutClose(is, out);
        is.close();
        out.flush();
        out.closeEntry();
    }

    public static void copy(InputStream is, String entryName, ZipOutputStream out) throws IOException {
        ZipEntry ze = new ZipEntry(entryName);
        out.putNextEntry(ze);
        ArchiveHelper.copyWithoutClose(is, out);
        is.close();
        out.flush();
        out.closeEntry();
    }

    public static void copy(InputStream is, ZipOutputStream out) throws IOException {
        ArchiveHelper.copyWithoutClose(is, out);
        is.close();
        out.flush();
        out.closeEntry();
    }

    public static void copyManifest(AbstractArchive in, ZipOutputStream jarOut) throws IOException {
        Manifest manifest = in.getManifest();
        if (manifest != null) {
            jarOut.putNextEntry(new ZipEntry("META-INF" + File.separator + "MANIFEST.MF"));
            manifest.write(jarOut);
            jarOut.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileArchive extractArchive(FileArchive directoryArchive, String archiveFileName, String extension) throws IOException {
        InputJarArchive jarArchive = null;
        try {
            jarArchive = directoryArchive.getEmbeddedJarArchive(archiveFileName);
            String newDirectory = archiveFileName.substring(0, archiveFileName.lastIndexOf(extension));
            jarArchive.extractArchive(directoryArchive, newDirectory);
            FileArchive fileArchive = (FileArchive)directoryArchive.getEmbeddedArchive(newDirectory);
            return fileArchive;
        }
        finally {
            if (jarArchive != null) {
                jarArchive.close();
                jarArchive = null;
            }
        }
    }

    public static List listArchiveEntries(String sourcePath) throws IOException {
        AbstractArchive arc = null;
        List files = null;
        try {
            arc = !FileUtils.isExploded(sourcePath) ? JarArchiveFactory.openArchiveStatic(sourcePath) : FileArchiveFactory.openArchiveStatic(sourcePath);
            files = ArchiveHelper.listArchiveEntries(arc);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (arc != null) {
                arc.close();
            }
        }
        return files;
    }

    public static List listArchiveEntries(AbstractArchive archive) {
        ArrayList<String> files = new ArrayList<String>();
        Enumeration em = archive.entries();
        while (em.hasMoreElements()) {
            String ze = (String)em.nextElement();
            files.add(ze);
        }
        return files;
    }

    public static void close(OutputStream os) throws IOException {
        if (os instanceof ZipOutputStream) {
            ((ZipOutputStream)os).closeEntry();
        } else {
            os.close();
        }
    }
}

