/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.deploy.archivist.JarEntryInputStream;
import jeus.deploy.archivist.OutputJarArchive;
import jeus.util.JeusException;
import jeus.util.file.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArchive
extends AbstractArchive
implements Serializable {
    File archive;
    String path;
    private URL archiveUrl;
    private URI archiveURI;
    private String classFtpArchiveName;

    public FileArchive() {
    }

    public FileArchive(String path) throws IOException {
        this.open(path);
    }

    public FileArchive(File path) throws IOException {
        this.open(path);
    }

    public void open(String path) throws IOException {
        this.open(new File(path));
    }

    public void open(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        this.archive = file.isDirectory() ? new File(file.getPath() + File.separatorChar) : file;
        this.path = this.archive.getPath();
        this.archiveURI = this.archive.toURI();
        this.archiveUrl = this.archive.toURI().toURL();
    }

    public void create(String path) throws IOException {
        this.archive = new File(path);
        if (this.archive.isDirectory()) {
            this.archive = new File(this.archive.getPath() + File.separatorChar);
        }
        this.archive.mkdirs();
        this.path = this.archive.getPath();
        this.archiveURI = this.archive.toURI();
        this.archiveUrl = this.archive.toURI().toURL();
    }

    public void append(String path) throws MalformedURLException {
        this.archive = new File(path);
        if (!this.archive.exists()) {
            this.archive.mkdirs();
        }
        this.path = this.archive.getPath();
        this.archiveURI = this.archive.toURI();
        this.archiveUrl = this.archive.toURI().toURL();
    }

    @Override
    public OutputStream addEntry(String name) throws IOException {
        File newFile = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (newFile.exists() && !this.deleteEntry(name)) {
            throw new IOException(newFile.getPath() + " already exists and cannot be deleted");
        }
        if (name.lastIndexOf(File.separatorChar) != -1) {
            String dirs = name.substring(0, name.lastIndexOf(File.separatorChar));
            new File(this.archive, dirs).mkdirs();
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(newFile));
        return fos;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void closeEntry(AbstractArchive os) throws IOException {
        os.close();
    }

    @Override
    public void closeEntry(OutputStream os) throws IOException {
        os.flush();
        os.close();
    }

    @Override
    public boolean delete() {
        try {
            return FileUtils.deleteDirectoryRecursively(this.archive);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean deleteAllEntries() {
        try {
            return FileUtils.deleteSubDirectories(this.archive);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Enumeration<String> entries() {
        Vector namesList = new Vector();
        this.getListOfFiles(this.archive, namesList, null);
        return namesList.elements();
    }

    @Override
    public Enumeration entries(Enumeration embeddedArchives) {
        Vector nameList = new Vector();
        ArrayList<String> massagedNames = new ArrayList<String>();
        while (embeddedArchives.hasMoreElements()) {
            String subArchiveName = (String)embeddedArchives.nextElement();
            massagedNames.add(FileUtils.makeFriendlyFileName(subArchiveName));
        }
        this.getListOfFiles(this.archive, nameList, massagedNames);
        return nameList.elements();
    }

    @Override
    public boolean exists() {
        return this.archive.exists();
    }

    @Override
    public String getArchiveUri() {
        return this.path;
    }

    public URI getArchiveURI() {
        return this.archiveURI;
    }

    public AbstractArchive getArchiveExistingOnly(String path) throws IOException {
        AbstractArchive sub;
        File file = new File(path);
        File subDir = file.isAbsolute() ? file : FileArchive.module2DirOrigianl(new File(this.archive, path));
        if (!subDir.exists()) {
            return null;
        }
        String subName = subDir.getPath();
        if (subDir.isDirectory()) {
            sub = new FileArchive();
            ((FileArchive)sub).open(subName);
        } else {
            sub = new InputJarArchive();
            ((InputJarArchive)sub).open(subName);
        }
        return sub;
    }

    @Override
    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        return this.getEmbeddedArchive(name, false);
    }

    public AbstractArchive getEmbeddedArchive(String name, boolean onlyFileArchive) throws IOException {
        AbstractArchive sub;
        File subDir;
        File file = new File(name);
        if (file.isAbsolute()) {
            subDir = file;
        } else {
            String friendlyFileName = FileUtils.makeFriendlyFileName(name);
            subDir = new File(this.archive, friendlyFileName);
            if (!subDir.exists()) {
                subDir = new File(this.archive, name);
                if (!subDir.exists()) {
                    subDir = new File(this.archive, friendlyFileName);
                } else if (subDir.isFile() && onlyFileArchive) {
                    subDir = new File(this.archive, friendlyFileName);
                }
            }
        }
        String subName = subDir.getPath();
        if (!subDir.exists()) {
            File newDir = new File(subName);
            newDir.mkdirs();
        }
        if (subDir.isDirectory()) {
            sub = new FileArchive();
            ((FileArchive)sub).open(subName);
        } else {
            sub = new InputJarArchive();
            ((InputJarArchive)sub).open(subName);
        }
        return sub;
    }

    @Override
    public InputStream getEntry(String name) throws IOException {
        File input;
        int jarIndex = name.indexOf("!/");
        String jarName = null;
        if (jarIndex >= 0) {
            jarName = name.substring(jarIndex + 2);
            name = name.substring(0, jarIndex);
        }
        if (!(input = new File(this.archive, name = name.replace('/', File.separatorChar))).exists()) {
            return null;
        }
        if (jarName == null) {
            FileInputStream fis = new FileInputStream(input);
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(fis);
                return bis;
            }
            catch (Throwable tx) {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable thr) {
                        IOException ioe = new IOException("Error closing FileInputStream after error opening BufferedInputStream for entry " + name);
                        ioe.initCause(thr);
                        throw ioe;
                    }
                }
                IOException ioe = new IOException("Error opening BufferedInputStream for entry " + name);
                ioe.initCause(tx);
                throw ioe;
            }
        }
        return new JarEntryInputStream(input, jarName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        InputStream is = null;
        try {
            is = this.getEntry("META-INF/MANIFEST.MF");
            if (is != null) {
                Manifest m;
                Manifest manifest = m = new Manifest(is);
                return manifest;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return null;
    }

    @Override
    public boolean renameTo(String name) {
        return this.archive.renameTo(new File(name));
    }

    private void getListOfFiles(File directory, Vector files, List embeddedArchives) {
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            String fileName = list[i].getAbsolutePath().substring(this.archive.getAbsolutePath().length() + 1);
            if (!list[i].isDirectory()) {
                if ((fileName = fileName.replace(File.separatorChar, '/')).equals("META-INF/MANIFEST.MF")) continue;
                files.add(fileName);
                continue;
            }
            if (embeddedArchives != null) {
                if (embeddedArchives.contains(fileName)) continue;
                this.getListOfFiles(list[i], files, null);
                continue;
            }
            this.getListOfFiles(list[i], files, null);
        }
    }

    @Override
    public boolean supportsElementsOverwriting() {
        return true;
    }

    @Override
    public boolean contains(String name) {
        File file = this.getFile(name);
        return file != null;
    }

    @Override
    public URL getEntryURL(String name) throws IOException {
        return this.getEntryURL(name, null);
    }

    @Override
    public URL getEntryURL(String name, URLStreamHandler handler) throws IOException {
        File file = this.getFile(name);
        return file != null ? new URL(file.toURI().toURL(), "", handler) : null;
    }

    @Override
    public URL getArchiveUrl() {
        return this.archiveUrl;
    }

    public boolean deleteEntry(String name) throws IOException {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists()) {
            return false;
        }
        if (input.isDirectory()) {
            return FileUtils.deleteDirectoryRecursively(input);
        }
        return input.delete();
    }

    private static File module2DirOrigianl(File module) {
        File dir = module.getParentFile();
        String name = module.getName();
        return new File(dir, name);
    }

    public InputJarArchive getEmbeddedJarArchive(String name) throws IOException {
        File subDir = FileArchive.module2DirOrigianl(new File(this.archive, name));
        String subName = subDir.getPath();
        if (!subDir.exists()) {
            return null;
        }
        return (InputJarArchive)JarArchiveFactory.openArchiveStatic(subName);
    }

    public OutputJarArchive getEmbeddedOutputJarArchive(String name) throws IOException {
        File subDir = FileArchive.module2DirOrigianl(new File(this.archive, name));
        String subName = subDir.getPath();
        if (!subDir.exists()) {
            return null;
        }
        return (OutputJarArchive)JarArchiveFactory.openArchiveStatic(subName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jarArchive(AbstractArchive embeddedArchive, String archiveName) throws IOException {
        Vector namesList = new Vector();
        this.getListOfFiles(this.archive, namesList, null);
        InputStream sourceStream = this.getEntry("META-INF/MANIFEST.MF");
        JarOutputStream jarOutputStream = new JarOutputStream(embeddedArchive.addEntry(archiveName));
        if (sourceStream != null) {
            Manifest manifest;
            try {
                manifest = new Manifest(sourceStream);
            }
            finally {
                sourceStream.close();
            }
            try {
                ZipEntry e = new ZipEntry("META-INF/");
                e.setTime(System.currentTimeMillis());
                e.setSize(0L);
                e.setCrc(0L);
                jarOutputStream.putNextEntry(e);
                e = new ZipEntry("META-INF/MANIFEST.MF");
                e.setTime(System.currentTimeMillis());
                jarOutputStream.putNextEntry(e);
                manifest.write(jarOutputStream);
                jarOutputStream.closeEntry();
            }
            catch (Exception ex) {
                jarOutputStream.close();
                throw new JeusException(ex);
            }
        }
        try {
            for (int i = 0; i < namesList.size(); ++i) {
                String s = (String)namesList.elementAt(i);
                sourceStream = this.getEntry(s);
                if (sourceStream == null) continue;
                ArchiveHelper.copyWithTimePreservation(sourceStream, s, this.getFile(s).lastModified(), jarOutputStream);
            }
        }
        finally {
            jarOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEntry(String sourcePath, AbstractArchive targetArchive, String targetName) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = this.getEntry(sourcePath);
            os = targetArchive.addEntry(targetName);
            ArchiveHelper.copy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
            if (os != null) {
                os.close();
                os = null;
            }
        }
    }

    public int hashCode() {
        return this.archive != null ? this.archive.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileArchive) {
            return this.archive.equals(((FileArchive)obj).archive);
        }
        return false;
    }

    public URL toURL() throws MalformedURLException {
        return this.archiveUrl;
    }

    public File getFile(String path) {
        if (path == null) {
            return null;
        }
        File parent = this.getFile();
        if (parent == null) {
            return null;
        }
        String normalizedPath = path.replace('/', File.separatorChar);
        File file = new File(parent, normalizedPath);
        return file.exists() ? file : null;
    }

    public File getFile() {
        return this.archive;
    }

    @Override
    public String getClassFtpUri(int count) {
        if (this.classFtpArchiveName == null) {
            return this.path + "___" + count + "/";
        }
        return this.path.substring(0, this.path.lastIndexOf(File.separatorChar) + 1) + this.classFtpArchiveName + "___" + count + ".jar";
    }

    public void setClassFtpArchiveName(String s) {
        this.classFtpArchiveName = s;
    }

    public FileArchive getParentArchive() throws IOException {
        String parentPath = this.getFile().getParent();
        return (FileArchive)FileArchiveFactory.createArchiveStatic(parentPath);
    }

    public String toString() {
        if (this.path == null) {
            return "DirectoryArchive[not opened]";
        }
        return "DirectoryArchive[" + this.path + "]";
    }
}

