/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.util.file.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputJarArchive
extends AbstractArchive {
    protected JarFile jarFile = null;
    protected JarInputStream jarIS = null;
    private String archiveUri;
    private InputJarArchive parentArchive = null;
    private URL jarFileUrl = null;

    @Override
    public String getArchiveUri() {
        return this.archiveUri;
    }

    @Override
    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
            this.jarFileUrl = null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
            this.jarIS = null;
        }
    }

    @Override
    public void closeEntry(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void create(String path) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> entries() {
        Vector<String> entries;
        block13: {
            entries = new Vector<String>();
            if (this.parentArchive != null && this.parentArchive.jarFile != null) {
                try {
                    this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.archiveUri)));
                    try {
                        JarEntry ze;
                        do {
                            if ((ze = this.jarIS.getNextJarEntry()) == null || FileUtils.isDirectory(ze)) continue;
                            entries.add(ze.getName());
                        } while (ze != null);
                        break block13;
                    }
                    finally {
                        if (this.jarIS != null) {
                            this.jarIS.close();
                            this.jarIS = null;
                        }
                    }
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            try {
                if (this.jarFile == null) {
                    this.getJarFile(this.archiveUri);
                }
            }
            catch (IOException ioe) {
                return entries.elements();
            }
            if (this.jarFile == null) {
                return entries.elements();
            }
            Enumeration<JarEntry> enum1 = this.jarFile.entries();
            while (enum1.hasMoreElements()) {
                ZipEntry ze = enum1.nextElement();
                if (FileUtils.isDirectory(ze) || ze.getName().equals("META-INF/MANIFEST.MF")) continue;
                entries.add(ze.getName());
            }
        }
        return entries.elements();
    }

    @Override
    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    @Override
    public InputStream getEntry(String entryName) throws IOException {
        entryName = entryName.replace('\\', '/');
        if (this.jarFile != null) {
            ZipEntry ze = this.jarFile.getEntry(entryName);
            if (ze != null) {
                return new BufferedInputStream(this.jarFile.getInputStream(ze));
            }
            return null;
        }
        JarInputStream tempJarIS = this.getJarInputStreamFromParent();
        if (tempJarIS != null) {
            JarEntry je;
            this.jarIS = tempJarIS;
            while ((je = this.jarIS.getNextJarEntry()) != null && !je.getName().equals(entryName)) {
            }
            if (je != null) {
                return new BufferedInputStream(this.jarIS);
            }
            return null;
        }
        return null;
    }

    public void open(String path) throws IOException {
        this.archiveUri = path;
        this.jarFile = this.getJarFile(path);
    }

    public void open(File path) throws IOException {
        this.archiveUri = path.getAbsolutePath();
        if (path.exists()) {
            this.jarFile = new JarFile(path);
            this.jarFileUrl = new URL("jar:" + path.toURI().toURL() + "!/");
        } else {
            this.jarFile = null;
            this.jarFileUrl = null;
        }
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected JarFile getJarFile(String path) throws IOException {
        this.jarFile = null;
        this.jarFileUrl = null;
        File file = new File(path);
        if (file.exists()) {
            this.jarFile = new JarFile(file);
            this.jarFileUrl = new URL("jar:" + file.toURI().toURL() + "!/");
        }
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        InputStream manifestIs = this.getEntry("META-INF/MANIFEST.MF");
        try {
            if (manifestIs != null) {
                Manifest manifest = new Manifest(manifestIs);
                return manifest;
            }
            JarInputStream tempJarIS = this.getJarInputStreamFromParent();
            if (tempJarIS != null) {
                this.jarIS = tempJarIS;
                Manifest manifest = this.jarIS.getManifest();
                return manifest;
            }
            Manifest manifest = null;
            return manifest;
        }
        finally {
            if (manifestIs != null) {
                manifestIs.close();
            }
        }
    }

    private JarInputStream getJarInputStreamFromParent() throws IOException {
        if (this.parentArchive != null && this.parentArchive.jarFile != null) {
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            if (this.archiveUri == null) {
                return null;
            }
            String slashArchiveUri = this.archiveUri.replace('\\', '/');
            JarEntry archiveJarEntry = this.parentArchive.jarFile.getJarEntry(slashArchiveUri);
            if (archiveJarEntry == null) {
                return null;
            }
            return new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
        }
        return null;
    }

    @Override
    public boolean exists() {
        return this.jarFile != null;
    }

    @Override
    public boolean delete() {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
            this.jarFileUrl = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return new File(this.archiveUri).delete();
    }

    @Override
    public boolean renameTo(String name) {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
            this.jarFileUrl = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return new File(this.archiveUri).renameTo(new File(name));
    }

    @Override
    public InputJarArchive getEmbeddedArchive(String name) throws IOException {
        InputStream embeddedArchiveIs = this.getEntry(name);
        if (embeddedArchiveIs == null) {
            return null;
        }
        InputJarArchive embeddedArchive = new InputJarArchive();
        embeddedArchive.archiveUri = name;
        embeddedArchive.jarIS = new JarInputStream(embeddedArchiveIs);
        embeddedArchive.parentArchive = this;
        return embeddedArchive;
    }

    @Override
    public void closeEntry(AbstractArchive os) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    @Override
    public boolean supportsElementsOverwriting() {
        return false;
    }

    @Override
    public boolean contains(String entryName) throws IOException {
        InputStream entryIs = this.getEntry(entryName);
        if (entryIs == null) {
            return false;
        }
        entryIs.close();
        return true;
    }

    @Override
    public URL getArchiveUrl() {
        return this.jarFileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractArchive(FileArchive parentDirectory, String directoryName) throws IOException {
        FileArchive targetArchive = (FileArchive)parentDirectory.getEmbeddedArchive(directoryName);
        Enumeration<JarEntry> enum1 = this.jarFile.entries();
        while (enum1.hasMoreElements()) {
            ZipEntry entry = enum1.nextElement();
            if (FileUtils.isDirectory(entry)) continue;
            OutputStream os = null;
            InputStream is = null;
            try {
                os = targetArchive.addEntry(entry.getName());
                is = this.jarFile.getInputStream(entry);
                if (is == null) {
                    throw new UnsupportedOperationException("Cannot read " + entry + " in " + this.jarFile.getName());
                }
                ArchiveHelper.copy(is, os);
            }
            finally {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (os != null) {
                    os.close();
                    os = null;
                }
            }
            File f = targetArchive.getFile(entry.getName());
            long lastModified = entry.getTime();
            if (lastModified == -1L || f == null) continue;
            f.setLastModified(lastModified);
        }
    }

    public int hashCode() {
        return this.archiveUri != null ? this.archiveUri.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InputJarArchive) {
            return this.archiveUri.equals(((InputJarArchive)obj).archiveUri);
        }
        return false;
    }

    @Override
    public String getClassFtpUri(int count) {
        String extension = this.archiveUri.substring(this.archiveUri.lastIndexOf("."));
        return this.archiveUri.substring(0, this.archiveUri.lastIndexOf(".")) + "___" + count + extension;
    }

    public String toString() {
        if (this.jarFileUrl == null) {
            return "JarArchive[not opened]";
        }
        return "JarArchive[" + this.jarFileUrl + "]";
    }
}

