/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.bind;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import jeus.descriptor.jeusserver.ResourceConfigurationProperty;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.xml.binding.jeusDD.ActionOnResourceLeakType;
import jeus.xml.binding.jeusDD.DatabaseConnectionPoolType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.DestroyPolicyOnCheckQueryType;
import jeus.xml.binding.jeusDD.JdbcConnectionTraceType;
import jeus.xml.binding.jeusDD.TypePropertyType;
import jeus.xml.binding.jeusDD.WaitFreeConnectionType;

public class DBDSBindInfoJB
extends DBDSBindInfo
implements Serializable {
    public static final String PR_DATABASE_NAME = "DatabaseName";
    public static final String PR_DATA_SOURCE_NAME = "DataSourceName";
    public static final String PR_SERVICE_NAME = "ServiceName";
    public static final String PR_DESCRIPTION = "Description";
    public static final String PR_NETWORK_PROTOCOL = "NetworkProtocol";
    public static final String PR_PASSWORD = "Password";
    public static final String PR_PORT_NUMBER = "PortNumber";
    public static final String PR_SERVER_NAME = "ServerName";
    public static final String PR_USER = "User";
    private static final String PR_LOGIN_TIMEOUT = "LoginTimeout";
    public static final String PR_DRIVER_TYPE = "DriverType";

    public static void setDBPropertyValue(Vector propertyList, String givenName, String value) {
        if (propertyList == null) {
            return;
        }
        if (givenName == null || givenName.trim().equals("")) {
            return;
        }
        if (value == null || value.trim().equals("")) {
            return;
        }
        ResourceConfigurationProperty citem = new ResourceConfigurationProperty();
        citem.setName(givenName);
        if (givenName.equals(PR_PORT_NUMBER) || givenName.equals(PR_LOGIN_TIMEOUT)) {
            citem.setType("java.lang.Integer");
        } else {
            citem.setType("java.lang.String");
        }
        citem.setValue(value);
        propertyList.add(citem);
    }

    public static int convertToStaticInteger(ActionOnResourceLeakType type) {
        if (type == ActionOnResourceLeakType.NO_ACTION) {
            return 0;
        }
        if (type == ActionOnResourceLeakType.WARNING) {
            return 1;
        }
        if (type == ActionOnResourceLeakType.AUTO_CLOSE) {
            return 2;
        }
        return 9;
    }

    public static DBDSBindInfo getDBDSBindInfoDescriptor(DatabaseType dbt) {
        DBDSBindInfo dbInfo = new DBDSBindInfo();
        if (dbt.getVendor() != null) {
            dbInfo.setVendor(dbt.getVendor().value());
        }
        if (dbt.isSetExportName() && dbt.isSetDataSourceId()) {
            dbInfo.setDataSourceId(dbt.getDataSourceId());
            dbInfo.setJndiExportName(dbt.getExportName());
        } else if (dbt.isSetDataSourceId()) {
            dbInfo.setDataSourceId(dbt.getDataSourceId());
            dbInfo.setJndiExportName(dbt.getDataSourceId());
        } else if (dbt.isSetExportName()) {
            dbInfo.setDataSourceId(dbt.getExportName());
            dbInfo.setJndiExportName(dbt.getExportName());
        }
        if (dbt.isSetDataSourceTarget()) {
            dbInfo.setDataSourceTargetList(dbt.getDataSourceTarget());
        }
        dbInfo.setDataSourceType(dbt.getDataSourceType().value());
        if (dbt.getDataSourceClassName() != null) {
            dbInfo.setDataSourceClassName(dbt.getDataSourceClassName());
        }
        if (dbt.isSetAutoCommit()) {
            dbInfo.setAutoCommitValue(dbt.isAutoCommit());
            dbInfo.setUseAutoCommitSetting(true);
        }
        Vector<ResourceConfigurationProperty> newProperty = new Vector<ResourceConfigurationProperty>();
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DATABASE_NAME, dbt.getDatabaseName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DATA_SOURCE_NAME, dbt.getDataSourceName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_SERVICE_NAME, dbt.getServiceName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DESCRIPTION, dbt.getDescription());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_NETWORK_PROTOCOL, dbt.getNetworkProtocol());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_PASSWORD, dbt.getPassword());
        if (dbt.isSetPortNumber()) {
            DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_PORT_NUMBER, String.valueOf(dbt.getPortNumber()));
        }
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_SERVER_NAME, dbt.getServerName());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_USER, dbt.getUser());
        dbInfo.setUser(dbt.getUser());
        DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_DRIVER_TYPE, dbt.getDriverType());
        if (dbt.isSetLoginTimeout()) {
            DBDSBindInfoJB.setDBPropertyValue(newProperty, PR_LOGIN_TIMEOUT, String.valueOf(dbt.getLoginTimeout()));
        }
        List pList = dbt.getProperty();
        for (int i = 0; i < pList.size(); ++i) {
            TypePropertyType prop = (TypePropertyType)pList.get(i);
            ResourceConfigurationProperty citem = new ResourceConfigurationProperty();
            citem.setName(prop.getName());
            citem.setValue(prop.getValue());
            citem.setType(prop.getType());
            newProperty.add(citem);
            if (!prop.getName().equals(PR_USER)) continue;
            dbInfo.setUser(prop.getValue());
        }
        dbInfo.setStmtQueryTimeout(dbt.getStmtQueryTimeout());
        if (dbt.isSetActionOnConnectionLeak()) {
            dbInfo.setActionOnConnectionLeak(DBDSBindInfoJB.convertToStaticInteger(dbt.getActionOnConnectionLeak()));
        } else {
            dbInfo.setActionOnConnectionLeak(9);
        }
        dbInfo.properties = newProperty;
        dbInfo.mergeDSAccountsProperties();
        DatabaseConnectionPoolType cpt = dbt.getConnectionPool();
        if (cpt != null) {
            JdbcConnectionTraceType traceType;
            WaitFreeConnectionType wfct;
            if (cpt.getDelegationDba() != null && !cpt.getDelegationDba().equals("")) {
                dbInfo.setIsDbaDataSourceUsed(true);
                dbInfo.setDbaDataSourceName(cpt.getDelegationDba());
                dbInfo.setSessionKillTimeout(cpt.getDbaTimeout());
            }
            if (cpt.getDelegationDatasource() != null && !cpt.getDelegationDatasource().equals("")) {
                dbInfo.setNonTxDelegatedDataSourceRequired(true);
                dbInfo.setNonTxDelegatedDataSourceName(cpt.getDelegationDatasource());
            } else {
                dbInfo.setNonTxDelegatedDataSourceRequired(false);
            }
            if (cpt.getPooling() != null) {
                dbInfo.setMax(cpt.getPooling().getMax());
                dbInfo.setMin(cpt.getPooling().getMin());
                dbInfo.setResizingPeriod(cpt.getPooling().getPeriod());
                dbInfo.setStep(cpt.getPooling().getStep());
            }
            if ((wfct = cpt.getWaitFreeConnection()) != null) {
                dbInfo.setWaiting(wfct.isEnableWait());
                dbInfo.setWaitTime(wfct.getWaitTime());
            } else {
                dbInfo.setWaiting(false);
            }
            dbInfo.setMaxUseCount(cpt.getMaxUseCount());
            dbInfo.setCheckQuery(cpt.getCheckQuery());
            dbInfo.setCheckQueryTimeout(cpt.getCheckQueryTimeout());
            dbInfo.setCheckQueryClassName(cpt.getCheckQueryClass());
            dbInfo.setCheckQueryPeriod(cpt.getCheckQueryPeriod());
            dbInfo.setValidationRetrialCount(cpt.getCheckQueryRetrialCount());
            if (cpt.isSetDestroyPolicyOnCheckQuery()) {
                DestroyPolicyOnCheckQueryType destroyPolicyType = cpt.getDestroyPolicyOnCheckQuery();
                if (destroyPolicyType == DestroyPolicyOnCheckQueryType.FAILED_CONNECTION_ONLY) {
                    dbInfo.setDestroyPolicyOnCheckQuery(0);
                } else if (destroyPolicyType == DestroyPolicyOnCheckQueryType.ALL_CONNECTIONS) {
                    dbInfo.setDestroyPolicyOnCheckQuery(1);
                }
            }
            dbInfo.setStmtCachingSize(cpt.getStmtCachingSize());
            dbInfo.setFetchSize(cpt.getStmtFetchSize());
            dbInfo.setUseSQLTrace(cpt.isUseSqlTrace());
            if (cpt.isSetConnectionTrace() && (traceType = cpt.getConnectionTrace()).isEnabled().booleanValue()) {
                dbInfo.setUseConnectionTrace(traceType.isGetConnectionTrace());
                dbInfo.setUseSetAutoCommitTrace(traceType.isAutoCommitTrace());
            }
            dbInfo.setNonValidationInterval(cpt.getNonValidationInterval());
            dbInfo.setKeepConnectionHandleOpen(cpt.isKeepConnectionHandleOpen());
            dbInfo.setInitSql(cpt.getInitSql());
        }
        return dbInfo;
    }

    public static String convertActionOnConnectionLeakToString(int type) {
        switch (type) {
            case 0: {
                return ActionOnResourceLeakType.NO_ACTION.value();
            }
            case 1: {
                return ActionOnResourceLeakType.WARNING.value();
            }
            case 2: {
                return ActionOnResourceLeakType.AUTO_CLOSE.value();
            }
        }
        throw new IllegalArgumentException("illegal action type : " + type);
    }

    public static int convertActionOnConnectionLeakToInt(String type) {
        if ("".equals(type)) {
            return 9;
        }
        if (ActionOnResourceLeakType.NO_ACTION.value().equalsIgnoreCase(type)) {
            return 0;
        }
        if (ActionOnResourceLeakType.WARNING.value().equalsIgnoreCase(type)) {
            return 1;
        }
        if (ActionOnResourceLeakType.AUTO_CLOSE.value().equalsIgnoreCase(type)) {
            return 2;
        }
        throw new IllegalArgumentException("illegal action name : " + type);
    }

    public static int convertDestroyPolicyToInt(String type) {
        if (DestroyPolicyOnCheckQueryType.FAILED_CONNECTION_ONLY.value().equalsIgnoreCase(type)) {
            return 0;
        }
        if (DestroyPolicyOnCheckQueryType.ALL_CONNECTIONS.value().equalsIgnoreCase(type)) {
            return 1;
        }
        throw new IllegalArgumentException("illegal policy name : " + type);
    }
}

