/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.descriptor.bind.DBDSBindInfoJB;
import jeus.descriptor.jeusserver.EmailDescriptor;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.descriptor.jeusserver.JNDIServerDescriptor;
import jeus.descriptor.jeusserver.JobDescriptor;
import jeus.transaction.TransactionManagerDescriptor;
import jeus.util.JeusException;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.logging.SimpleFormatter;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.ActionOnResourceLeakType;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.EnableInteropType;
import jeus.xml.binding.jeusDD.EngineCommandType;
import jeus.xml.binding.jeusDD.EngineContainerType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PoolingType;
import jeus.xml.binding.jeusDD.ResRefType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.WebComponentType;
import jeus.xml.binding.jeusDD.WebContextGroupType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineContainerDescriptor
implements Serializable {
    private static final long serialVersionUID = -7380829974573197365L;
    public static String wsName = null;
    private String name = "";
    private String commandOption = "";
    public Vector engineNames = new Vector();
    public Vector engineOptions = new Vector();
    private int logDestination = 0;
    private int logBufferSize = 4096;
    private boolean uLogtoFile = false;
    private int uLogBufferSize = 4096;
    private EmailDescriptor userLogEmail = null;
    private Boolean autoRestart;
    private boolean startOnBoot = true;
    private boolean sequentialStart = true;
    private String userClassPath = "";
    private int invocationManagerAction = 0;
    private TransactionManagerDescriptor tmDesc = new TransactionManagerDescriptor();
    private JNDIServerDescriptor nsDesc = new JNDIServerDescriptor();
    private boolean securitySwitch = true;
    private boolean schedulerEnabled = false;
    private JobDescriptor jobDesc = new JobDescriptor();
    private PoolingType schedulerThreadPool;
    private JMXManagerDescriptor jmxDesc = null;
    private JeusNodeType nodeType;
    private EngineContainerType engineContainerType;
    private List applications = Collections.EMPTY_LIST;
    private static final String DEFAULT_CONTAINER_NAME = VirtualDNS.LOCAL_VIRTUALNAME + "_default";
    private List<String> jvmOptionList = new ArrayList<String>();

    public void validate() throws JeusException {
        if (this.name.equals("")) {
            throw new JeusException(JeusMessage_Manager._322);
        }
        if (this.engineNames.size() != this.engineOptions.size()) {
            throw new JeusException(JeusMessage_Manager._323, new String[]{Integer.toString(this.engineNames.size()), Integer.toString(this.engineOptions.size())});
        }
        if (this.engineNames.size() < 1) {
            throw new JeusException(JeusMessage_Manager._324);
        }
        String servlet = null;
        String ejb = null;
        String jms = null;
        String jps = null;
        for (int i = 0; i < this.engineNames.size(); ++i) {
            String engineName = (String)this.engineNames.elementAt(i);
            String temp = engineName.substring(0, engineName.lastIndexOf(95));
            String type = temp.substring(temp.lastIndexOf(95) + 1);
            if (type.equals("servlet")) {
                if (servlet != null) {
                    throw new JeusException(JeusMessage_Manager._325, new String[]{servlet, engineName});
                }
                servlet = engineName;
                continue;
            }
            if (type.equals("ejb")) {
                if (ejb != null) {
                    throw new JeusException(JeusMessage_Manager._325, new String[]{ejb, engineName});
                }
                ejb = engineName;
                continue;
            }
            if (type.equals("jms")) {
                if (jms != null) {
                    throw new JeusException(JeusMessage_Manager._325, new String[]{jms, engineName});
                }
                jms = engineName;
                continue;
            }
            if (type.equals("ws")) {
                if (wsName != null) {
                    throw new JeusException(JeusMessage_Manager._326, new String[]{wsName, engineName});
                }
                wsName = engineName;
                continue;
            }
            if (type.equals("jps")) {
                if (jps != null) {
                    throw new JeusException(JeusMessage_Manager._325, new String[]{jps, engineName});
                }
                jps = engineName;
                continue;
            }
            throw new JeusException(JeusMessage_Manager._327, engineName);
        }
        if (this.logBufferSize < 0) {
            throw new JeusException(JeusMessage_Manager._328, Integer.toString(this.logBufferSize));
        }
        if (this.uLogBufferSize < 0) {
            throw new JeusException(JeusMessage_Manager._329, Integer.toString(this.uLogBufferSize));
        }
        if (this.userLogEmail != null) {
            this.userLogEmail.validate();
        }
        this.tmDesc.validate();
        if (this.jmxDesc != null) {
            this.jmxDesc.validate();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getCommandOption() {
        return this.commandOption;
    }

    public void setCommandOption(String s) {
        this.commandOption = s;
    }

    public int getLogDestination() {
        return this.logDestination;
    }

    public void setLogDestination(int i) {
        this.logDestination = i;
    }

    public int getLogBufferSize() {
        return this.logBufferSize;
    }

    public void setLogBufferSize(int i) {
        this.logBufferSize = i;
    }

    public boolean getULogtoFile() {
        return this.uLogtoFile;
    }

    public void setULogtoFile(boolean b) {
        this.uLogtoFile = b;
    }

    public int getULogBufferSize() {
        return this.uLogBufferSize;
    }

    public void setULogBufferSize(int i) {
        this.uLogBufferSize = i;
    }

    public EmailDescriptor getUserLogEmail() {
        return this.userLogEmail;
    }

    public void setUserLogEmail(EmailDescriptor d) {
        this.userLogEmail = d;
    }

    public Boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(Boolean autoRestart) {
        this.autoRestart = autoRestart;
    }

    public boolean isStartOnBoot() {
        return this.startOnBoot;
    }

    public void setStartOnBoot(boolean b) {
        this.startOnBoot = b;
    }

    public boolean isSequentialStart() {
        return this.sequentialStart;
    }

    public void setSequentialStart(boolean b) {
        this.sequentialStart = b;
    }

    public String getUserClassPath() {
        return this.userClassPath;
    }

    public void setUserClassPath(String s) {
        this.userClassPath = s;
    }

    public TransactionManagerDescriptor getTransactionManagerDescriptor() {
        return this.tmDesc;
    }

    public void setTransactionManagerDescriptor(TransactionManagerDescriptor tmDesc) {
        this.tmDesc = tmDesc;
    }

    public JNDIServerDescriptor getJNDIServerDescriptor() {
        return this.nsDesc;
    }

    public void setJNDIServerDescriptor(JNDIServerDescriptor nsDesc) {
        this.nsDesc = nsDesc;
    }

    public JMXManagerDescriptor getJMXManagerDescriptor() {
        return this.jmxDesc;
    }

    public void setJMXManagerDescriptor(JMXManagerDescriptor jmxDesc) {
        this.jmxDesc = jmxDesc;
    }

    public void setSecuritySwitch(boolean b) {
        this.securitySwitch = b;
    }

    public boolean getSecuritySwitch() {
        return this.securitySwitch;
    }

    public boolean isSchedulerEnabled() {
        return this.schedulerEnabled;
    }

    public void setSchedulerEnabled(boolean b) {
        this.schedulerEnabled = b;
    }

    public JobDescriptor getJobDescriptor() {
        return this.jobDesc;
    }

    public void setJobDescriptor(JobDescriptor jobDesc) {
        this.jobDesc = jobDesc;
    }

    public int getInvocationManagerAction() {
        return this.invocationManagerAction;
    }

    public void setInvocationManagerAction(int i) {
        this.invocationManagerAction = i;
    }

    public void setInvocationManagerAction(ActionOnResourceLeakType type) {
        this.invocationManagerAction = DBDSBindInfoJB.convertToStaticInteger(type);
    }

    public void setLogDestination(String type) {
        this.logDestination = type.equalsIgnoreCase("stdout") ? 0 : (type.equalsIgnoreCase("file") ? 1 : (type.equalsIgnoreCase("both") ? 2 : 0));
    }

    public void setULogtoFile(String targetString) {
        this.uLogtoFile = targetString != null && targetString.equalsIgnoreCase("file");
    }

    public void initContainerLogging() throws Throwable {
        List nodeSystemLogging = this.nodeType.getSystemLogging();
        for (SystemLoggingType node : nodeSystemLogging) {
            JeusLogger logger;
            String loggerNameInNode = node.getName();
            if (loggerNameInNode == null) {
                loggerNameInNode = "jeus";
            }
            if ((logger = (JeusLogger)JeusLogger.getLogger(loggerNameInNode)).isPredefinedLevel()) continue;
            Level level = JeusLevel.parse(node.getLevel().value());
            logger.setLevel(level);
        }
        List systemLogging = this.engineContainerType.getSystemLogging();
        for (SystemLoggingType logging : systemLogging) {
            Logger logger;
            String loggerName = logging.getName();
            if (loggerName == null) {
                JeusLoggerConfiguration.setDefaultConsoleHandler(logging);
                logger = JeusLogger.getLogger("jeus");
            } else {
                logger = loggerName.startsWith("jeus") ? JeusLogger.getLogger(loggerName) : Logger.getLogger(loggerName);
            }
            JeusLoggerConfiguration.configLogger(logger, logging);
        }
        boolean logStdoutToRawFormat = true;
        if (this.engineContainerType.isSetLogStdoutToRawFormat()) {
            logStdoutToRawFormat = this.engineContainerType.isLogStdoutToRawFormat();
        } else if (this.nodeType.isSetLogStdoutToRawFormat()) {
            logStdoutToRawFormat = this.nodeType.isLogStdoutToRawFormat();
        }
        SimpleFormatter.setLogStdoutToRawFormat(logStdoutToRawFormat);
    }

    public void setNodeType(JeusNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public JeusNodeType getNodeType() {
        return this.nodeType;
    }

    public void setEngineContainerRoot(EngineContainerType engineContainerType) {
        this.engineContainerType = engineContainerType;
    }

    public EngineContainerType getEngineContainerRoot() {
        return this.engineContainerType;
    }

    public void initUserLogging() throws Throwable {
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.systemuser");
        SystemLoggingType logging = this.engineContainerType.getUserLogging();
        if (logging != null) {
            JeusLoggerConfiguration.configLogger(logger, logging);
        }
    }

    public void addApplication(ApplicationType applicationType, WebContextGroupType contextGroup) throws JAXBException {
        if (this.applications == Collections.EMPTY_LIST) {
            this.applications = new ArrayList();
        }
        EngineContainerDescriptor.setContextGroup(applicationType, contextGroup, null);
        this.applications.add(applicationType);
    }

    public static void setContextGroup(ApplicationType applicationType, WebContextGroupType contextGroup, Boolean keepGenerated) throws JAXBException {
        List appList = applicationType.getNameAndPathAndDeploymentType();
        for (int i = 0; i < appList.size(); ++i) {
            DeploymentTargetType targetTypes;
            JAXBElement element = (JAXBElement)appList.get(i);
            Object obj = element.getValue();
            if (obj instanceof WebComponentType) {
                WebComponentType webComponent = (WebComponentType)obj;
                targetTypes = webComponent.getDeploymentTarget();
                if (targetTypes != null) continue;
                targetTypes = EngineContainerDescriptor.setDeploymentTarget(contextGroup);
                webComponent.setDeploymentTarget(targetTypes);
                continue;
            }
            if (!(obj instanceof EjbComponentType)) continue;
            EjbComponentType ejbComponent = (EjbComponentType)obj;
            targetTypes = ejbComponent.getDeploymentTarget();
            if (targetTypes == null) {
                targetTypes = EngineContainerDescriptor.setDeploymentTarget(contextGroup);
                ejbComponent.setDeploymentTarget(targetTypes);
            }
            if (ejbComponent.isSetKeepGenerated()) continue;
            ejbComponent.setKeepGenerated(keepGenerated);
        }
    }

    public static DeploymentTargetType setDeploymentTarget(WebContextGroupType contextGroup) throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        DeploymentTargetType targetTypes = objectFactory.createDeploymentTargetType();
        AppTargetType targetType = objectFactory.createAppTargetType();
        targetType.setWebContextGroup(contextGroup);
        if (JeusPropertyValues.JEUS_CATEGORY == 1) {
            targetType.setEngineContainerName(DEFAULT_CONTAINER_NAME);
        } else {
            targetType.setEngineContainerName(JeusManagerPropertyValues.containerName);
        }
        targetTypes.getAllTargetsOrTarget().add(targetType);
        return targetTypes;
    }

    public List getApplications() {
        return this.applications;
    }

    public Vector getEngineNames() {
        return this.engineNames;
    }

    public boolean useMEJB() {
        return this.engineContainerType.isUseMEJB();
    }

    public void initEngineLogging(String engineType) throws Throwable, IllegalAccessException, UnsupportedEncodingException {
        List engines = this.engineContainerType.getEngineCommand();
        for (int i = 0; i < engines.size(); ++i) {
            EngineCommandType engineCommand = (EngineCommandType)engines.get(i);
            SystemLoggingType logging = engineCommand.getSystemLogging();
            String type = engineCommand.getType().value();
            if (!type.equals(engineType)) continue;
            String loggerName = "jeus." + engineType;
            if (logging == null) break;
            JeusLoggerConfiguration.configLogger((JeusLogger)JeusLogger.getLogger(loggerName), logging);
            break;
        }
    }

    public List getLifecycleInvocation() {
        return this.engineContainerType.getLifecycleInvocation();
    }

    public EnableInteropType getEnableInterop() {
        return this.engineContainerType.getEnableInterop();
    }

    public List getResourceRefs() {
        ResRefType resRefType = this.engineContainerType.getResRef();
        if (resRefType == null) {
            return Collections.EMPTY_LIST;
        }
        return resRefType.getJndiInfo();
    }

    public void setSchedulerThreadPool(PoolingType threadPool) {
        this.schedulerThreadPool = threadPool;
    }

    public PoolingType getSchedulerThreadPool() {
        return this.schedulerThreadPool;
    }

    public boolean needToSetApplication() {
        return this.applications == Collections.EMPTY_LIST;
    }

    public List<String> getJvmOptionList() {
        return this.jvmOptionList;
    }
}

