/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import jeus.descriptor.extresource.ExtResourceDescriptor;
import jeus.descriptor.jeusserver.EmailDescriptor;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.descriptor.jeusserver.JMXManagerDescriptor;
import jeus.descriptor.jeusserver.JNDIServerDescriptor;
import jeus.descriptor.jeusserver.JobDescriptor;
import jeus.descriptor.jeusserver.MailSessionDescriptor;
import jeus.descriptor.jeusserver.URLDescriptor;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.datasource.DBDSBindInfo;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.logging.SimpleFormatter;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.ListenerType;
import jeus.xml.binding.jeusDD.PoolingType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.WebadminConfigType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JeusMainDescriptor
implements Serializable {
    public Vector primarys = new Vector(0);
    public Vector connectInfos = new Vector(0);
    public Vector backups = new Vector(0);
    public Map engineContainers = Collections.synchronizedMap(new LinkedHashMap());
    private boolean serialStart = true;
    private Boolean autoRestart = true;
    private boolean classFTP = false;
    private int logDestination = 0;
    private int logBufferSize = 4096;
    private EmailDescriptor email = null;
    private List<DBDSBindInfo> dbDataSource = new Vector<DBDSBindInfo>();
    private List<ClusterDSBindInfo> clusterDataSource = new Vector<ClusterDSBindInfo>();
    public Vector extResources = new Vector();
    public Vector mailSession = new Vector();
    public Vector urls = new Vector();
    private JNDIServerDescriptor nsDesc = new JNDIServerDescriptor();
    private JMXManagerDescriptor jmxDesc = null;
    public Vector conDescs = new Vector();
    private boolean schedulerEnabled = false;
    private JobDescriptor jobDesc = new JobDescriptor();
    private PoolingType schedulerThreadPool;
    private boolean enableJNLP = false;
    private boolean enableWA = false;
    private WebadminConfigType wact;
    private boolean enableRLA = true;
    private JeusSystemType jeusSystem;
    private boolean isSecuritySwitch;
    private JeusNodeType jeusNode;

    public void validate() throws JeusException {
        if (this.primarys.size() == 0) {
            throw new JeusException(JeusMessage_Manager._330);
        }
        if (this.logBufferSize < 0) {
            throw new JeusException(JeusMessage_Manager._331, Integer.toString(this.logBufferSize));
        }
        EngineContainerDescriptor.wsName = null;
        Hashtable<String, String> enginelist = new Hashtable<String, String>();
        for (EngineContainerDescriptor desc : this.engineContainers.values()) {
            desc.validate();
            Enumeration e1 = desc.engineNames.elements();
            while (e1.hasMoreElements()) {
                String name = (String)e1.nextElement();
                if (enginelist.get(name) != null) {
                    throw new JeusException(JeusMessage_Manager._332, name);
                }
                enginelist.put(name, name);
            }
        }
        enginelist.clear();
        for (DBDSBindInfo dbds : this.dbDataSource) {
            dbds.validate();
        }
        Enumeration e = this.extResources.elements();
        while (e.hasMoreElements()) {
            ((ExtResourceDescriptor)e.nextElement()).validate();
        }
        e = this.mailSession.elements();
        while (e.hasMoreElements()) {
            ((MailSessionDescriptor)e.nextElement()).validate();
        }
        e = this.urls.elements();
        while (e.hasMoreElements()) {
            ((URLDescriptor)e.nextElement()).validate();
        }
        this.nsDesc.validate();
        if (this.jmxDesc != null) {
            this.jmxDesc.validate();
        }
    }

    public Boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(Boolean autoRestart) {
        this.autoRestart = autoRestart;
    }

    public boolean isSerialStart() {
        return this.serialStart;
    }

    public void setSerialStart(boolean b) {
        this.serialStart = b;
    }

    public boolean getClassFTP() {
        return this.classFTP;
    }

    public void setClassFTP(boolean b) {
        this.classFTP = b;
    }

    public int getLogDestination() {
        return this.logDestination;
    }

    public void setLogDestination(int i) {
        this.logDestination = i;
    }

    public int getLogBufferSize() {
        return this.logBufferSize;
    }

    public void setLogBufferSize(int i) {
        this.logBufferSize = i;
    }

    public EmailDescriptor getEmailDescriptor() {
        return this.email;
    }

    public void setEmailDescriptor(EmailDescriptor email) {
        this.email = email;
    }

    public JNDIServerDescriptor getJNDIServerDescriptor() {
        return this.nsDesc;
    }

    public void setJNDIServerDescriptor(JNDIServerDescriptor nsDesc) {
        this.nsDesc = nsDesc;
    }

    public JMXManagerDescriptor getJMXManagerDescriptor() {
        return this.jmxDesc;
    }

    public void setJMXManagerDescriptor(JMXManagerDescriptor jmxDesc) {
        this.jmxDesc = jmxDesc;
    }

    public boolean isSchedulerEnabled() {
        return this.schedulerEnabled;
    }

    public void setSchedulerEnabled(boolean b) {
        this.schedulerEnabled = b;
    }

    public JobDescriptor getJobDescriptor() {
        return this.jobDesc;
    }

    public void setJobDescriptor(JobDescriptor jobDesc) {
        this.jobDesc = jobDesc;
    }

    public boolean isEnableJNLP() {
        return this.enableJNLP;
    }

    public void setEnableJNLP(boolean b) {
        this.enableJNLP = b;
    }

    public boolean isEnableWA() {
        return this.enableWA;
    }

    public void setEnableWA(boolean b) {
        this.enableWA = b;
    }

    public WebadminConfigType getWebadminConfigType() {
        return this.wact;
    }

    public void setWebadminConfigType(WebadminConfigType wact) {
        this.wact = wact;
    }

    public boolean isEnableRLA() {
        return this.enableRLA;
    }

    public void setEnableRLA(boolean b) {
        this.enableRLA = b;
    }

    public void setLogDestination(String type) {
        this.logDestination = type != null && type.equalsIgnoreCase("stdout") ? 0 : (type != null && type.equalsIgnoreCase("file") ? 1 : (type != null && type.equalsIgnoreCase("both") ? 2 : 0));
    }

    public void initJeusServerLogger(String nodeName) throws Throwable {
        JeusNodeType node = this.getNodeType(nodeName);
        List systemLogging = node.getSystemLogging();
        for (int i = 0; i < systemLogging.size(); ++i) {
            Logger logger;
            SystemLoggingType logging = (SystemLoggingType)systemLogging.get(i);
            String loggerName = logging.getName();
            if (loggerName == null) {
                JeusLoggerConfiguration.setDefaultConsoleHandler(logging);
                logger = JeusLogger.getLogger("jeus");
            } else {
                logger = loggerName.startsWith("jeus") ? JeusLogger.getLogger(loggerName) : Logger.getLogger(loggerName);
            }
            JeusLoggerConfiguration.configLogger(logger, logging);
        }
        boolean logStdoutToRawFormat = true;
        if (node.isSetLogStdoutToRawFormat()) {
            logStdoutToRawFormat = node.isLogStdoutToRawFormat();
        }
        SimpleFormatter.setLogStdoutToRawFormat(logStdoutToRawFormat);
    }

    private JeusNodeType getNodeType(String nodeName) {
        List nodes = this.jeusSystem.getNode();
        for (int i = 0; i < nodes.size(); ++i) {
            JeusNodeType nodeType = (JeusNodeType)nodes.get(i);
            if (!nodeType.getName().equals(nodeName)) continue;
            return nodeType;
        }
        throw new RuntimeException("The nodename is not specified in the JeusMain.xml");
    }

    public void setJeusMainRoot(JeusSystemType jeusSystemElem) {
        this.jeusSystem = jeusSystemElem;
    }

    public List getApplication() {
        return this.jeusSystem.getApplication();
    }

    public JeusSystemType getJeusSystem() {
        return this.jeusSystem;
    }

    public boolean isSecuritySwitch() {
        return this.isSecuritySwitch;
    }

    public void setSecuritySwitch(boolean isSecuritySwitch) {
        this.isSecuritySwitch = isSecuritySwitch;
    }

    public void setSchedulerThreadPool(PoolingType threadPool) {
        this.schedulerThreadPool = threadPool;
    }

    public PoolingType getSchedulerThreadPool() {
        return this.schedulerThreadPool;
    }

    public void setJeusNode(JeusNodeType oneNode) {
        this.jeusNode = oneNode;
    }

    public JeusNodeType getJeusNode() {
        return this.jeusNode;
    }

    public void setAllDatabaseInformation(List<DBDSBindInfo> infoList) {
        this.dbDataSource = infoList;
    }

    public List<DBDSBindInfo> getAllDatabaseInformation() {
        return new Vector<DBDSBindInfo>(this.dbDataSource);
    }

    public void setAllClusterDataSources(List<ClusterDSBindInfo> infoList) {
        this.clusterDataSource = infoList;
    }

    public List<ClusterDSBindInfo> getAllClusterDataSources() {
        return new Vector<ClusterDSBindInfo>(this.clusterDataSource);
    }

    public ListenerType getListener() {
        return this.jeusNode.getListener();
    }
}

