/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.Serializable;
import jeus.util.JeusException;

public class ResourceConfigurationProperty
implements Serializable {
    private static final long serialVersionUID = -5333176356514908954L;
    private String name;
    private String type;
    private String value;

    public ResourceConfigurationProperty() {
    }

    public ResourceConfigurationProperty(String name, String type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public void validate() throws JeusException {
        if (this.name == null || this.name.equals("")) {
            throw new JeusException("configuration property name can't be empty");
        }
        if (this.type == null || this.type.equals("")) {
            throw new JeusException("configuration property type can't be empty");
        }
        if (!(this.type.equals("java.lang.Boolean") || this.type.equals("java.lang.String") || this.type.equals("java.lang.Integer") || this.type.equals("java.lang.Double") || this.type.equals("java.lang.Byte") || this.type.equals("java.lang.Short") || this.type.equals("java.lang.Long") || this.type.equals("java.lang.Float") || this.type.equals("java.lang.Character") || this.type.equals("java.util.Properties"))) {
            throw new JeusException("database property type [" + this.type + "] is unknown");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String s) {
        this.value = s;
    }

    public String stringify() {
        return this.name + "::" + this.type + "::" + this.value;
    }

    public static ResourceConfigurationProperty fromString(String s) {
        ResourceConfigurationProperty prop = new ResourceConfigurationProperty();
        prop.setName(s.substring(0, s.indexOf("::")));
        s = s.substring(s.indexOf("::") + 2);
        prop.setType(s.substring(0, s.indexOf("::")));
        prop.setValue(s.substring(s.indexOf("::") + 2));
        return prop;
    }

    public String toString() {
        return this.stringify();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceConfigurationProperty that = (ResourceConfigurationProperty)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

