/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.objectbase;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.naming.InitialContext;
import jeus.util.ErrorMsgManager;
import jeus.util.HostInfo;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB2;

public class RMIEJBMetaDataImpl
implements EJBMetaData,
Serializable {
    private static final long serialVersionUID = -2455554251279186912L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.bean.metadata");
    transient EJBHome ejbHomeStub = null;
    private String jndiUrl;
    private String exportName;
    private Class ejbHomeClass;
    private Class pKeyClass;
    private Class ejbObjectClass;
    private boolean isSessionBean;
    private boolean isStatelessSessionBean;

    public RMIEJBMetaDataImpl(EJBHome ejbHomeStub, Class ejbHomeClass, Class ejbObjectClass, Class pKeyClass, String exportName, String jndiUrl, boolean isSessionBean, boolean isStatelessSessionBean) throws RemoteException {
        this.ejbHomeStub = ejbHomeStub;
        this.exportName = exportName;
        this.jndiUrl = HostInfo.fromServerAddress(jndiUrl);
        this.pKeyClass = pKeyClass;
        this.ejbHomeClass = ejbHomeClass;
        this.ejbObjectClass = ejbObjectClass;
        this.isSessionBean = isSessionBean;
        this.isStatelessSessionBean = isStatelessSessionBean;
    }

    public Class getHomeInterfaceClass() {
        return this.ejbHomeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.ejbObjectClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeStub;
    }

    public Class getPrimaryKeyClass() {
        if (this.pKeyClass == null) {
            if (logger.isLoggable(JeusMessage_EJB2._2159_LEVEL)) {
                logger.logp(JeusMessage_EJB2._2159_LEVEL, "RMIEJBMetaDataImpl", "getPrimaryKeyClass", JeusMessage_EJB2._2159);
            }
            throw new RuntimeException(ErrorMsgManager.getLocalizedString(JeusMessage_EJB2._2159));
        }
        return this.pKeyClass;
    }

    public boolean isSession() {
        return this.isSessionBean;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSessionBean;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.jndiUrl = in.readUTF();
        this.exportName = in.readUTF();
        this.ejbHomeStub = this.innerGetEJBHome();
        ClassLoader loader = this.ejbHomeStub.getClass().getClassLoader();
        String name = in.readUTF();
        this.ejbHomeClass = loader.loadClass(name);
        name = in.readUTF();
        this.pKeyClass = name.equals("null") ? null : loader.loadClass(name);
        name = in.readUTF();
        this.ejbObjectClass = loader.loadClass(name);
        this.isSessionBean = in.readBoolean();
        this.isStatelessSessionBean = in.readBoolean();
    }

    private EJBHome innerGetEJBHome() throws RemoteException {
        if (this.ejbHomeStub == null) {
            try {
                Properties props = new Properties();
                props.put("java.naming.provider.url", this.jndiUrl);
                props.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
                InitialContext ctx = new InitialContext(props);
                this.ejbHomeStub = (EJBHome)ctx.lookup(this.exportName);
            }
            catch (Exception ex) {
                if (logger.isLoggable(JeusMessage_EJB2._2162_LEVEL)) {
                    logger.logp(JeusMessage_EJB2._2162_LEVEL, "RMIEJBMetaDataImpl", "innerGetEJBHome", JeusMessage_EJB2._2162, new Object[]{this.exportName, this.jndiUrl});
                }
                throw new RemoteException(ErrorMsgManager.getLocalizedString(JeusMessage_EJB2._2162, new Object[]{this.exportName, this.jndiUrl}), ex);
            }
        }
        return this.ejbHomeStub;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.jndiUrl);
        out.writeUTF(this.exportName);
        out.writeUTF(this.ejbHomeClass.getName());
        if (this.pKeyClass != null) {
            out.writeUTF(this.pKeyClass.getName());
        } else {
            out.writeUTF("null");
        }
        out.writeUTF(this.ejbObjectClass.getName());
        out.writeBoolean(this.isSessionBean);
        out.writeBoolean(this.isStatelessSessionBean);
    }
}

