/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.objectbase;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import jeus.ejb.bean.objectbase.SessionCluster;
import jeus.ejb.client.RemoteEJBHomeClientHandler;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;

public class RMIHandleImpl
implements Handle,
Serializable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.bean.handle");
    transient EJBObject ejbObject;
    public Serializable pkey = null;
    public String sessionID = null;
    private HomeHandle homeHandle;
    private boolean isUseDynamicProxy;

    public RMIHandleImpl(EJBObject obj, String sessionID, HomeHandle homeHandle) {
        this.sessionID = sessionID;
        this.ejbObject = obj;
        this.homeHandle = homeHandle;
    }

    public RMIHandleImpl(EJBObject obj, String sessionID, HomeHandle homeHandle, boolean isUseDynamicProxy) {
        this.sessionID = sessionID;
        this.ejbObject = obj;
        this.homeHandle = homeHandle;
        this.isUseDynamicProxy = isUseDynamicProxy;
    }

    RMIHandleImpl(EJBObject obj, Serializable pkey, HomeHandle homeHandle) {
        this.pkey = pkey;
        this.ejbObject = obj;
        this.homeHandle = homeHandle;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.ejbObject != null) {
            return this.ejbObject;
        }
        EJBHome home = this.homeHandle.getEJBHome();
        try {
            if (this.pkey != null) {
                return (EJBObject)RMIHandleImpl.getEntityObject(this.pkey, home);
            }
            if (this.sessionID != null && !this.sessionID.equals("")) {
                return (EJBObject)RMIHandleImpl.getStatefulSessionObject(this.sessionID, home);
            }
            return (EJBObject)RMIHandleImpl.getStatelessSessionObject(home);
        }
        catch (Exception ex) {
            throw new RemoteException("Exception in Handle", ex);
        }
    }

    public static Object getEntityObject(Object key, Object testStub) throws IllegalAccessException, InvocationTargetException {
        Method[] methods = testStub.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("findByPrimaryKey")) continue;
            return method.invoke(testStub, key);
        }
        throw new JeusRuntimeException("No findByPrimaryKey method for the class " + testStub.getClass());
    }

    public static Object getStatefulSessionObject(String key, Object testStub) throws Exception {
        InvocationHandler ih;
        if (Proxy.isProxyClass(testStub.getClass()) && (ih = Proxy.getInvocationHandler(testStub)) instanceof RemoteEJBHomeClientHandler) {
            RemoteEJBHomeClientHandler ejbhomeCH = (RemoteEJBHomeClientHandler)ih;
            testStub = ejbhomeCH.findByInstanceKey(key);
            return testStub;
        }
        testStub = ((SessionCluster)testStub).findByInstanceKey(key);
        return testStub;
    }

    public static Object getStatelessSessionObject(Object testStub) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method createMethod = testStub.getClass().getMethod("create", null);
        testStub = createMethod.invoke(testStub, null);
        return testStub;
    }

    public boolean isUseDynamicProxy() {
        return this.isUseDynamicProxy;
    }
}

