/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.io.DataInput;
import java.io.DataOutput;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Map;
import javax.ejb.EJBException;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.InterceptorContextProvider;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.TMCommonService;
import jeus.transaction.client.TMContextCarrier;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.trace.GID;
import jeus.util.trace.GIDException;

public class EJBClientInterceptor
implements ClientInterceptor {
    private static final String RETURN_TX_KEY = "RETURN_TX";
    private static final long serialVersionUID = 2254896728115055864L;

    public void intercept(DataOutput dout, InterceptorContextProvider invoker) throws Exception {
        byte[] currentSubject;
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");
        if (logger.isLoggable(JeusMessage_EJB11._8201_LEVEL)) {
            logger.log(JeusMessage_EJB11._8201_LEVEL, JeusMessage_EJB11._8201, new Object[]{Thread.currentThread(), Thread.currentThread().isInterrupted()});
        }
        if (JeusManagerProperties.CHECK_INTERRUPTED_STATUS && Thread.interrupted()) {
            throw new EJBException("the current thread is interrrupted");
        }
        Map context = invoker.getContext();
        try {
            currentSubject = LoginService.getCurrentSubjectSerialized();
        }
        catch (ServiceException e) {
            throw new EJBException(e);
        }
        catch (SecurityException e) {
            throw new EJBException(e);
        }
        if (TMCommonService.isTxTimeout()) {
            throw new EJBException(JeusMessageBundles.getMessage(JeusMessage_EJB12._9104));
        }
        byte[] txContext = ContextSenderReceiver.getPropagationContext();
        if (txContext[0] == -2 || txContext[0] == -3) {
            context.put(RETURN_TX_KEY, RETURN_TX_KEY);
        }
        dout.writeByte(0);
        dout.writeInt(currentSubject.length);
        dout.write(currentSubject);
        dout.write(txContext);
        byte[] gidBytes = GID.getCurrentGIDBytes();
        byte[] lenBytes = new byte[4];
        int length = 0;
        if (GID.useGID) {
            if (gidBytes == null) {
                GID.createCurrentGID();
                GID.increaseSeqNumber();
                gidBytes = GID.getCurrentGIDBytes();
            } else {
                GID.increaseSeqNumber();
            }
            length = gidBytes.length;
        }
        ByteUtil.putInt(lenBytes, 0, length);
        dout.write(lenBytes);
        if (length > 0) {
            dout.write(gidBytes);
        }
    }

    public void afterIntercept(DataInput din, InterceptorContextProvider invoker) throws Exception {
        if (invoker.getContext().get(RETURN_TX_KEY) != null) {
            ContextSenderReceiver.readTMCtx(din);
        }
        byte[] lenBytes = new byte[4];
        din.readFully(lenBytes);
        int gidLen = ByteUtil.convertToInt(lenBytes);
        if (gidLen > 0) {
            byte[] gidBytes = new byte[gidLen];
            din.readFully(gidBytes);
            GID.setCurrentGID(gidBytes);
        }
    }

    public void exceptionOccurred(Throwable exception, InterceptorContextProvider interceptorContextProvider) throws Throwable {
        if (exception instanceof TMContextCarrier) {
            TMContextCarrier car = (TMContextCarrier)exception;
            ContextSenderReceiver.contextPropagated(car.ctx, null);
            exception = car.ex;
        }
        if (exception instanceof GIDException) {
            GIDException gex = (GIDException)exception;
            GID.setCurrentGID(gex.gidBytes);
            exception = gex.ex;
        }
        if (exception instanceof ServerException) {
            ServerException e = (ServerException)exception;
            if (e.detail != null && e.detail instanceof RemoteException) {
                throw (RemoteException)e.detail;
            }
        }
        throw exception;
    }
}

