/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.NoSuchEJBException;
import javax.naming.NamingException;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.bean.rmi.EntityStubClusterSupport;
import jeus.ejb.bean.rmi.HomeStubClusterSupport;
import jeus.ejb.bean.rmi.StatefulSessionStubClusterSupport;
import jeus.ejb.bean.rmi.StatelessSessionStubClusterSupport;
import jeus.ejb.container.ContainerException;
import jeus.ejb.ejbserver.EJBServerAlreadyDownException;
import jeus.ejb.ejbserver.EJBSuspendException;
import jeus.jndi.CacheableContext;
import jeus.jndi.JNSContextFactory;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StubClusterSupport
implements JEUSClusterStub,
Serializable {
    private static final long serialVersionUID = -2706689862411129339L;
    private DynamicLinkRef cluster;
    private String exportName;
    private Object stub;
    private static final int CHANGED_BY_ANOTHER_THREAD = 1;
    private static final int FAIL_TO_CHANGE_STUB = 0;
    private static final int CHANGED_STUB = 2;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.cluster");
    public static final int HOME_CLUSTER = 0;
    public static final int STATELESS_CLUSTER = 1;
    public static final int STATEFUL_CLUSTER = 2;
    public static final int ENTITY_CLUSTER = 3;

    public StubClusterSupport(Object stub) {
        this.stub = stub;
    }

    public StubClusterSupport() {
    }

    public static StubClusterSupport createStubClusterSupport(int type, Object stub) {
        switch (type) {
            case 0: {
                return new HomeStubClusterSupport(stub);
            }
            case 1: {
                return new StatelessSessionStubClusterSupport(stub);
            }
            case 2: {
                return new StatefulSessionStubClusterSupport(stub);
            }
            case 3: {
                return new EntityStubClusterSupport(stub);
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void __jeus_setCluster(String exportName, DynamicLinkRef linkRef) {
        this.exportName = exportName;
        this.cluster = linkRef;
    }

    public DynamicLinkRef getCluster() {
        return this.cluster;
    }

    public synchronized String getExportName() {
        return this.exportName;
    }

    public synchronized Object getStub() {
        return this.stub;
    }

    public void handleException(Exception ex, String currExportName, boolean idempotent) throws Exception {
        boolean failoverException = this.isFailoverException(idempotent, ex);
        if (!failoverException) {
            throw ex;
        }
        this.handleFailover(currExportName, ex);
    }

    public void handleFailover(String currExportName, Exception ex) throws Exception {
        switch (this.changeStub(currExportName)) {
            case 0: {
                throw ex;
            }
            case 1: 
            case 2: {
                return;
            }
        }
        throw ex;
    }

    public boolean isFailoverException(boolean idempotent, Throwable ex) {
        Throwable detail = ex instanceof RemoteException ? ((RemoteException)ex).detail : ex.getCause();
        if (detail instanceof ContainerException) {
            detail = detail.getCause();
        }
        boolean failoverException = false;
        if (ex instanceof NoSuchObjectException || ex instanceof NoSuchEJBException) {
            failoverException = true;
        } else if (detail instanceof NoSuchObjectException || detail instanceof NoSuchEJBException || detail instanceof EJBServerAlreadyDownException || detail instanceof EJBSuspendException) {
            failoverException = true;
        } else if (idempotent) {
            if (ex instanceof UnmarshalException && !(detail instanceof ClassNotFoundException)) {
                failoverException = true;
            } else if (detail instanceof SocketException || detail instanceof InterruptedIOException) {
                failoverException = true;
            }
        } else if (detail instanceof NoRouteToHostException || detail instanceof ConnectException) {
            failoverException = true;
        }
        if (logger.isLoggable(JeusMessage_EJB12._9005_LEVEL)) {
            logger.log(JeusMessage_EJB12._9005_LEVEL, JeusMessage_EJB12._9005, new Object[]{failoverException ? "" : " NOT ", ex, detail});
        }
        return failoverException;
    }

    /*
     * Exception decompiling
     */
    private int changeStub(String failedCurrClusteredExportName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 22[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String linksToURLs(Vector<String> currLinks) {
        StringBuffer _exportUrls = new StringBuffer();
        for (int i = 0; i < currLinks.size(); ++i) {
            String link = currLinks.get(i);
            if (i < currLinks.size() - 1) {
                _exportUrls.append(DynamicLinkRef.getClusterExportUrl(link) + ",");
                continue;
            }
            _exportUrls.append(DynamicLinkRef.getClusterExportUrl(link));
        }
        return _exportUrls.toString();
    }

    private String arrayToString(String[] array) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String aString = array[i];
            if (i < array.length - 1) {
                stringBuffer.append(aString + ",");
                continue;
            }
            stringBuffer.append(aString);
        }
        return stringBuffer.toString();
    }

    private Object lookupFromServer(String url, String exportName) throws NamingException {
        Hashtable<String, String> _env = new Hashtable<String, String>();
        _env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        _env.put("java.naming.provider.url", url);
        CacheableContext ctx = (CacheableContext)new JNSContextFactory().getInitialContext((Hashtable)_env);
        ctx.removeCache(exportName);
        return ctx.lookup(exportName);
    }

    private Object lookupLinkFromServer(String urls, String exportName) throws NamingException {
        Hashtable<String, String> _env = new Hashtable<String, String>();
        _env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        _env.put("java.naming.provider.url", urls);
        CacheableContext ctx = (CacheableContext)new JNSContextFactory().getInitialContext((Hashtable)_env);
        ctx.removeCache(exportName);
        return ctx.lookupLink(exportName);
    }

    protected abstract Object getActualStubFromHome(Object var1) throws Exception;
}

