/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.RemoteBusinessHomeClientHandler;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class BusinessObjectFactory
implements ObjectFactory {
    public static final String ADDR_HOME_JNDINAME = "home.jndiname";
    public static final String ADDR_INTERFACE = "interface";
    public static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        StringRefAddr homeAddr = (StringRefAddr)ref.get(ADDR_HOME_JNDINAME);
        StringRefAddr interfaceAddr = (StringRefAddr)ref.get(ADDR_INTERFACE);
        String homeJndiName = (String)homeAddr.getContent();
        String interfaceName = (String)interfaceAddr.getContent();
        try {
            InitialContext ctx = new InitialContext(environment);
            BusinessHome home = (BusinessHome)ctx.lookup(homeJndiName);
            Object businessObject = home.create(interfaceName);
            if (home instanceof RemoteBusinessHomeClientHandler) {
                StubClusterSupport cluster;
                if (logger.isLoggable(JeusMessage_EJB12._9306_LEVEL) && (cluster = ((RemoteInvokerClient)((Object)Proxy.getInvocationHandler(businessObject))).getClusterSupport()) != null) {
                    logger.log(JeusMessage_EJB12._9306_LEVEL, "[BusinessObjectFactory] current export name : {0}", new Object[]{cluster.getExportName()});
                }
            } else if (logger.isLoggable(JeusMessage_EJB12._9305_LEVEL)) {
                logger.log(JeusMessage_EJB12._9305_LEVEL, "[BusinessObjectFactory] EJB3 local view home create-{0}, its class loader-{1}", new Object[]{businessObject, businessObject.getClass().getClassLoader()});
            }
            ctx.close();
            return businessObject;
        }
        catch (NamingException ex) {
            throw ex;
        }
        catch (EJBException ex) {
            throw ex;
        }
        catch (RemoteException ex) {
            throw new EJBException(ex);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }
}

