/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jeus.ejb.client.ObjectReplacetInputStream;

public class ClassReloader {
    private static final ClassLoader SYSTEM_CLASSLOADER = ClassLoader.getSystemClassLoader();

    public static boolean checkObjectSerialization(String interfaceName, Object obj) {
        ClassLoader classloaderOfArg;
        if (obj != null && !(obj instanceof Serializable) && (classloaderOfArg = obj.getClass().getClassLoader()) != null && classloaderOfArg != SYSTEM_CLASSLOADER) {
            throw new RuntimeException("Failed to serialize " + obj.getClass().getName() + " of " + interfaceName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object reloadObject(ClassLoader classLoaer, Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bout = null;
        ByteArrayInputStream bin = null;
        ObjectOutputStream oout = null;
        ObjectInputStream oin = null;
        try {
            bout = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(bout);
            oout.writeObject(obj);
            bin = new ByteArrayInputStream(bout.toByteArray());
            oin = new ObjectReplacetInputStream(bin, classLoaer);
            Object object = oin.readObject();
            return object;
        }
        finally {
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {}
            }
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static boolean isIsolatedClassloadingMode(ClassLoader classLoaderOfCaller, ClassLoader classLoaderOfCallee, String classNameToLoad) throws ClassNotFoundException {
        Class<?> loadedClassOfCallee;
        if (classLoaderOfCaller == classLoaderOfCallee) {
            return false;
        }
        Class<?> loadedClassOfCaller = classLoaderOfCaller.loadClass(classNameToLoad);
        return loadedClassOfCaller != (loadedClassOfCallee = classLoaderOfCallee.loadClass(classNameToLoad));
    }
}

