/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.util.HashMap;
import java.util.Map;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class EJBLoaderFinder {
    private static final Map<String, ClassLoader> exportNameToLoader = new HashMap<String, ClassLoader>();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");

    private EJBLoaderFinder() {
    }

    public static void addLoader(String exportName, ClassLoader ejbClassLoader) {
        ClassLoader previousLoader = exportNameToLoader.put(exportName, ejbClassLoader);
        if (previousLoader != null && logger.isLoggable(JeusMessage_EJB12._9401_LEVEL)) {
            logger.log(JeusMessage_EJB12._9401_LEVEL, JeusMessage_EJB12._9401, (Object)exportName);
        }
    }

    public static void removeLoader(String exportName) {
        ClassLoader previousLoader = exportNameToLoader.remove(exportName);
        if (previousLoader != null && logger.isLoggable(JeusMessage_EJB12._9402_LEVEL)) {
            logger.log(JeusMessage_EJB12._9402_LEVEL, JeusMessage_EJB12._9402, (Object)exportName);
        }
    }

    public static ClassLoader getLoader(String exportName) {
        ClassLoader classLoader = exportNameToLoader.get(exportName);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }
}

