/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentHashMap;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.ClassReloader;
import jeus.ejb.client.RemoteEJBHomeClientHandler;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.ejb.util.MethodUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class RemoteBusinessHomeClientHandler
extends RemoteInvokerClient
implements BusinessHome,
Serializable {
    private static final long serialVersionUID = 60L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");
    private static final JeusLogger conLogger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.container");
    public static final String createMethodSig;
    public static final String findByInstanceKeyMethodSig;
    public static final String pingMethodSig;
    private static ConcurrentHashMap<String, CalleeEJBInfo> calleeEJBInfosInSameJVM;
    private String ejbId;

    public RemoteBusinessHomeClientHandler(RemoteInvoker stub) {
        super(stub);
    }

    public void setCalleeEJBId(String ejbId) {
        this.ejbId = ejbId;
    }

    public void ping() throws RemoteException {
        CalleeEJBInfo calleeEJBInfo = null;
        if (this.ejbId != null && (calleeEJBInfo = calleeEJBInfosInSameJVM.get(this.ejbId)) != null) {
            BusinessHome homeImpl = calleeEJBInfo.getBusinessHome();
            homeImpl.ping();
        } else {
            RemoteInvocationImpl invocation = new RemoteInvocationImpl();
            invocation.setSignature(pingMethodSig);
            this.invokeRemoteMethod(invocation);
        }
    }

    public Object create(String interfaze) throws RemoteException {
        Object businessObject = null;
        CalleeEJBInfo calleeEJBInfo = null;
        if (this.ejbId != null && (calleeEJBInfo = calleeEJBInfosInSameJVM.get(this.ejbId)) != null) {
            boolean isIsolatedClassloadingMode;
            ClassLoader classLoaderOfCaller = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoaderOfCallee = calleeEJBInfo.getClassLoader();
            try {
                isIsolatedClassloadingMode = ClassReloader.isIsolatedClassloadingMode(classLoaderOfCaller, classLoaderOfCallee, interfaze);
            }
            catch (ClassNotFoundException ex) {
                if (this.clustered) {
                    RemoteBusinessHomeClientHandler.removeEJBInfoInSameJVM(this.ejbId);
                    return this.executeRemoteCreateMethodCall(interfaze);
                }
                throw new RuntimeException("Failed to check classloading mode", ex);
            }
            BusinessHome homeImpl = calleeEJBInfo.getBusinessHome();
            businessObject = this.executeLocalCreateMethodCall(homeImpl, interfaze);
            if (isIsolatedClassloadingMode) {
                try {
                    businessObject = ClassReloader.reloadObject(classLoaderOfCaller, businessObject);
                }
                catch (Exception e) {
                    throw new RuntimeException("failed to reload BusinessHome with caller class loader.", e);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9304_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9304_LEVEL, "(ISOLATED LOCAL CALL) EJB3 remote view home create-{0}, its class loader-{1}", new Object[]{businessObject, businessObject.getClass().getClassLoader()});
                }
            } else if (logger.isLoggable(JeusMessage_EJB12._9302_LEVEL)) {
                logger.log(JeusMessage_EJB12._9302_LEVEL, "(SHARED LOCAL CALL) EJB3 remote view home create-{0}, its class loader-{1}", new Object[]{businessObject, businessObject.getClass().getClassLoader()});
            }
            return businessObject;
        }
        return this.executeRemoteCreateMethodCall(interfaze);
    }

    private Object executeLocalCreateMethodCall(BusinessHome homeImpl, String interfaze) throws RemoteException {
        try {
            Object obj = homeImpl.create(interfaze);
            if (this.clustered) {
                this.propagateClusterInfo(obj);
            }
            return obj;
        }
        catch (Exception ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(createMethodSig), ex)) {
                RemoteBusinessHomeClientHandler.removeEJBInfoInSameJVM(this.ejbId);
                return this.executeRemoteCreateMethodCall(interfaze);
            }
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RemoteException("", ex);
        }
    }

    private Object executeRemoteCreateMethodCall(String interfaze) throws RemoteException {
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setSignature(createMethodSig);
        invocation.setArgs(new Object[]{interfaze});
        Object businessObject = this.invokeRemoteMethod(invocation);
        if (logger.isLoggable(JeusMessage_EJB12._9303_LEVEL)) {
            logger.log(JeusMessage_EJB12._9303_LEVEL, "(REMOTE CALL) EJB3 remote view home create-{0}, its class loader-{1}", new Object[]{businessObject, businessObject.getClass().getClassLoader()});
        }
        return businessObject;
    }

    public Object findByInstanceKey(String interfaze, String sessionID) throws RemoteException {
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setSignature(findByInstanceKeyMethodSig);
        invocation.setArgs(new Object[]{interfaze, sessionID});
        return this.invokeRemoteMethod(invocation);
    }

    private Object invokeRemoteMethod(RemoteInvocationImpl invocation) throws RemoteException {
        try {
            Object obj = super.invoke(invocation);
            if (this.clustered) {
                this.propagateClusterInfo(obj);
            }
            return obj;
        }
        catch (Throwable ex) {
            if (ex instanceof ServerException) {
                ServerException e = (ServerException)ex;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex = e.detail;
                }
            }
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RemoteException("", ex);
        }
    }

    private void propagateClusterInfo(Object obj) {
        InvocationHandler handler;
        if (obj instanceof JEUSClusterStub) {
            ((JEUSClusterStub)obj).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
        } else if (obj != null && Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof JEUSClusterStub) {
            ((JEUSClusterStub)((Object)handler)).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
        }
    }

    public static void putEJBInfoInSameJVM(String ejbId, BusinessHome home, ClassLoader loader) {
        CalleeEJBInfo ejbInfo = calleeEJBInfosInSameJVM.get(ejbId);
        if (ejbInfo != null) {
            BusinessHome oldHome = ejbInfo.getBusinessHome();
            ClassLoader oldClassLoader = ejbInfo.getClassLoader();
            if (oldHome != null && oldHome != home && oldClassLoader != null && oldClassLoader != loader && conLogger.isLoggable(JeusMessage_EJB12._9351_LEVEL)) {
                conLogger.log(JeusMessage_EJB12._9351_LEVEL, "[{0}] LEAK DETECTED for static map of {1} used for local call opt. ( ejbId = {2} )", new Object[]{RemoteEJBHomeClientHandler.class.getName(), "business home impls and class loaders", ejbId});
            }
        }
        calleeEJBInfosInSameJVM.put(ejbId, new CalleeEJBInfo(home, loader));
    }

    public static void removeEJBInfoInSameJVM(String ejbId) {
        calleeEJBInfosInSameJVM.remove(ejbId);
    }

    static {
        try {
            Method createMethod = RemoteBusinessHomeClientHandler.class.getMethod("create", String.class);
            createMethodSig = MethodUtils.getSignature(createMethod);
            Method findByInstanceKeyMethod = RemoteBusinessHomeClientHandler.class.getMethod("findByInstanceKey", String.class, String.class);
            findByInstanceKeyMethodSig = MethodUtils.getSignature(findByInstanceKeyMethod);
            Method pingMethod = RemoteBusinessHomeClientHandler.class.getMethod("ping", new Class[0]);
            pingMethodSig = MethodUtils.getSignature(pingMethod);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        calleeEJBInfosInSameJVM = new ConcurrentHashMap();
    }

    private static class CalleeEJBInfo {
        private BusinessHome businessHome;
        private ClassLoader classLoader;

        public CalleeEJBInfo(BusinessHome businessHome, ClassLoader classLoader) {
            this.businessHome = businessHome;
            this.classLoader = classLoader;
        }

        public BusinessHome getBusinessHome() {
            return this.businessHome;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

