/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import jeus.ejb.client.ClassReloader;
import jeus.ejb.client.RemoteEJBHomeClientHandler;
import jeus.ejb.client.RemoteInvokerHandler;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.ejb.util.InvocationHandlerUtil;
import jeus.ejb.util.MethodUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class RemoteBusinessObjectClientHandler
extends RemoteInvokerClient
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 60L;
    public static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");
    private static final JeusLogger conLogger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.container");
    private static ConcurrentHashMap<String, CalleeEJBInfo> calleeEJBInfosInSameJVM = new ConcurrentHashMap();
    private final String ejbId;
    private final String sessionId;
    private final String interfaceName;
    private final boolean isRmiRemote;
    private final boolean callByReference;
    private volatile transient int hashCode = 0;
    private transient ConcurrentHashMap<Method, String> signatureCache;
    private volatile transient InvocationHandler localCallHandler;
    private transient Class interfaceClass;

    public RemoteBusinessObjectClientHandler(String ejbId, String internalSessionId, Class interfaceClass, RemoteInvoker invoker, boolean callByReference) {
        super(invoker);
        this.ejbId = ejbId;
        this.sessionId = internalSessionId;
        this.interfaceName = interfaceClass.getName();
        this.isRmiRemote = Remote.class.isAssignableFrom(interfaceClass);
        this.callByReference = callByReference;
    }

    public void setLocalCallHandler(Class interfaze, InvocationHandler localCallHandler) {
        assert (interfaze != null && localCallHandler != null);
        this.interfaceClass = interfaze;
        this.localCallHandler = localCallHandler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName().charAt(0)) {
                case 'e': {
                    return this.isIdentical(proxy, args[0]);
                }
                case 'h': {
                    return this.hashCode();
                }
            }
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        ClassLoader classLoaderOfCaller = Thread.currentThread().getContextClassLoader();
        try {
            CalleeEJBInfo calleeEJBInfo = null;
            if (this.localCallHandler != null) {
                if (this.callByReference) {
                    if (logger.isLoggable(JeusMessage_EJB12._9309_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9309_LEVEL, "[RemoteBusinessObjectClientHandler](SHARED LOCAL CALL)-({2}) invoked {1} of {0} ", new Object[]{this.interfaceName, method.getName(), "call by referenec"});
                    }
                    return this.executeLocalCall_Shared(this.localCallHandler, method, args);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9309_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9309_LEVEL, "[RemoteBusinessObjectClientHandler](SHARED LOCAL CALL)-({2}) invoked {1} of {0} ", new Object[]{this.interfaceName, method.getName(), "call by value"});
                }
                Object[] newargs = null;
                if (args != null) {
                    newargs = new Object[args.length];
                    int i = 0;
                    for (Object arg : args) {
                        if (!ClassReloader.checkObjectSerialization(this.interfaceName, arg)) continue;
                        newargs[i++] = ClassReloader.reloadObject(classLoaderOfCaller, arg);
                    }
                }
                return this.executeLocalCall_Shared(this.localCallHandler, method, newargs);
            }
            if (this.ejbId != null && (calleeEJBInfo = calleeEJBInfosInSameJVM.get(this.ejbId + this.sessionId)) != null) {
                Object result;
                RemoteInvokerHandler handler = calleeEJBInfo.getBusinessObjectHandler();
                ClassLoader classLoaderOfCallee = calleeEJBInfo.getClassLoader();
                if (logger.isLoggable(JeusMessage_EJB12._9310_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9310_LEVEL, "[RemoteBusinessObjectClientHandler](ISOLATED LOCAL CALL) invoked {1} of {0}. class loader from map(callee) -({2}), context class loader(caller)-({3}), handler class loader-{4}  ", new Object[]{this.interfaceName, method.getName(), classLoaderOfCallee, classLoaderOfCaller, handler.getClass().getClassLoader()});
                }
                Object[] newargs = null;
                if (args != null) {
                    newargs = new Object[args.length];
                    int i = 0;
                    for (Object arg : args) {
                        if (!ClassReloader.checkObjectSerialization(this.interfaceName, arg)) continue;
                        try {
                            newargs[i++] = ClassReloader.reloadObject(classLoaderOfCallee, arg);
                        }
                        catch (ClassNotFoundException e) {
                            if (this.clustered) {
                                RemoteBusinessObjectClientHandler.removeEJBInfoInSameJVM(this.ejbId + this.sessionId);
                                return this.executeRemoteCall(method, args);
                            }
                            throw e;
                        }
                    }
                }
                if (ClassReloader.checkObjectSerialization(this.interfaceName, result = this.executeLocalCall_Isolated(handler, method, newargs))) {
                    result = ClassReloader.reloadObject(classLoaderOfCaller, result);
                }
                return result;
            }
            return this.executeRemoteCall(method, args);
        }
        catch (Exception ex) {
            if (this.ejbId != null && calleeEJBInfosInSameJVM.get(this.ejbId + this.sessionId) != null) {
                ex = (Exception)ClassReloader.reloadObject(classLoaderOfCaller, ex);
            }
            if (ex instanceof ServerException) {
                ServerException e = (ServerException)ex;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex = (RemoteException)e.detail;
                }
            }
            if (ex instanceof NoSuchObjectException) {
                if (!this.isRmiRemote) {
                    throw new NoSuchEJBException(((Throwable)ex).getMessage() + ", sid=" + this.sessionId, ex);
                }
                throw ex;
            }
            if (ex instanceof RemoteException) {
                if (!this.isRmiRemote) {
                    throw new EJBException(((Throwable)ex).getMessage(), ex);
                }
                throw ex;
            }
            throw ex;
        }
    }

    private Object executeLocalCall_Shared(InvocationHandler handler, Method method, Object[] args) throws Throwable {
        try {
            if (handler == null) {
                return this.executeRemoteCall(method, args);
            }
            return handler.invoke(this.interfaceClass, method, args);
        }
        catch (Throwable ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(this.getSignature(method)), ex)) {
                this.localCallHandler = null;
                RemoteBusinessObjectClientHandler.removeEJBInfoInSameJVM(this.ejbId + this.sessionId);
                return this.executeRemoteCall(method, args);
            }
            throw ex;
        }
    }

    private Object executeLocalCall_Isolated(RemoteInvokerHandler handler, Method method, Object[] args) throws Throwable {
        try {
            return handler.invoke(this.interfaceName, this.getSignature(method), args);
        }
        catch (Exception ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(this.getSignature(method)), ex)) {
                RemoteBusinessObjectClientHandler.removeEJBInfoInSameJVM(this.ejbId + this.sessionId);
                return this.executeRemoteCall(method, args);
            }
            throw ex;
        }
    }

    private Object executeRemoteCall(Method method, Object[] args) throws Throwable {
        if (logger.isLoggable(JeusMessage_EJB12._9311_LEVEL)) {
            logger.log(JeusMessage_EJB12._9311_LEVEL, "[RemoteBusinessObjectClientHandler](REMOTE CALL) invoked {1} of {0} ", new Object[]{this.interfaceName, method.getName()});
        }
        String signature = this.getSignature(method);
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setInterface(this.interfaceName);
        invocation.setSignature(signature);
        invocation.setArgs(args);
        return super.invoke(invocation);
    }

    private String getSignature(Method method) {
        String sig;
        if (this.signatureCache == null) {
            this.signatureCache = new ConcurrentHashMap();
        }
        if ((sig = this.signatureCache.get(method)) == null) {
            sig = MethodUtils.getSignature(method);
            this.signatureCache.put(method, sig);
        }
        return sig;
    }

    public static void putEJBInfoInSameJVM(String ejbIdPlusInternalSessionId, RemoteInvokerHandler businessObjectHandler, ClassLoader loader) {
        CalleeEJBInfo ejbInfo = calleeEJBInfosInSameJVM.get(ejbIdPlusInternalSessionId);
        if (ejbInfo != null) {
            RemoteInvokerHandler oldHandler = ejbInfo.getBusinessObjectHandler();
            ClassLoader oldClassLoader = ejbInfo.getClassLoader();
            if (oldHandler != null && oldHandler != businessObjectHandler && oldClassLoader != null && oldClassLoader != loader && conLogger.isLoggable(JeusMessage_EJB12._9351_LEVEL)) {
                conLogger.log(JeusMessage_EJB12._9351_LEVEL, "[{0}] LEAK DETECTED for static map of {1} used for local call opt. ( ejbId = {2} )", new Object[]{RemoteEJBHomeClientHandler.class.getName(), "business object handlers and class loaders", ejbIdPlusInternalSessionId});
            }
        }
        calleeEJBInfosInSameJVM.put(ejbIdPlusInternalSessionId, new CalleeEJBInfo(businessObjectHandler, loader));
    }

    public static void removeEJBInfoInSameJVM(String ejbIdPlusInternalSessionId) {
        calleeEJBInfosInSameJVM.remove(ejbIdPlusInternalSessionId);
    }

    private boolean isIdentical(Object proxy, Object arg) {
        if (proxy == arg) {
            return true;
        }
        if (arg == null || !Proxy.isProxyClass(arg.getClass())) {
            return false;
        }
        InvocationHandler other = Proxy.getInvocationHandler(arg);
        if (!(other instanceof RemoteBusinessObjectClientHandler)) {
            return false;
        }
        RemoteBusinessObjectClientHandler that = (RemoteBusinessObjectClientHandler)other;
        return this.ejbId.equals(that.ejbId) && this.sessionId.equals(that.sessionId) && this.interfaceName.equals(that.interfaceName);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.ejbId == null ? 0 : this.ejbId.hashCode();
            this.hashCode = result = 29 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        }
        return this.hashCode;
    }

    private static class CalleeEJBInfo {
        private RemoteInvokerHandler businessObjectHandler;
        private ClassLoader classLoader;

        public CalleeEJBInfo(RemoteInvokerHandler businessObjectHandler, ClassLoader classLoader) {
            this.businessObjectHandler = businessObjectHandler;
            this.classLoader = classLoader;
        }

        public RemoteInvokerHandler getBusinessObjectHandler() {
            return this.businessObjectHandler;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

