/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.RemoveException;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.client.ClassReloader;
import jeus.ejb.client.RemoteInvokerHandler;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.ejb.util.InvocationHandlerUtil;
import jeus.ejb.util.MethodUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class RemoteEJBHomeClientHandler
extends RemoteInvokerClient
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 60L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");
    private static final JeusLogger conLogger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.container");
    public static final String findByInstanceKeyMethodSig;
    private static ConcurrentHashMap<String, CalleeEJBInfo> calleeEJBInfosInSameJVM;
    private final String ejbId;
    private final String remoteHomeInterfaceName;
    private final boolean isRemoteHomeInterface;
    private final boolean callByReference;
    private transient ConcurrentHashMap<Method, String> signatureCache;

    public RemoteEJBHomeClientHandler(String ejbId, Class interfaceClass, RemoteInvoker invoker, boolean callByReference) {
        super(invoker);
        this.ejbId = ejbId;
        this.remoteHomeInterfaceName = interfaceClass.getName();
        this.isRemoteHomeInterface = Remote.class.isAssignableFrom(interfaceClass);
        this.callByReference = callByReference;
    }

    public Object getClientProxy() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> interfaceCls = cl.loadClass(this.remoteHomeInterfaceName);
            Class<?> proxyClass = Proxy.getProxyClass(cl, interfaceCls);
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            return constructor.newInstance(this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        ClassLoader classLoaderOfCaller = Thread.currentThread().getContextClassLoader();
        try {
            CalleeEJBInfo calleeEJBInfo = null;
            if (this.ejbId != null && (calleeEJBInfo = calleeEJBInfosInSameJVM.get(this.ejbId)) != null) {
                Object result;
                boolean isolatedMode;
                InvocationHandler homeHandler = calleeEJBInfo.getEJBHomeHandler();
                ClassLoader classLoaderOfCallee = calleeEJBInfo.getClassLoader();
                try {
                    isolatedMode = ClassReloader.isIsolatedClassloadingMode(classLoaderOfCaller, classLoaderOfCallee, this.remoteHomeInterfaceName);
                }
                catch (ClassNotFoundException e) {
                    if (this.clustered) {
                        RemoteEJBHomeClientHandler.removeEJBInfoInSameJVM(this.ejbId);
                        return this.executeRemoteCall(method, args);
                    }
                    throw e;
                }
                if (!isolatedMode) {
                    Class<?> remoteHomeInterfaceClass = classLoaderOfCaller.loadClass(this.remoteHomeInterfaceName);
                    if (this.callByReference) {
                        if (logger.isLoggable(JeusMessage_EJB12._9312_LEVEL)) {
                            logger.log(JeusMessage_EJB12._9312_LEVEL, "[RemoteEJBHomeClientHandler](SHARED LOCAL CALL)-({2}) invoked {1} of {0} ", new Object[]{this.remoteHomeInterfaceName, method.getName(), "call by reference"});
                        }
                        return this.executeLocalCall_Shared(homeHandler, remoteHomeInterfaceClass, method, args);
                    }
                    if (logger.isLoggable(JeusMessage_EJB12._9312_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9312_LEVEL, "[RemoteEJBHomeClientHandler](SHARED LOCAL CALL)-({2}) invoked {1} of {0} ", new Object[]{this.remoteHomeInterfaceName, method.getName(), "call by value"});
                    }
                    Object[] newargs = null;
                    if (args != null) {
                        newargs = new Object[args.length];
                        int i = 0;
                        for (Object arg : args) {
                            if (!ClassReloader.checkObjectSerialization(this.remoteHomeInterfaceName, arg)) continue;
                            newargs[i++] = ClassReloader.reloadObject(classLoaderOfCaller, arg);
                        }
                    }
                    return this.executeLocalCall_Shared(homeHandler, remoteHomeInterfaceClass, method, newargs);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9313_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9313_LEVEL, "[RemoteEJBHomeClientHandler](ISOLATED LOCAL CALL) invoked {1} of {0}. class loader from map(callee) -({2}), context class loader(caller)-({3}), handler class loader-{4} ", new Object[]{this.remoteHomeInterfaceName, method.getName(), classLoaderOfCallee, classLoaderOfCaller, homeHandler.getClass().getClassLoader()});
                }
                Object[] newargs = null;
                if (args != null) {
                    newargs = new Object[args.length];
                    int i = 0;
                    for (Object arg : args) {
                        if (!ClassReloader.checkObjectSerialization(this.remoteHomeInterfaceName, arg)) continue;
                        try {
                            newargs[i++] = ClassReloader.reloadObject(classLoaderOfCallee, arg);
                        }
                        catch (ClassNotFoundException e) {
                            if (this.clustered) {
                                RemoteEJBHomeClientHandler.removeEJBInfoInSameJVM(this.ejbId);
                                return this.executeRemoteCall(method, args);
                            }
                            throw e;
                        }
                    }
                }
                if ((result = this.executeLocalCall_Isolated((RemoteInvokerHandler)((Object)homeHandler), method, newargs)) != null && ClassReloader.checkObjectSerialization(this.remoteHomeInterfaceName, result)) {
                    result = ClassReloader.reloadObject(classLoaderOfCaller, result);
                }
                return result;
            }
            return this.executeRemoteCall(method, args);
        }
        catch (Exception ex) {
            if (this.ejbId != null && calleeEJBInfosInSameJVM.get(this.ejbId) != null) {
                ex = (Exception)ClassReloader.reloadObject(classLoaderOfCaller, ex);
            }
            if (ex instanceof ServerException) {
                ServerException e = (ServerException)ex;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex = (RemoteException)e.detail;
                }
            }
            if (ex instanceof NoSuchObjectException) {
                if (!this.isRemoteHomeInterface) {
                    throw new NoSuchEJBException(ex.getMessage(), ex);
                }
                throw ex;
            }
            if (ex instanceof RemoteException) {
                if (!this.isRemoteHomeInterface) {
                    throw new EJBException(ex.getMessage(), ex);
                }
                throw ex;
            }
            throw ex;
        }
    }

    private Object executeLocalCall_Shared(InvocationHandler handler, Class remoteHomeInterfaceClass, Method method, Object[] args) throws Throwable {
        try {
            Object obj = handler.invoke(remoteHomeInterfaceClass, method, args);
            if (this.clustered) {
                this.propagateClusterInfo(obj);
            }
            return obj;
        }
        catch (Throwable ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(this.getSignature(method)), ex)) {
                RemoteEJBHomeClientHandler.removeEJBInfoInSameJVM(this.ejbId);
                return this.executeRemoteCall(method, args);
            }
            throw ex;
        }
    }

    private Object executeLocalCall_Isolated(RemoteInvokerHandler handler, Method method, Object[] args) throws Throwable {
        try {
            Object obj = handler.invoke(this.remoteHomeInterfaceName, this.getSignature(method), args);
            if (this.clustered) {
                this.propagateClusterInfo(obj);
            }
            return obj;
        }
        catch (Exception ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(this.getSignature(method)), ex)) {
                RemoteEJBHomeClientHandler.removeEJBInfoInSameJVM(this.ejbId);
                return this.executeRemoteCall(method, args);
            }
            throw ex;
        }
    }

    private Object executeRemoteCall(Method method, Object[] args) throws Throwable {
        if (logger.isLoggable(JeusMessage_EJB12._9314_LEVEL)) {
            logger.log(JeusMessage_EJB12._9314_LEVEL, "[RemoteEJBHomeClientHandler](REMOTE CALL) invoked {1} of {0} ", new Object[]{this.remoteHomeInterfaceName, method.getName()});
        }
        String signature = this.getSignature(method);
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setInterface(this.remoteHomeInterfaceName);
        invocation.setSignature(signature);
        invocation.setArgs(args);
        return this.invokeRemoteMethod(invocation);
    }

    private Object invokeRemoteMethod(RemoteInvocationImpl invocation) throws Exception {
        try {
            Object obj = super.invoke(invocation);
            if (this.clustered) {
                this.propagateClusterInfo(obj);
            }
            return obj;
        }
        catch (Throwable ex) {
            if (ex instanceof ServerException) {
                ServerException e = (ServerException)ex;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex = e.detail;
                }
            }
            if (ex instanceof RemoveException) {
                throw (RemoveException)ex;
            }
            if (ex instanceof CreateException) {
                throw (CreateException)ex;
            }
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RemoteException("", ex);
        }
    }

    private void propagateClusterInfo(Object obj) {
        InvocationHandler handler;
        if (obj instanceof JEUSClusterStub) {
            ((JEUSClusterStub)obj).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
        } else if (obj != null && Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof JEUSClusterStub) {
            ((JEUSClusterStub)((Object)handler)).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
        }
    }

    private String getSignature(Method method) {
        String sig;
        if (this.signatureCache == null) {
            this.signatureCache = new ConcurrentHashMap();
        }
        if ((sig = this.signatureCache.get(method)) == null) {
            sig = MethodUtils.getSignature(method);
            this.signatureCache.put(method, sig);
        }
        return sig;
    }

    public Class getEJBHomeClass() {
        try {
            ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
            return currentLoader.loadClass(this.remoteHomeInterfaceName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object findByInstanceKey(String sessionID) throws Exception {
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setSignature(findByInstanceKeyMethodSig);
        invocation.setArgs(new Object[]{sessionID});
        return this.invokeRemoteMethod(invocation);
    }

    public static void putEJBInfoInSameJVM(String ejbId, InvocationHandler ejbHomeHandler, ClassLoader loader) {
        CalleeEJBInfo ejbInfo = calleeEJBInfosInSameJVM.get(ejbId);
        if (ejbInfo != null) {
            InvocationHandler oldIH = ejbInfo.getEJBHomeHandler();
            ClassLoader oldClassLoader = ejbInfo.getClassLoader();
            if (oldIH != null && oldIH != ejbHomeHandler && oldClassLoader != null && oldClassLoader != loader && conLogger.isLoggable(JeusMessage_EJB12._9351_LEVEL)) {
                conLogger.log(JeusMessage_EJB12._9351_LEVEL, "[{0}] LEAK DETECTED for static map of {1} used for local call opt. ( ejbId = {2} )", new Object[]{RemoteEJBHomeClientHandler.class.getName(), "EJB home handlers and class loaders", ejbId});
            }
        }
        calleeEJBInfosInSameJVM.put(ejbId, new CalleeEJBInfo(ejbHomeHandler, loader));
    }

    public static void removeEJBInfoInSameJVM(String ejbId) {
        calleeEJBInfosInSameJVM.remove(ejbId);
    }

    static {
        try {
            Method findByInstanceKeyMethod = RemoteEJBHomeClientHandler.class.getMethod("findByInstanceKey", String.class);
            findByInstanceKeyMethodSig = MethodUtils.getSignature(findByInstanceKeyMethod);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        calleeEJBInfosInSameJVM = new ConcurrentHashMap();
    }

    private static class CalleeEJBInfo {
        private InvocationHandler ejbHomeHandler;
        private ClassLoader classLoader;

        public CalleeEJBInfo(InvocationHandler ejbHomeHandler, ClassLoader classLoader) {
            this.ejbHomeHandler = ejbHomeHandler;
            this.classLoader = classLoader;
        }

        public InvocationHandler getEJBHomeHandler() {
            return this.ejbHomeHandler;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

