/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.NoSuchEJBException;
import jeus.ejb.client.ClassReloader;
import jeus.ejb.client.RemoteInvokerHandler;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.ejb.util.InvocationHandlerUtil;
import jeus.ejb.util.MethodUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

public class RemoteEJBObjectClientHandler
extends RemoteInvokerClient
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 60L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");
    private static final JeusLogger conLogger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.container");
    private static ConcurrentHashMap<String, CalleeEJBInfo> calleeEJBInfosInSameJVM = new ConcurrentHashMap();
    private final String ejbId;
    private final String internalSessionId;
    private final String interfaceName;
    private final boolean isRemoteInterface;
    private final boolean callByReference;
    private volatile transient int hashCode = 0;
    private transient ConcurrentHashMap<Method, String> signatureCache;
    private transient InvocationHandler localCallHandler;
    private volatile transient Class interfaceClass;

    public RemoteEJBObjectClientHandler(String ejbId, String internalSessionId, Class interfaceClass, RemoteInvoker invoker, boolean callByReference) {
        super(invoker);
        this.ejbId = ejbId;
        this.internalSessionId = internalSessionId;
        this.interfaceName = interfaceClass.getName();
        this.isRemoteInterface = Remote.class.isAssignableFrom(interfaceClass);
        this.callByReference = callByReference;
    }

    public void setLocalCallHandler(Class interfaze, InvocationHandler localCallHandler) {
        assert (interfaze != null && localCallHandler != null);
        this.interfaceClass = interfaze;
        this.localCallHandler = localCallHandler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName().charAt(0)) {
                case 'e': {
                    return this.isIdentical(proxy, args[0]);
                }
                case 'h': {
                    return this.hashCode();
                }
            }
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        if (method.getDeclaringClass() == EJBObject.class) {
            switch (method.getName().charAt(3)) {
                case 'd': {
                    return this.isIdentical(proxy, args[0]);
                }
            }
        }
        ClassLoader classloaderOfCaller = Thread.currentThread().getContextClassLoader();
        try {
            CalleeEJBInfo calleeEJBInfo = null;
            if (this.localCallHandler != null) {
                if (this.callByReference) {
                    if (logger.isLoggable(JeusMessage_EJB12._9315_LEVEL)) {
                        logger.log(JeusMessage_EJB12._9315_LEVEL, "[RemoteEJBObjectClientHandler](SHARED LOCAL CALL) invoked {1} of {0} ", new Object[]{this.interfaceName, method.getName(), "call by reference"});
                    }
                    return this.executeLocalCall_Shared(this.localCallHandler, method, args);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9315_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9315_LEVEL, "[RemoteEJBObjectClientHandler](SHARED LOCAL CALL) invoked {1} of {0} ", new Object[]{this.interfaceName, method.getName(), "call by value"});
                }
                Object[] newargs = null;
                if (args != null) {
                    newargs = new Object[args.length];
                    int i = 0;
                    for (Object arg : args) {
                        if (!ClassReloader.checkObjectSerialization(this.interfaceName, arg)) continue;
                        newargs[i++] = ClassReloader.reloadObject(classloaderOfCaller, arg);
                    }
                }
                return this.executeLocalCall_Shared(this.localCallHandler, method, newargs);
            }
            if (this.ejbId != null && (calleeEJBInfo = calleeEJBInfosInSameJVM.get(this.ejbId + this.internalSessionId)) != null) {
                Object result;
                RemoteInvokerHandler handler = calleeEJBInfo.getEJBObjectHandler();
                ClassLoader classLoaderOfCallee = calleeEJBInfo.getClassLoader();
                if (logger.isLoggable(JeusMessage_EJB12._9316_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9316_LEVEL, "[RemoteEJBObjectClientHandler](ISOLATED LOCAL CALL) invoked {1} of {0}. class loader from map(callee) -({2}), context class loader(caller)-({3}), handler class loader-{4} ", new Object[]{this.interfaceName, method.getName(), classLoaderOfCallee, classloaderOfCaller, handler.getClass().getClassLoader()});
                }
                Object[] newargs = null;
                if (args != null) {
                    newargs = new Object[args.length];
                    int i = 0;
                    for (Object arg : args) {
                        if (!ClassReloader.checkObjectSerialization(this.interfaceName, arg)) continue;
                        try {
                            newargs[i++] = ClassReloader.reloadObject(classLoaderOfCallee, arg);
                        }
                        catch (ClassNotFoundException e) {
                            if (this.clustered) {
                                RemoteEJBObjectClientHandler.removeEJBInfoInSameJVM(this.ejbId + this.internalSessionId);
                                return this.executeRemoteCall(method, args);
                            }
                            throw e;
                        }
                    }
                }
                if ((result = this.executeLocalCall_Isolated(handler, method, newargs)) != null && ClassReloader.checkObjectSerialization(this.interfaceName, result)) {
                    result = ClassReloader.reloadObject(classloaderOfCaller, result);
                }
                return result;
            }
            return this.executeRemoteCall(method, args);
        }
        catch (Exception ex) {
            if (this.ejbId != null && calleeEJBInfosInSameJVM.get(this.ejbId + this.internalSessionId) != null) {
                ex = (Exception)ClassReloader.reloadObject(classloaderOfCaller, ex);
            }
            if (ex instanceof ServerException) {
                ServerException e = (ServerException)ex;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex = (RemoteException)e.detail;
                }
            }
            if (ex instanceof NoSuchObjectException) {
                if (!this.isRemoteInterface) {
                    throw new NoSuchEJBException(ex.getMessage(), ex);
                }
                throw ex;
            }
            if (ex instanceof RemoteException) {
                if (!this.isRemoteInterface) {
                    throw new EJBException(ex.getMessage(), ex);
                }
                throw ex;
            }
            if (ex instanceof EJBException) {
                if (this.isRemoteInterface) {
                    throw new RemoteException(ex.getMessage(), ex);
                }
                throw ex;
            }
            throw ex;
        }
    }

    private Object executeLocalCall_Shared(InvocationHandler handler, Method method, Object[] args) throws Throwable {
        try {
            if (handler == null) {
                return this.executeRemoteCall(method, args);
            }
            return handler.invoke(this.interfaceClass, method, args);
        }
        catch (Throwable ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(this.getSignature(method)), ex)) {
                this.localCallHandler = null;
                RemoteEJBObjectClientHandler.removeEJBInfoInSameJVM(this.ejbId + this.internalSessionId);
                return this.executeRemoteCall(method, args);
            }
            throw ex;
        }
    }

    private Object executeLocalCall_Isolated(RemoteInvokerHandler handler, Method method, Object[] args) throws Throwable {
        try {
            return handler.invoke(this.interfaceName, this.getSignature(method), args);
        }
        catch (Exception ex) {
            if (this.clustered && this.clusterSupport.isFailoverException(this.IsIdempotentMethod(this.getSignature(method)), ex)) {
                RemoteEJBObjectClientHandler.removeEJBInfoInSameJVM(this.ejbId + this.internalSessionId);
                return this.executeRemoteCall(method, args);
            }
            throw ex;
        }
    }

    private Object executeRemoteCall(Method method, Object[] args) throws Throwable {
        if (logger.isLoggable(JeusMessage_EJB12._9317_LEVEL)) {
            logger.log(JeusMessage_EJB12._9317_LEVEL, "[RemoteEJBObjectClientHandler](REMOTE CALL) invoked {1} of {0} ", new Object[]{this.interfaceName, method.getName()});
        }
        String signature = this.getSignature(method);
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setInterface(this.interfaceName);
        invocation.setSignature(signature);
        invocation.setArgs(args);
        return super.invoke(invocation);
    }

    private String getSignature(Method method) {
        String sig;
        if (this.signatureCache == null) {
            this.signatureCache = new ConcurrentHashMap();
        }
        if ((sig = this.signatureCache.get(method)) == null) {
            sig = MethodUtils.getSignature(method);
            this.signatureCache.put(method, sig);
        }
        return sig;
    }

    public static void putEJBInfoInSameJVM(String ejbIdPlusInternalSessionId, RemoteInvokerHandler ejbObjectHandler, ClassLoader loader) {
        CalleeEJBInfo ejbInfo = calleeEJBInfosInSameJVM.get(ejbIdPlusInternalSessionId);
        if (ejbInfo != null) {
            RemoteInvokerHandler oldHandler = ejbInfo.getEJBObjectHandler();
            ClassLoader oldClassLoader = ejbInfo.getClassLoader();
            if (oldHandler != null && oldHandler != ejbObjectHandler && oldClassLoader != null && oldClassLoader != loader && conLogger.isLoggable(JeusMessage_EJB12._9351_LEVEL)) {
                conLogger.log(JeusMessage_EJB12._9351_LEVEL, "[{0}] LEAK DETECTED for static map of {1} used for local call opt. ( ejbId = {2} )", new Object[]{RemoteEJBObjectClientHandler.class.getName(), "EJB Object handlers and class loaders", ejbIdPlusInternalSessionId});
            }
        }
        calleeEJBInfosInSameJVM.put(ejbIdPlusInternalSessionId, new CalleeEJBInfo(ejbObjectHandler, loader));
    }

    public static void removeEJBInfoInSameJVM(String ejbIdPlusInternalSessionId) {
        calleeEJBInfosInSameJVM.remove(ejbIdPlusInternalSessionId);
    }

    private boolean isIdentical(Object proxy, Object arg) {
        if (proxy == arg) {
            return true;
        }
        if (arg == null || !Proxy.isProxyClass(arg.getClass())) {
            return false;
        }
        InvocationHandler other = Proxy.getInvocationHandler(arg);
        if (!(other instanceof RemoteEJBObjectClientHandler)) {
            return false;
        }
        RemoteEJBObjectClientHandler that = (RemoteEJBObjectClientHandler)other;
        return this.ejbId.equals(that.ejbId) && this.internalSessionId.equals(that.internalSessionId) && this.interfaceName.equals(that.interfaceName);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.ejbId.hashCode();
            this.hashCode = result = 29 * result + this.internalSessionId.hashCode();
        }
        return this.hashCode;
    }

    private static class CalleeEJBInfo {
        private RemoteInvokerHandler ejbObjectHandler;
        private ClassLoader classLoader;

        public CalleeEJBInfo(RemoteInvokerHandler ejbObjectHandler, ClassLoader classLoader) {
            this.ejbObjectHandler = ejbObjectHandler;
            this.classLoader = classLoader;
        }

        public RemoteInvokerHandler getEJBObjectHandler() {
            return this.ejbObjectHandler;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

