/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client.rmi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.bean.rmi.StatefulSessionStubClusterSupport;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.ejb.client.rmi.RemoteInvocation;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvocationResponse;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.util.MethodTable;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.TMCommonService;
import jeus.transaction.client.TMContextCarrier;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessageBundles;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.trace.GID;
import jeus.util.trace.GIDException;
import jeus.workarea.WorkAreaServiceHelper;

public class RemoteInvokerClient
implements JEUSClusterStub,
Serializable {
    private static final long serialVersionUID = 60L;
    protected RemoteInvoker invokerStub;
    protected boolean clustered;
    protected StubClusterSupport clusterSupport;
    protected MethodTable idempotentMethods;
    protected ConcurrentHashMap<String, Boolean> idempotentMethodCache;

    public RemoteInvokerClient(RemoteInvoker stub) {
        this.invokerStub = stub;
    }

    public void setStubClusterSupport(StubClusterSupport clusterSupport, MethodTable idempotentMethods) {
        assert (clusterSupport != null);
        this.clustered = true;
        this.clusterSupport = clusterSupport;
        this.idempotentMethods = idempotentMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(RemoteInvocationImpl invocation) throws Throwable {
        this.preInvoke(invocation);
        String currentExportName = null;
        boolean idempotent = false;
        if (this.clustered) {
            String methodSig = invocation.getSignature();
            idempotent = this.IsIdempotentMethod(methodSig);
        }
        try {
            while (true) {
                try {
                    RemoteInvoker invoker;
                    if (this.clustered) {
                        StubClusterSupport stubClusterSupport = this.clusterSupport;
                        synchronized (stubClusterSupport) {
                            currentExportName = this.clusterSupport.getExportName();
                            RemoteInvokerClient invokerClient = (RemoteInvokerClient)this.clusterSupport.getStub();
                            invoker = invokerClient.invokerStub;
                        }
                    } else {
                        invoker = this.invokerStub;
                    }
                    RemoteInvocationResponse response = invoker.invoke(invocation);
                    this.postInvoke(invocation, response);
                    return response.getResult();
                }
                catch (Exception ex) {
                    if (this.clustered) {
                        this.clusterSupport.handleException(ex, currentExportName, idempotent);
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
        catch (Throwable ex) {
            if (ex instanceof TMContextCarrier) {
                TMContextCarrier car = (TMContextCarrier)ex;
                ContextSenderReceiver.contextPropagated(car.ctx, null);
                ex = car.ex;
            }
            if (ex instanceof GIDException) {
                GIDException gex = (GIDException)ex;
                GID.setCurrentGID(gex.gidBytes);
                ex = gex.ex;
            }
            throw ex;
        }
    }

    protected boolean IsIdempotentMethod(String methodSig) {
        Boolean bool;
        if (this.idempotentMethodCache == null) {
            this.idempotentMethodCache = new ConcurrentHashMap();
        } else {
            bool = this.idempotentMethodCache.get(methodSig);
            if (bool != null) {
                return bool;
            }
        }
        bool = (Boolean)this.idempotentMethods.getValue(methodSig);
        if (bool == null) {
            this.idempotentMethodCache.put(methodSig, Boolean.FALSE);
            return false;
        }
        this.idempotentMethodCache.put(methodSig, bool);
        return bool;
    }

    public void preInvoke(RemoteInvocationImpl invocation) {
        Object wacontext;
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.client");
        if (logger.isLoggable(JeusMessage_EJB11._8201_LEVEL)) {
            logger.log(JeusMessage_EJB11._8201_LEVEL, JeusMessage_EJB11._8201, new Object[]{Thread.currentThread(), Thread.currentThread().isInterrupted()});
        }
        if (JeusManagerProperties.CHECK_INTERRUPTED_STATUS && Thread.interrupted()) {
            throw new EJBException("the current thread is interrrupted");
        }
        try {
            invocation.setSecuritySubject(LoginService.getCurrentSubjectSerialized());
        }
        catch (SecurityException e) {
            throw new EJBException(e);
        }
        catch (ServiceException e) {
            throw new EJBException(e);
        }
        if (TMCommonService.isTxTimeout()) {
            throw new EJBException(JeusMessageBundles.getMessage(JeusMessage_EJB12._9104));
        }
        invocation.setTxContext(ContextSenderReceiver.getPropagationContext());
        if (GID.useGID) {
            byte[] gidBytes = GID.getCurrentGIDBytes();
            if (gidBytes == null) {
                GID.createCurrentGID();
                GID.increaseSeqNumber();
                gidBytes = GID.getCurrentGIDBytes();
            } else {
                GID.increaseSeqNumber();
            }
            invocation.setGID(gidBytes);
        }
        if ((wacontext = WorkAreaServiceHelper.getPropagationContext()) != null) {
            invocation.setContext("jeus.workarea.context", wacontext);
        }
    }

    public void postInvoke(RemoteInvocation invocation, RemoteInvocationResponse response) {
        byte[] ctx = invocation.getTxContext();
        if (ctx != null && (ctx[0] == -2 || ctx[0] == -3)) {
            ContextSenderReceiver.readTMCtx(response.getTxContext());
        }
        if (response.getGID() != null) {
            GID.setCurrentGID(response.getGID());
        }
    }

    public void __jeus_setCluster(String selectedExportName, DynamicLinkRef linkRef) {
        if (this.clustered) {
            this.clusterSupport.__jeus_setCluster(selectedExportName, linkRef);
        }
    }

    public void setSessionID(String newSessionID) {
        ((StatefulSessionStubClusterSupport)this.clusterSupport).setSessionID(newSessionID);
    }

    public String getSessionID() {
        return ((StatefulSessionStubClusterSupport)this.clusterSupport).getSessionID();
    }

    public StubClusterSupport getClusterSupport() {
        return this.clusterSupport;
    }
}

