/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop;

import jeus.corba.ORBManager;
import jeus.ejb.interop.InterceptorFactoryFor5;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.transaction.OTSIORInterceptor;
import jeus.transaction.ots.TSIdentificationImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class EJBORBInitializer
extends LocalObject
implements ORBInitializer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.interop.orb");

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        try {
            ClientRequestInterceptor clientInterceptor2;
            ServerRequestInterceptor serverInterceptor2;
            Encoding enc = new Encoding(0, 1, 2);
            Codec codec = info.codec_factory().create_codec(enc);
            InterceptorFactoryFor5 factory = new InterceptorFactoryFor5();
            IORInterceptor iorInterceptor2 = factory.createCSIIORInterceptor();
            if (iorInterceptor2 != null) {
                ORBManager.addORBReceiver((ORBReceiver)iorInterceptor2);
                info.add_ior_interceptor(iorInterceptor2);
            }
            if ((serverInterceptor2 = factory.createCSIServerRequestInterceptor(codec)) != null) {
                ORBManager.addORBReceiver((ORBReceiver)serverInterceptor2);
                info.add_server_request_interceptor(serverInterceptor2);
            }
            if ((clientInterceptor2 = factory.createCSIClientRequestInterceptor(codec)) != null) {
                ORBManager.addORBReceiver((ORBReceiver)clientInterceptor2);
                info.add_client_request_interceptor(clientInterceptor2);
            }
            OTSIORInterceptor otsIorInterceptor = new OTSIORInterceptor(codec);
            info.add_ior_interceptor((IORInterceptor)otsIorInterceptor);
            Current pic = (Current)info.resolve_initial_references("PICurrent");
            int[] slotIds = new int[]{info.allocate_slot_id(), info.allocate_slot_id()};
            Interceptor interceptor = factory.createOTSInterceptor(pic, codec, slotIds, new TSIdentificationImpl());
            info.add_client_request_interceptor((ClientRequestInterceptor)interceptor);
            info.add_server_request_interceptor((ServerRequestInterceptor)interceptor);
            ORBManager.addORBReceiver((ORBReceiver)interceptor);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB11._7087_LEVEL)) {
                logger.log(JeusMessage_EJB11._7087_LEVEL, JeusMessage_EJB11._7087, t);
            }
            throw new RuntimeException(t.getMessage());
        }
    }
}

