/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import java.io.IOException;
import jeus.corba.ORBManager;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.csi.EJBCSIPolicyImpl;
import jeus.ejb.interop.csi.GSSUPExportName;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.xml.binding.jeusDD.SecurityInteropElementRestrictedType;
import jeus.xml.binding.jeusDD.SecurityInteropElementType;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public final class CSIIORInterceptorFor5
extends LocalObject
implements IORInterceptor,
ORBReceiver {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.interop.csi");
    private static ObjectIdentifier GSSUP_MECH_OID = null;
    private static String targetName;
    private String name = "CSIIORInterceptor";
    private ORB orb;

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public void establish_components(IORInfo info) {
        try {
            EJBCSIPolicyImpl pImpl;
            try {
                pImpl = (EJBCSIPolicyImpl)info.get_effective_policy(9736);
            }
            catch (INV_POLICY t) {
                return;
            }
            if (pImpl == null) {
                if (logger.isLoggable(JeusMessage_Manager1._466_LEVEL)) {
                    logger.log(JeusMessage_Manager1._466_LEVEL, JeusMessage_Manager1._466);
                }
                return;
            }
            String ejbName = pImpl.value();
            SecurityInteropType desc = ORBManager.getEJBCSIDescriptor(ejbName);
            int targetRequires = 0;
            if (desc.getIntegrityConfidentiality() == SecurityInteropElementType.REQUIRES) {
                targetRequires = targetRequires | 2 | 4;
            }
            if (desc.getTrustInClient() == SecurityInteropElementType.REQUIRES) {
                targetRequires |= 0x40;
            }
            TaggedComponent transportMech = this.createTransportMechanism(desc);
            AS_ContextSec asContext = this.createASContextSec(desc);
            SAS_ContextSec sasContext = this.createSASContextSec(desc);
            targetRequires = targetRequires | asContext.target_requires | sasContext.target_requires;
            CompoundSecMech[] mechList = new CompoundSecMech[]{new CompoundSecMech((short)targetRequires, transportMech, asContext, sasContext)};
            EncapsOutputStream out = new EncapsOutputStream((com.sun.corba.ee.spi.orb.ORB)this.orb);
            out.putEndian();
            boolean stateful = false;
            CompoundSecMechList list = new CompoundSecMechList(stateful, mechList);
            CompoundSecMechListHelper.write((OutputStream)out, list);
            byte[] buf = out.toByteArray();
            TaggedComponent tc = new TaggedComponent(33, buf);
            info.add_ior_component(tc);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB11._7092_LEVEL)) {
                logger.log(JeusMessage_EJB11._7092_LEVEL, JeusMessage_EJB11._7092, t);
            }
            throw new SecurityException(t.getMessage());
        }
    }

    private TaggedComponent createTransportMechanism(SecurityInteropType desc) throws Exception {
        int targetSupports = 0;
        if (desc.getIntegrityConfidentiality() == SecurityInteropElementType.SUPPORTS || desc.getIntegrityConfidentiality() == SecurityInteropElementType.REQUIRES) {
            targetSupports = targetSupports | 2 | 4;
        }
        if (desc.getTrustInClient() == SecurityInteropElementType.SUPPORTS || desc.getTrustInClient() == SecurityInteropElementType.REQUIRES) {
            targetSupports |= 0x40;
        }
        int targetRequires = 0;
        if (desc.getIntegrityConfidentiality() == SecurityInteropElementType.REQUIRES) {
            targetRequires = targetRequires | 2 | 4;
        }
        if (desc.getTrustInClient() == SecurityInteropElementType.REQUIRES) {
            targetRequires |= 0x40;
        }
        if (targetSupports == 0) {
            TaggedComponent tc = new TaggedComponent(34, new byte[0]);
            return tc;
        }
        int port = desc.getTrustInClient() == SecurityInteropElementType.REQUIRES ? ORBManager.getORBSSLMutualAuthPort() : ORBManager.getORBSSLPort();
        TransportAddress[] listTa = new TransportAddress[]{new TransportAddress(JeusNetPropertyValues.LOCAL_HOSTNAME, (short)port)};
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)(targetSupports |= 0x20), (short)targetRequires, listTa);
        EncapsOutputStream out = new EncapsOutputStream((com.sun.corba.ee.spi.orb.ORB)this.orb);
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, tls_sec);
        byte[] buf = out.toByteArray();
        TaggedComponent tc = new TaggedComponent(36, buf);
        return tc;
    }

    public AS_ContextSec createASContextSec(SecurityInteropType desc) throws Exception {
        int target_supports = 0;
        if (desc.getClientAuth() == SecurityInteropElementType.SUPPORTS || desc.getClientAuth() == SecurityInteropElementType.REQUIRES) {
            target_supports |= 0x40;
        }
        int target_requires = 0;
        if (desc.getClientAuth() == SecurityInteropElementType.REQUIRES) {
            target_requires |= 0x40;
        }
        byte[] client_authentication_mechanism = new byte[]{};
        byte[] target_name = new byte[]{};
        if (target_supports != 0) {
            DerOutputStream dos = new DerOutputStream();
            dos.putOID(GSSUP_MECH_OID);
            client_authentication_mechanism = dos.toByteArray();
            target_name = new GSSUPExportName(targetName, "").getExportedName();
        }
        return new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
    }

    public SAS_ContextSec createSASContextSec(SecurityInteropType desc) throws Exception {
        int target_supports = 0;
        if (desc.getIdentityAssertion() == SecurityInteropElementRestrictedType.SUPPORTS) {
            target_supports |= 0x400;
        }
        boolean target_requires = false;
        ServiceConfiguration[] privilege_authorities = new ServiceConfiguration[]{};
        byte[][] supported_naming_mechanisms = new byte[][]{};
        int supported_identity_type = 0;
        if (target_supports != 0) {
            supported_naming_mechanisms = new byte[1][];
            DerOutputStream dos = new DerOutputStream();
            dos.putOID(GSSUP_MECH_OID);
            supported_naming_mechanisms[0] = dos.toByteArray();
            supported_identity_type = 15;
        }
        return new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), privilege_authorities, supported_naming_mechanisms, supported_identity_type);
    }

    static {
        try {
            GSSUP_MECH_OID = new ObjectIdentifier("oid:2.23.130.1.1.1".substring("oid:2.23.130.1.1.1".indexOf(58) + 1));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        targetName = "default";
    }
}

