/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Set;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.csi.CSIException;
import jeus.ejb.interop.csi.GSSUPExportName;
import jeus.ejb.interop.csi.GSSUPInitialToken;
import jeus.ejb.interop.csi.login.AnonymousCredential;
import jeus.ejb.interop.csi.login.X509CertificateCredential;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.security.spi.SubjectNotExistsException;
import jeus.security.util.LoginUtil;
import jeus.util.SecurityUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.properties.JeusEJBProperties;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSI.X501DistinguishedNameHelper;
import org.omg.CSI.X509CertificateChainHelper;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;

public class ClientSideRequestInterceptorFor5
extends LocalObject
implements ClientRequestInterceptor,
ORBReceiver {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.interop.csi");
    private String name = "csi.ClientSideRequestInterceptor";
    private Codec codec;
    private ORB orb;
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static String defaultUser = JeusEJBProperties.CSI_DEFAULT_USER;
    private static final AuthorizationElement[] AUTHORIZATION_TOKEN = new AuthorizationElement[0];
    private static final byte[] DUMMY_BYTE = new byte[0];

    public ClientSideRequestInterceptorFor5(Codec codec) {
        this.codec = codec;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public String name() {
        return this.name;
    }

    private CompoundSecMech[] getCompoundSecMechList(TaggedComponent comp) {
        byte[] b = comp.component_data;
        EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
        in.consumeEndian();
        CompoundSecMechList l = CompoundSecMechListHelper.read((InputStream)in);
        CompoundSecMech[] list = l.mechanism_list;
        return list;
    }

    private byte[] createClientTokenFromExecutionContext(Subject subj, byte[] target_name, boolean checkPrincipal) throws Exception {
        if (AnonymousSubject.isAnonymous(subj) || subj.getPrincipal() == null) {
            return DUMMY_BYTE;
        }
        String username = subj.getPrincipal().getName();
        if (checkPrincipal && username.equals(defaultUser)) {
            return DUMMY_BYTE;
        }
        try {
            String password = SecurityUtil.getPlainPassword(subj);
            GSSUPInitialToken tok = new GSSUPInitialToken(this.orb, this.codec, username, "default", password, target_name);
            return tok.getToken();
        }
        catch (SubjectNotExistsException ex) {
            return DUMMY_BYTE;
        }
    }

    private IdentityToken createIdentityTokenFromExecutionContext(byte[] target_name, boolean checkPrincipal) throws Exception {
        IdentityToken idtok = new IdentityToken();
        Principal principal = LoginService.getCurrentPrincipal();
        if (principal != null) {
            String username = principal.getName();
            Any any = this.orb.create_any();
            GSSUPExportName gssname = new GSSUPExportName(username, "default");
            byte[] expname = gssname.getExportedName();
            GSS_NT_ExportedNameHelper.insert(any, expname);
            idtok.principal_name(this.codec.encode_value(any));
        } else {
            idtok.anonymous(true);
        }
        return idtok;
    }

    private IdentityToken createIdentityToken(Set credSet) throws Exception {
        Class cls;
        Object cred;
        if (credSet == null || credSet.isEmpty()) {
            cred = null;
            cls = AnonymousCredential.class;
        } else {
            cred = credSet.iterator().next();
            cls = cred.getClass();
        }
        IdentityToken idtok = new IdentityToken();
        Any any = this.orb.create_any();
        if (X500Name.class.isAssignableFrom(cls)) {
            DerOutputStream dos = new DerOutputStream();
            X500Name name = (X500Name)cred;
            name.encode(dos);
            X501DistinguishedNameHelper.insert(any, dos.toByteArray());
            idtok.dn(this.codec.encode_value(any));
        } else if (X509CertificateCredential.class.isAssignableFrom(cls)) {
            DerOutputStream dos = new DerOutputStream();
            X509CertificateCredential certcred = (X509CertificateCredential)cred;
            X509Certificate[] certchain = certcred.getX509CertificateChain();
            DerValue[] derval = new DerValue[certchain.length];
            for (int i = 0; i < certchain.length; ++i) {
                derval[i] = new DerValue(certchain[i].getEncoded());
            }
            dos.putSequence(derval);
            X509CertificateChainHelper.insert(any, dos.toByteArray());
            idtok.certificate_chain(this.codec.encode_value(any));
        } else if (GSSUPExportName.class.isAssignableFrom(cls)) {
            GSSUPExportName gssname = (GSSUPExportName)cred;
            byte[] expname = gssname.getExportedName();
            GSS_NT_ExportedNameHelper.insert(any, expname);
            idtok.principal_name(this.codec.encode_value(any));
        } else {
            idtok.anonymous(true);
        }
        return idtok;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        try {
            IdentityToken identityToken;
            TaggedComponent comp;
            try {
                comp = ri.get_effective_component(33);
            }
            catch (BAD_PARAM bp) {
                return;
            }
            CompoundSecMech[] compList = this.getCompoundSecMechList(comp);
            if (compList == null || compList.length < 1) {
                return;
            }
            AS_ContextSec as_context_mech = compList[0].as_context_mech;
            SAS_ContextSec sas_context_mech = compList[0].sas_context_mech;
            if (as_context_mech.target_supports == 0 && sas_context_mech.target_supports == 0) {
                return;
            }
            Subject subj = LoginUtil.getLatestUserSubjectWithRuntimeException();
            Set pubCreds = subj != null ? subj.getPublicCredentials() : null;
            byte[] clientToken = new byte[]{};
            if ((as_context_mech.target_supports & 0x40) > 0 && (as_context_mech.target_requires & 0x40) > 0) {
                clientToken = this.createClientTokenFromExecutionContext(subj, as_context_mech.target_name, false);
            }
            if ((sas_context_mech.target_supports & 0x400) > 0) {
                identityToken = this.createIdentityToken(pubCreds);
                if (identityToken.discriminator() == 1) {
                    if (clientToken.length == 0) {
                        if ((as_context_mech.target_supports & 0x40) > 0) {
                            clientToken = this.createClientTokenFromExecutionContext(subj, as_context_mech.target_name, true);
                            identityToken = new IdentityToken();
                            identityToken.absent(true);
                        } else {
                            identityToken = this.createIdentityTokenFromExecutionContext(as_context_mech.target_name, true);
                        }
                    } else {
                        identityToken = new IdentityToken();
                        identityToken.absent(true);
                    }
                }
            } else {
                identityToken = new IdentityToken();
                identityToken.absent(true);
            }
            EstablishContext ec = new EstablishContext(0L, AUTHORIZATION_TOKEN, identityToken, clientToken);
            SASContextBody sasctxbody = new SASContextBody();
            sasctxbody.establish_msg(ec);
            Any SasAny = this.orb.create_any();
            SASContextBodyHelper.insert(SasAny, sasctxbody);
            byte[] cdr_encoded_saselm = this.codec.encode_value(SasAny);
            ServiceContext sc = new ServiceContext();
            sc.context_id = 15;
            sc.context_data = cdr_encoded_saselm;
            ri.add_request_service_context(sc, true);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB11._7088_LEVEL)) {
                logger.log(JeusMessage_EJB11._7088_LEVEL, JeusMessage_EJB11._7088, t);
            }
            throw new SecurityException(t.getMessage(), t);
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        try {
            ServiceContext sc;
            try {
                sc = ri.get_reply_service_context(15);
            }
            catch (BAD_PARAM e) {
                return;
            }
            Any a = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody sasctxbody = SASContextBodyHelper.extract(a);
            short sasdiscr = sasctxbody.discriminator();
            if (sasdiscr != 1 && sasdiscr != 4) {
                throw new CSIException(JeusMessage_EJB11._7090, Short.toString(sasdiscr));
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_EJB11._7089_LEVEL)) {
                logger.log(JeusMessage_EJB11._7089_LEVEL, JeusMessage_EJB11._7089, t);
            }
            throw new SecurityException(t.getMessage());
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void destroy() {
    }
}

