/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.transport.SocketInfo;
import jeus.corba.ORBManager;
import jeus.ejb.interop.csi.CSIIORToSocketInfo;
import jeus.ejb.interop.csi.CSIV2TaggedComponentInfo;
import jeus.ejb.interop.csi.SecurityMechanismException;
import jeus.ejb.interop.csi.Utility;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.TLS_SEC_TRANS;

public final class SecurityMechanismSelector {
    private CompoundSecMech mechanism = null;
    private ORB orb = ORBManager.getORB();
    private CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(this.orb);

    public SocketInfo getSSLPort(IOR ior) {
        try {
            this.mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        TLS_SEC_TRANS ssl = null;
        if (this.mechanism != null) {
            ssl = this.ctc.getSSLInformation(this.mechanism);
        }
        if (ssl == null) {
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (this.isSet(targetRequires, 2) || this.isSet(targetRequires, 4) || this.isSet(targetRequires, 64)) {
            String type = this.isSet(targetRequires, 64) ? "SSL_MUTUALAUTH" : "SSL";
            short sslport = ssl.addresses[0].port;
            int ssl_port = Utility.shortToInt(sslport);
            String host_name = ssl.addresses[0].host_name;
            SocketInfo info = CSIIORToSocketInfo.createSocketInfo(type, host_name, ssl_port);
            return info;
        }
        if (this.isSet(targetSupports, 2) || this.isSet(targetSupports, 4) || this.isSet(targetSupports, 64)) {
            return null;
        }
        return null;
    }

    public CompoundSecMech getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(CompoundSecMech val) {
        this.mechanism = val;
    }

    public ORB getOrb() {
        return this.orb;
    }

    public void setOrb(ORB val) {
        this.orb = val;
    }

    public CSIV2TaggedComponentInfo getCtc() {
        return this.ctc;
    }

    public void setCtc(CSIV2TaggedComponentInfo val) {
        this.ctc = val;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sas) {
        int ident_token = sas.supported_identity_types;
        int value = ident_token & 0xF;
        return value != 0;
    }

    public CompoundSecMech selectSecurityMechanism(IOR ior) throws SecurityMechanismException {
        CompoundSecMech[] mechList = this.ctc.getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        for (int i = 0; i < mechList.length; ++i) {
            CompoundSecMech mech = mechList[i];
            boolean useMech = this.useMechanism(mech);
            if (!useMech) continue;
            return mech;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        TLS_SEC_TRANS tls = this.ctc.getSSLInformation(mech);
        if (tls == null) {
            return true;
        }
        return val;
    }

    private boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }
}

