/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.transaction;

import jeus.corba.ORBManager;
import jeus.ejb.container.OTSPolicyImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class OTSIORInterceptor
extends LocalObject
implements IORInterceptor {
    private String name = "OTSIORInterceptor";
    private Codec codec = null;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.ejb.interop.tx");

    public OTSIORInterceptor(Codec codec) {
        this.codec = codec;
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info) {
        try {
            OTSPolicyImpl otsPolicy = (OTSPolicyImpl)info.get_effective_policy(56);
            if (otsPolicy == null) {
                return;
            }
            try {
                short otsPolicyValue = 3;
                short invPolicyValue = 1;
                Any otsAny = ORBManager.getORB().create_any();
                Any invAny = ORBManager.getORB().create_any();
                otsAny.insert_short(otsPolicyValue);
                invAny.insert_short(invPolicyValue);
                byte[] otsCompValue = this.codec.encode_value(otsAny);
                byte[] invCompValue = this.codec.encode_value(invAny);
                TaggedComponent otsComp = new TaggedComponent(31, otsCompValue);
                TaggedComponent invComp = new TaggedComponent(32, invCompValue);
                info.add_ior_component(otsComp);
                info.add_ior_component(invComp);
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_EJB11._7113_LEVEL)) {
                    logger.log(JeusMessage_EJB11._7113_LEVEL, JeusMessage_EJB11._7113, t);
                }
                throw new INTERNAL(ErrorMsgManager.getLocalizedString(JeusMessage_EJB11._7113));
            }
        }
        catch (INV_POLICY iNV_POLICY) {
            // empty catch block
        }
    }
}

