/*
 * Decompiled with CFR 0.152.
 */
package jeus.internal.message;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeus.internal.message.DefaultMessageBundles;
import jeus.internal.message.MessageBundles;
import jeus.internal.util.ServiceLoader;

public class MessageBundlesFactory {
    private static final Logger logger = Logger.getLogger(MessageBundlesFactory.class.getName());
    private static final ServiceLoader<MessageBundles> loader = ServiceLoader.load(MessageBundles.class);
    private static final MessageBundles instance;

    public static MessageBundles getInstance() {
        return instance;
    }

    static {
        Iterator<MessageBundles> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Could not find the service implementation for " + MessageBundles.class.getName());
            }
            instance = new DefaultMessageBundles();
        } else {
            instance = iterator.next();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "The service implementation for " + MessageBundles.class.getName() + " is " + instance.getClass().getName());
        }
    }
}

