/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.handler;

import java.io.IOException;
import java.net.Socket;
import jeus.io.Selector;
import jeus.util.logging.JeusLogger;

public abstract class StreamHandler {
    protected boolean registered;
    protected Socket socket;
    protected Selector selector;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public void setSelector(Selector selector) {
        this.selector = selector;
        this.registered = true;
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public abstract void close(Exception var1);

    public abstract boolean isClosed();

    public abstract boolean writeInternal(Object[] var1) throws IOException;

    public void deregister(boolean wakeup) {
        this.selector.removeSelectItem(this);
        this.registered = false;
    }

    public void register() throws IOException {
        this.selector.addSelectItem(this);
    }

    protected void closeSocket() {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException e) {
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return (this.registered ? "registered stream handler[" : "not registered stream handler[") + this.getSocketInfo() + "]," + super.toString();
    }

    protected String getSocketInfo() {
        String socketString = "no socket information (maybe already closed)";
        try {
            if (this.socket != null) {
                socketString = this.socket.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return socketString;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isRegisterActionState() {
        return false;
    }

    public boolean isUpdateActionState() {
        return false;
    }

    public boolean isCancelActionState() {
        return false;
    }

    public boolean canWriteAsByte(Object message) {
        return false;
    }

    public boolean canWritePiggybackDataAsByte(Object piggybackData) {
        return false;
    }

    public byte[] getPiggybackDataBuffer(Object piggybackData) throws IOException {
        return null;
    }

    public Object getPiggybackData(byte[] buffer) throws IOException {
        return null;
    }

    public void setRegisterAction() {
    }

    public void setUpdateAction() {
    }

    public void setCancelAction() {
    }

    public Selector getSelector() {
        return this.selector;
    }

    public Object getWriteLock() {
        return this;
    }
}

