/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.helper;

import java.util.concurrent.Executor;
import jeus.io.Selector;
import jeus.io.helper.IOComponentCreator;
import jeus.util.oneport.OnePortServer;
import jeus.util.properties.JeusNetProperties;

public class JeusIOComponentCreator {
    public static final IOComponentCreator DEFAULT_CREATOR;
    public static final IOComponentCreator DEFAULT_NIO_CREATOR;
    public static final IOComponentCreator DEFAULT_SOCKET_BLOCKING_CREATOR;
    public static final IOComponentCreator DEFAULT_CHANNEL_BLOCKING_CREATOR;
    private static Selector defaultSelector;
    private static Selector defaultNioSelector;
    private static Selector defaultBlockingSelector;
    private static Selector defaultChannelBlockingSelector;
    private static Selector defaultSocketBlockingSelector;

    public static IOComponentCreator createBlockingCreator(String name, int expectedConnectionNumber) {
        if (JeusNetProperties.BLOCKING_TYPE.equals("socket")) {
            return JeusIOComponentCreator.createSocketBlockingCreator(name, expectedConnectionNumber);
        }
        return JeusIOComponentCreator.createChannelBlockingCreator(name, expectedConnectionNumber);
    }

    public static IOComponentCreator createSocketBlockingCreator(String name, int expectedConnectionNumber) {
        IOComponentCreator creator = IOComponentCreator.createBlockingCreator(name, 2, true);
        creator.setVirtualServer(OnePortServer.getInstance(false));
        return creator;
    }

    public static IOComponentCreator createSocketBlockingCreator(String name, Executor executor) {
        IOComponentCreator creator = IOComponentCreator.createBlockingCreatorWithReadPool(name, executor, 2);
        creator.setVirtualServer(OnePortServer.getInstance(false));
        return creator;
    }

    public static IOComponentCreator createChannelBlockingCreator(String name, int expectedConnectionNumber) {
        IOComponentCreator creator = IOComponentCreator.createBlockingCreator(name, 3, true);
        creator.setVirtualServer(OnePortServer.getInstance(false));
        return creator;
    }

    public static IOComponentCreator createNIOCreator(String name) {
        IOComponentCreator creator = new IOComponentCreator(1, name, true);
        creator.setVirtualServer(OnePortServer.getInstance(false));
        return creator;
    }

    public static IOComponentCreator createNIOCreator(String name, int writeLimit, int writeRestart) {
        return JeusIOComponentCreator.createNIOCreator(name, JeusNetProperties.WRITE_REPEAT_COUNT, writeLimit, writeRestart);
    }

    public static IOComponentCreator createNIOCreator(String name, int writeRepeat, int writeLimit, int writeRestart) {
        IOComponentCreator creator = new IOComponentCreator(1, name, writeRepeat, writeLimit, writeRestart);
        creator.setVirtualServer(OnePortServer.getInstance(false));
        return creator;
    }

    public static synchronized Selector getDefaultBlockingSelector() {
        if (defaultBlockingSelector == null) {
            defaultBlockingSelector = DEFAULT_SOCKET_BLOCKING_CREATOR.createSelector("BlockingSelector", 0, false);
        }
        return defaultBlockingSelector;
    }

    public static synchronized Selector getDefaultChannelBlockingSelector() {
        if (defaultChannelBlockingSelector == null) {
            defaultChannelBlockingSelector = DEFAULT_CHANNEL_BLOCKING_CREATOR.createSelector("ChannelBlockingSelector", 0, false);
        }
        return defaultChannelBlockingSelector;
    }

    public static synchronized Selector getDefaultSocketBlockingSelector() {
        if (defaultSocketBlockingSelector == null) {
            defaultSocketBlockingSelector = DEFAULT_SOCKET_BLOCKING_CREATOR.createSelector("SocketBlockingSelector", 0, false);
        }
        return defaultSocketBlockingSelector;
    }

    public static synchronized Selector getDefaultNioSelector() {
        if (defaultNioSelector == null) {
            defaultNioSelector = DEFAULT_NIO_CREATOR.createSelector("NIOSelector", JeusNetProperties.NUM_SELECTOR, false);
        }
        return defaultNioSelector;
    }

    public static synchronized Selector getDefaultselector() {
        if (defaultSelector == null) {
            defaultSelector = DEFAULT_CREATOR.createSelector("DefaultSelector", JeusNetProperties.NUM_SELECTOR, false);
        }
        return defaultSelector;
    }

    public static void destroySelector() {
        if (defaultSelector != null) {
            defaultSelector.destroySelector();
        }
        if (defaultNioSelector != null) {
            defaultNioSelector.destroySelector();
        }
        if (defaultBlockingSelector != null) {
            defaultBlockingSelector.destroySelector();
        }
        if (defaultSocketBlockingSelector != null) {
            defaultSocketBlockingSelector.destroySelector();
        }
        if (defaultChannelBlockingSelector != null) {
            defaultChannelBlockingSelector.destroySelector();
        }
    }

    static {
        DEFAULT_SOCKET_BLOCKING_CREATOR = JeusIOComponentCreator.createSocketBlockingCreator("DefaultBlockingCreator", 0);
        DEFAULT_CHANNEL_BLOCKING_CREATOR = JeusIOComponentCreator.createChannelBlockingCreator("DefaultChannelBlockingCreator", 0);
        DEFAULT_NIO_CREATOR = JeusIOComponentCreator.createNIOCreator("DefaultJavaNioCreator");
        DEFAULT_CREATOR = JeusNetProperties.SELECTOR_TYPE.equals("blocking") ? (JeusNetProperties.BLOCKING_TYPE.equals("socket") ? DEFAULT_SOCKET_BLOCKING_CREATOR : DEFAULT_CHANNEL_BLOCKING_CREATOR) : DEFAULT_NIO_CREATOR;
    }
}

