/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.helper;

import java.io.IOException;
import jeus.io.Selector;
import jeus.io.handler.BlockingStreamHandler;
import jeus.io.handler.StreamHandler;
import jeus.io.helper.DualSelectorWrapper;
import jeus.io.impl.nio.NIOSelector;

public class MultiSelectorWrapper
extends Selector {
    private Selector[] selectors;
    private int selectNum;
    private int repeat;

    public MultiSelectorWrapper(String selectorName, int selectNum, boolean useDualSelector) {
        this.selectNum = selectNum;
        this.selectors = new Selector[selectNum];
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i] = useDualSelector ? new DualSelectorWrapper(selectorName) : NIOSelector.open(selectorName + "-Selector(" + i + ")", true);
        }
    }

    public synchronized void addSelectItem(StreamHandler attacher) throws IOException {
        if (attacher instanceof BlockingStreamHandler) {
            ((BlockingStreamHandler)((Object)attacher)).runThread();
        } else {
            Selector selector = this.selectors[this.repeat % this.selectNum];
            selector.addSelectItem(attacher);
            ++this.repeat;
        }
    }

    public synchronized void updateSelectItem(StreamHandler attacher) throws IOException {
        attacher.getSelector().updateSelectItem(attacher);
    }

    public void removeSelectItem(StreamHandler selectItem) {
        selectItem.getSelector().removeSelectItem(selectItem);
    }

    public void destroySelector() {
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i].destroySelector();
        }
    }

    public int getReadOp() {
        return this.selectors[0].getReadOp();
    }

    public int getWriteOp() {
        return this.selectors[0].getWriteOp();
    }

    public ThreadGroup getThreadGroup() {
        return this.selectors[0].getThreadGroup();
    }
}

