/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.io.handler.ByteArrayIterator;
import jeus.io.handler.FineGrainedCloseStreamContentWriter;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReader;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.handler.StreamContentWriter;
import jeus.io.handler.StreamHandler;
import jeus.util.message.JeusMessage_Network;

public abstract class StreamHandlerImpl
extends StreamHandler {
    protected AtomicBoolean closed;
    private volatile int state;
    protected final StreamContentReceiver listener;
    protected final StreamContentHandlerCreator creator;
    protected StreamContentReader contentReader;
    protected StreamContentWriter contentWriter;
    protected volatile long lastReadTime;
    protected volatile long lastWriteTime;

    protected StreamHandlerImpl(StreamContentReceiver listener, StreamContentHandlerCreator creator) {
        this.listener = listener;
        this.creator = creator;
        this.contentWriter = creator.createContentWriter(this.getSelectorType(), this);
        this.closed = new AtomicBoolean(false);
        this.lastReadTime = System.currentTimeMillis();
        this.lastWriteTime = System.currentTimeMillis();
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public void setLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public boolean isIdleTime(long idleTime) {
        return System.currentTimeMillis() - Math.max(this.lastReadTime, this.lastWriteTime) > idleTime;
    }

    public boolean canWriteAsByte(Object message) {
        return this.contentWriter.canWriteAsByte(message);
    }

    public boolean canWritePiggybackDataAsByte(Object piggybackData) {
        return this.contentWriter.canWritePiggybackDataAsByte(piggybackData);
    }

    public byte[] getPiggybackDataBuffer(Object piggybackData) throws IOException {
        return this.contentWriter.getPiggybackDataBuffer(piggybackData);
    }

    public Object getPiggybackData(byte[] buffer) throws IOException {
        return this.contentReader.getPiggybackData(buffer);
    }

    public void setSocket(Socket socket) throws IOException {
        super.setSocket(socket);
        socket.setTcpNoDelay(true);
        if (this.contentReader == null) {
            this.contentReader = this.creator.createContentReader(this, this.getSelectorType());
        }
    }

    protected abstract int getSelectorType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Exception ex) {
        if (!this.closed.compareAndSet(false, true)) {
            if (logger.isLoggable(JeusMessage_Network._126_LEVEL)) {
                logger.log(JeusMessage_Network._126_LEVEL, JeusMessage_Network._126, (Object)this);
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_Network._100_LEVEL)) {
            logger.log(JeusMessage_Network._100_LEVEL, JeusMessage_Network._100, (Object)this);
        }
        if (this.contentWriter instanceof FineGrainedCloseStreamContentWriter) {
            ((FineGrainedCloseStreamContentWriter)this.contentWriter).preClose();
        }
        try {
            if (ex != null) {
                this.listener.receiveException(ex, this);
            }
        }
        catch (Throwable e) {
            if (logger.isLoggable(JeusMessage_Network._125_LEVEL)) {
                logger.log(JeusMessage_Network._125_LEVEL, JeusMessage_Network._125, this.listener, e);
            }
        }
        finally {
            this.deregister(true);
            this.contentWriter.close();
            this.contentReader.close();
            this.closeSocket();
            if (logger.isLoggable(JeusMessage_Network._127_LEVEL)) {
                logger.log(JeusMessage_Network._127_LEVEL, JeusMessage_Network._127, (Object)this);
            }
        }
        if (this.contentWriter instanceof FineGrainedCloseStreamContentWriter) {
            ((FineGrainedCloseStreamContentWriter)this.contentWriter).postClose();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean write(byte[] bytes) throws IOException {
        return this.write(bytes, 0, bytes.length);
    }

    public boolean write(byte[] bytes, byte[] header) throws IOException {
        return this.write(bytes, 0, bytes.length, header);
    }

    public boolean write(byte[] bytes, int offset, int length) throws IOException {
        return this.write(bytes, offset, length, null);
    }

    public boolean write(byte[] bytes, int offset, int length, byte[] header) throws IOException {
        Object[] buffers;
        this.checkClosed();
        if (logger.isLoggable(JeusMessage_Network._102_LEVEL)) {
            logger.log(JeusMessage_Network._102_LEVEL, JeusMessage_Network._102, (Object)this);
        }
        if ((buffers = this.contentWriter.getBufferToBeWrite(bytes, offset, length, header)) != null) {
            return this.writeInternal(buffers);
        }
        return true;
    }

    public boolean write(Object toBeWritten) throws IOException {
        return this.write(toBeWritten, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(Object toBeWritten, byte[] header) throws IOException {
        this.checkClosed();
        if (logger.isLoggable(JeusMessage_Network._102_LEVEL)) {
            logger.log(JeusMessage_Network._102_LEVEL, JeusMessage_Network._102, (Object)this);
        }
        if (this.canWriteAsByte(toBeWritten)) {
            boolean result;
            block12: {
                ByteArrayIterator iterator = this.contentWriter.getBufferAsByte(toBeWritten, header);
                result = true;
                iterator.beginIteration();
                try {
                    if (iterator.hasOneMore()) {
                        Object object = this.getWriteLock();
                        synchronized (object) {
                            while (iterator.hasNext()) {
                                Object[] buffer = (Object[])iterator.next();
                                result = this.writeInternal(buffer) && result;
                            }
                            break block12;
                        }
                    }
                    if (iterator.hasNext()) {
                        Object[] buffer = (Object[])iterator.next();
                        result = this.writeInternal(buffer);
                    }
                }
                finally {
                    iterator.endIteration();
                }
            }
            return result;
        }
        Object[] buffer = this.contentWriter.getBufferToBeWrite(toBeWritten, header);
        if (buffer != null) {
            return this.writeInternal(buffer);
        }
        return true;
    }

    public abstract boolean writeInternal(Object[] var1) throws IOException;

    public void reportException(Exception exception) {
        this.close(exception);
    }

    public void setState(int read_state) {
        this.state |= read_state;
    }

    public void unsetState(int read_state) {
        this.state &= ~read_state;
    }

    public boolean isNotInState(int notState) {
        return (this.state & notState) == 0;
    }

    public boolean isInState(int notState) {
        return (this.state & notState) != 0;
    }

    public StreamContentReader getContentReader() {
        return this.contentReader;
    }

    protected Object readMessage() throws Exception {
        return this.contentReader.readMessage();
    }

    protected void dispatchMessage(Object obj) {
        if (logger.isLoggable(JeusMessage_Network._101_LEVEL)) {
            logger.log(JeusMessage_Network._101_LEVEL, JeusMessage_Network._101, (Object)this);
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            this.listener.receiveContent(objs[0], this, (byte[])objs[1]);
        } else {
            this.listener.receiveContent(obj, this, null);
        }
    }

    protected void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("already called the close method of stream handlder : [" + this.getSocketInfo() + "], " + this);
        }
    }
}

