/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.impl.IStreamHandler14;
import jeus.io.impl.StreamHandlerImpl;
import jeus.util.message.JeusMessage_Network;

public abstract class StreamHandlerImpl14
extends StreamHandlerImpl
implements IStreamHandler14 {
    protected StreamHandlerImpl14(StreamContentReceiver listener, StreamContentHandlerCreator creator) {
        super(listener, creator);
    }

    public boolean write(ByteBuffer toBeWritten) throws IOException {
        return this.write(toBeWritten, null);
    }

    public boolean write(ByteBuffer toBeWritten, byte[] header) throws IOException {
        Object[] buffer;
        this.checkClosed();
        if (logger.isLoggable(JeusMessage_Network._102_LEVEL)) {
            logger.log(JeusMessage_Network._102_LEVEL, JeusMessage_Network._102, (Object)this);
        }
        if ((buffer = this.contentWriter.getBufferToBeWrite(toBeWritten, header)) != null) {
            return this.writeInternal(buffer);
        }
        return true;
    }

    public ByteBuffer createByteBuffer(int size) {
        return this.creator.createByteBuffer(size);
    }

    protected Object readMessage() throws Exception {
        try {
            return super.readMessage();
        }
        catch (ClosedByInterruptException ex) {
            Thread.interrupted();
            throw ex;
        }
    }

    public boolean write(Object toBeWritten) throws IOException {
        if (toBeWritten instanceof ByteBuffer) {
            return this.write((ByteBuffer)toBeWritten);
        }
        return super.write(toBeWritten);
    }

    public boolean write(Object toBeWritten, byte[] header) throws IOException {
        if (toBeWritten instanceof ByteBuffer) {
            return this.write((ByteBuffer)toBeWritten, header);
        }
        return super.write(toBeWritten, header);
    }
}

