/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blocking.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Executor;
import jeus.io.handler.BlockingStreamHandler;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.impl.StreamHandlerImpl14;
import jeus.util.ByteArray;
import jeus.util.message.JeusMessage_Network;

public class BlockingStreamHandlerImpl14
extends StreamHandlerImpl14
implements Runnable,
BlockingStreamHandler {
    private OutputStream out;
    private final Executor threadPool;

    public BlockingStreamHandlerImpl14(StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator creator, Executor executor) {
        super(myObjectReceiver, creator);
        assert (executor != null);
        this.threadPool = executor;
    }

    public void setSocket(Socket socket) throws IOException {
        this.out = socket.getOutputStream();
        super.setSocket(socket);
    }

    protected int getSelectorType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket socket = this.getSocket();
        Thread t = Thread.currentThread();
        String name = t.getName();
        t.setName(name + "[" + socket + "]");
        try {
            while (!this.isClosed()) {
                if (logger.isLoggable(JeusMessage_Network._105_LEVEL)) {
                    logger.log(JeusMessage_Network._105_LEVEL, JeusMessage_Network._105, (Object)this);
                }
                try {
                    Object obj = this.readMessage();
                    if (obj == null) continue;
                    this.dispatchMessage(obj);
                }
                catch (Exception ex) {
                    this.reportException(ex);
                }
            }
            return;
        }
        finally {
            t.setName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeInternal(Object[] buffers) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] instanceof ByteArray) {
                    ByteArray array = (ByteArray)buffers[i];
                    this.out.write(array.getArray(), array.getOffset(), array.getLength());
                } else {
                    this.out.write((byte[])buffers[i]);
                }
                this.lastWriteTime = System.currentTimeMillis();
            }
        }
        return true;
    }

    public Object getWriteLock() {
        return this.out;
    }

    public void runThread() {
        if (logger.isLoggable(JeusMessage_Network._106_LEVEL)) {
            logger.log(JeusMessage_Network._106_LEVEL, JeusMessage_Network._106, (Object)this);
        }
        this.threadPool.execute(this);
    }
}

