/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blocking.protocol.message;

import java.io.DataInputStream;
import java.io.IOException;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.blocking.util.ByteArrayInputStream;
import jeus.io.impl.blocking.util.NBIOBuffer;
import jeus.io.protocol.message.ContentBuffer;
import jeus.util.ObjectInputStreamWithLoader;

public class BlockingContentBuffer
extends ContentBuffer {
    protected NBIOBuffer buffer;
    private DataInputStream is;
    protected ByteArrayInputStream arrayStream;
    private ClassLoader classloader;
    private final StreamHandlerImpl endpoint;

    public BlockingContentBuffer(StreamHandlerImpl endpoint, ClassLoader loader) throws IOException {
        this.endpoint = endpoint;
        this.classloader = loader;
        this.buffer = new NBIOBuffer(endpoint.getSocket().getInputStream(), 0);
        this.arrayStream = new ByteArrayInputStream();
        this.is = new DataInputStream(this.arrayStream);
    }

    public int read() throws IOException {
        this.buffer.blockRead();
        this.endpoint.setLastReadTime(System.currentTimeMillis());
        return this.buffer.position();
    }

    public byte[] readByteArrayFromBuffer(int appLength) {
        return this.arrayStream.getBytes(appLength);
    }

    protected Object readObjectFromBuffer(int appLength) throws IOException, ClassNotFoundException {
        ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader(this.arrayStream, this.classloader);
        return ois.readObject();
    }

    public int readIntFromBuffer() throws IOException {
        return this.is.readInt();
    }

    public void setReadBufferState() {
        this.arrayStream.setByteArray(this.buffer.getBytes());
        this.buffer.free();
    }

    protected void prepareForData(int length) {
        this.buffer.reset(length);
    }

    protected int position() {
        return this.buffer.position();
    }

    public void close() {
    }

    public byte[] readByteArrayFromBuffer(byte[] recvBuffer, int bufPosition, int appLength) {
        return this.arrayStream.getBytes(recvBuffer, bufPosition, appLength);
    }

    public void resetBufferInternal(int size) {
        this.buffer.reset(size);
    }
}

