/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blocking.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class NBIOBuffer {
    private int totalSize;
    private byte[] buffer;
    private int current;
    private InputStream input;

    public NBIOBuffer(InputStream input, int totalSize) {
        this.totalSize = totalSize;
        this.buffer = new byte[totalSize];
        this.input = input;
    }

    public boolean blockRead() throws IOException {
        int size = this.input.read(this.buffer, this.current, this.totalSize - this.current);
        if (size == -1) {
            throw new EOFException();
        }
        this.current += size;
        return this.current == this.totalSize;
    }

    public void reset() {
        this.current = 0;
    }

    public void reset(int totalSize) {
        this.buffer = new byte[totalSize];
        this.totalSize = totalSize;
        this.current = 0;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public void free() {
        this.buffer = null;
    }

    public int position() {
        return this.current;
    }
}

