/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blockingChannel.util.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.blockingChannel.util.BlockingChannelInputStreamBuffer;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.protocol.message.ssl.SSLContentBufferWrapper;
import jeus.io.protocol.message.ssl.SSLInputStreamBuffer;

public class SSLBlockingChannelInputStreamBuffer
extends BlockingChannelInputStreamBuffer
implements SSLInputStreamBuffer {
    private AdvancedByteBuffer sslInBuffer;
    private SSLEngine engine;
    private final Object lock;

    public SSLBlockingChannelInputStreamBuffer(StreamHandlerImpl endpoint, SSLEngine engine) {
        this(endpoint, engine, engine);
    }

    public SSLBlockingChannelInputStreamBuffer(StreamHandlerImpl endpoint, SSLEngine engine, Object lock) {
        super(endpoint, engine.getSession().getApplicationBufferSize());
        this.engine = engine;
        this.lock = lock;
        this.sslInBuffer = new AdvancedByteBuffer(engine.getSession().getPacketBufferSize());
    }

    public int read() throws IOException {
        return SSLContentBufferWrapper.readSSL(this);
    }

    public AdvancedByteBuffer getInBuffer() {
        return this.advancedByteBuffer;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    public Object getLock() {
        return this.lock;
    }

    public StreamHandlerImpl getEndpoint() {
        return this.endpoint;
    }

    public AdvancedByteBuffer getSSLInBuffer() {
        return this.sslInBuffer;
    }

    public int readBuffer(ByteBuffer inBuffer) throws IOException {
        return super.readBuffer(inBuffer);
    }
}

