/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.impl.StreamHandlerImpl;
import jeus.util.message.JeusMessage_Network;

public class LocalStreamHandlerImpl
extends StreamHandlerImpl {
    protected LocalStreamHandlerImpl opposite;

    public LocalStreamHandlerImpl(StreamContentReceiver myObjectReceiver, StreamContentHandlerCreator creator, Object stream) {
        super(myObjectReceiver, creator);
    }

    protected int getSelectorType() {
        return 4;
    }

    public boolean writeInternal(Object[] buffer) throws IOException {
        throw new RuntimeException();
    }

    public boolean write(byte[] bytes) throws IOException {
        byte[] clone = new byte[bytes.length];
        System.arraycopy(bytes, 0, clone, 0, bytes.length);
        this.opposite.listener.receiveContent(clone, this, null);
        this.lastWriteTime = System.currentTimeMillis();
        return true;
    }

    public boolean write(byte[] bytes, byte[] header) throws IOException {
        byte[] clone = new byte[bytes.length];
        System.arraycopy(bytes, 0, clone, 0, bytes.length);
        byte[] headerClone = new byte[header.length];
        System.arraycopy(header, 0, headerClone, 0, header.length);
        this.opposite.listener.receiveContent(clone, this, header);
        this.lastWriteTime = System.currentTimeMillis();
        return true;
    }

    public boolean write(byte[] bytes, int offset, int length) throws IOException {
        byte[] clone = new byte[bytes.length];
        System.arraycopy(bytes, 0, clone, offset, length);
        this.opposite.listener.receiveContent(clone, this, null);
        this.lastWriteTime = System.currentTimeMillis();
        return true;
    }

    public boolean write(byte[] bytes, int offset, int length, byte[] header) throws IOException {
        byte[] clone = new byte[bytes.length];
        System.arraycopy(bytes, 0, clone, 0, bytes.length);
        byte[] headerClone = new byte[header.length];
        System.arraycopy(header, 0, headerClone, 0, header.length);
        this.opposite.listener.receiveContent(clone, this, header);
        this.lastWriteTime = System.currentTimeMillis();
        return true;
    }

    public void close(Exception ex) {
        block4: {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            if (ex != null) {
                try {
                    this.listener.receiveException(ex, this);
                }
                catch (Exception ex1) {
                    if (!logger.isLoggable(JeusMessage_Network._125_LEVEL)) break block4;
                    logger.log(JeusMessage_Network._125_LEVEL, JeusMessage_Network._125, this.listener, (Throwable)ex);
                }
            }
        }
        this.opposite.close(ex);
        this.contentWriter.close();
    }

    public boolean write(Object toBeWritten) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = this.contentWriter.makeOutputStream(baos);
        os.writeObject(toBeWritten);
        try {
            Object obj = this.opposite.contentWriter.makeInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
            this.opposite.listener.receiveContent(obj, this, null);
        }
        catch (ClassNotFoundException e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return true;
    }

    public boolean write(Object toBeWritten, byte[] header) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = this.contentWriter.makeOutputStream(baos);
        os.writeObject(toBeWritten);
        try {
            Object obj = this.opposite.contentWriter.makeInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
            byte[] headerClone = new byte[header.length];
            System.arraycopy(header, 0, headerClone, 0, header.length);
            this.opposite.listener.receiveContent(obj, this, headerClone);
        }
        catch (ClassNotFoundException e) {
            IOException ex = new IOException();
            ex.initCause(e);
            throw ex;
        }
        return true;
    }

    public boolean write(ByteBuffer toBeWritten) throws IOException {
        toBeWritten.flip();
        toBeWritten.position(8);
        byte[] clone = new byte[toBeWritten.remaining()];
        toBeWritten.get(clone);
        this.opposite.listener.receiveContent(clone, this, null);
        return true;
    }

    public boolean write(ByteBuffer toBeWritten, byte[] header) throws IOException {
        toBeWritten.flip();
        toBeWritten.position(8);
        byte[] clone = new byte[toBeWritten.remaining()];
        toBeWritten.get(clone);
        byte[] headerClone = new byte[header.length];
        System.arraycopy(header, 0, headerClone, 0, header.length);
        this.opposite.listener.receiveContent(clone, this, header);
        return true;
    }

    public Object getWriteLock() {
        return this;
    }

    public void setLocalStreamHandler(LocalStreamHandlerImpl endpoint) {
        this.opposite = endpoint;
    }

    public StreamContentReceiver getContentReceiver() {
        return this.listener;
    }
}

