/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jeus.io.Acceptor14;
import jeus.io.SocketListener;
import jeus.util.message.JeusMessage_Network;

public class ChannelAcceptor
extends Acceptor14 {
    private ServerSocketChannel server;
    private SocketListener listener;

    public ChannelAcceptor(int listenPort, SocketListener listener, int backlog, InetAddress listenHost, String reuseAddress) throws IOException {
        this.server = ServerSocketChannel.open();
        this.listener = listener;
        ServerSocket socket = this.server.socket();
        this.initServerSocket(listenHost, listenPort, socket, reuseAddress, backlog);
    }

    public ChannelAcceptor(ServerSocket serverSocket, SocketListener listener) throws IOException {
        this.server = serverSocket.getChannel();
        if (this.server == null) {
            throw new RuntimeException("cannot support channel selector because this RMIServerSocketFactory cannot create serversocket channel");
        }
        this.listener = listener;
        this.realListenPort = serverSocket.getLocalPort();
    }

    public void run() {
        while (this.isRunning()) {
            try {
                if (logger.isLoggable(JeusMessage_Network._4_LEVEL)) {
                    logger.log(JeusMessage_Network._4_LEVEL, JeusMessage_Network._4, (Object)this);
                }
                SocketChannel socketChannel = this.server.accept();
                if (!this.isRunning()) {
                    return;
                }
                if (logger.isLoggable(JeusMessage_Network._5_LEVEL)) {
                    logger.log(JeusMessage_Network._5_LEVEL, JeusMessage_Network._5, (Object)this);
                }
                this.listener.onSocket(socketChannel.socket());
                this.acceptSucceed();
            }
            catch (IOException e) {
                if (e instanceof ClosedByInterruptException) {
                    Thread.interrupted();
                    try {
                        if (!this.isRunning() || !logger.isLoggable(JeusMessage_Network._6_LEVEL)) break;
                        logger.log(JeusMessage_Network._6_LEVEL, JeusMessage_Network._6, this, (Throwable)e);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                this.acceptFailed(e);
            }
        }
    }

    protected void destroyInternal() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getServerSocketPort() {
        return this.server.socket().getLocalPort();
    }

    public String toString() {
        try {
            if (this.server != null && this.server.socket() != null) {
                return this.server.socket().toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "no server socket information";
    }
}

