/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import jeus.io.Acceptor14;
import jeus.io.SocketListener;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class NonBlockingChannelAcceptor
extends Acceptor14 {
    private final ServerSocketChannel serverSocket = ServerSocketChannel.open();
    private final SocketListener socketListener;
    private final Selector acceptSelector;
    private CountDownLatch latch;

    public NonBlockingChannelAcceptor(int listenPort, SocketListener socketListener, int backlog, InetAddress listenHost, String reuseAddress) throws IOException {
        this.serverSocket.configureBlocking(false);
        this.socketListener = socketListener;
        this.acceptSelector = Selector.open();
        this.latch = new CountDownLatch(0);
        this.initServerSocket(listenHost, listenPort, this.serverSocket.socket(), reuseAddress, backlog);
    }

    protected void initServerSocket(InetAddress listenHost, int listenPort, ServerSocket socket, String reuseAddress, int backlog) throws IOException {
        super.initServerSocket(listenHost, listenPort, socket, reuseAddress, backlog);
        this.serverSocket.register(this.acceptSelector, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.latch = new CountDownLatch(1);
        try {
            while (this.isRunning()) {
                try {
                    Set<SelectionKey> selectedKeys;
                    int nKeys = this.acceptSelector.select(JeusNetProperties.SELECT_TIMEOUT);
                    if (nKeys == 0 || (selectedKeys = this.acceptSelector.selectedKeys()).isEmpty()) continue;
                    Iterator<SelectionKey> selectedKeyIterator = selectedKeys.iterator();
                    SelectionKey selectedKey = selectedKeyIterator.next();
                    if (selectedKey.isAcceptable()) {
                        if (logger.isLoggable(JeusMessage_Network._4_LEVEL)) {
                            logger.log(JeusMessage_Network._4_LEVEL, JeusMessage_Network._4, (Object)this);
                        }
                        SocketChannel socketChannel = this.serverSocket.accept();
                        if (!this.isRunning()) {
                            return;
                        }
                        if (socketChannel != null) {
                            if (logger.isLoggable(JeusMessage_Network._5_LEVEL)) {
                                logger.log(JeusMessage_Network._5_LEVEL, JeusMessage_Network._5, (Object)this);
                            }
                            this.socketListener.onSocket(socketChannel.socket());
                        }
                        this.acceptSucceed();
                    }
                    selectedKeyIterator.remove();
                }
                catch (IOException e) {
                    if (e instanceof ClosedByInterruptException) {
                        Thread.interrupted();
                        try {
                            if (!this.isRunning()) return;
                            if (!logger.isLoggable(JeusMessage_Network._6_LEVEL)) return;
                            logger.log(JeusMessage_Network._6_LEVEL, JeusMessage_Network._6, this, (Throwable)e);
                            return;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            return;
                        }
                    }
                    this.latch.countDown();
                    this.acceptFailed(e);
                    if (!this.isRunning()) continue;
                    this.latch = new CountDownLatch(1);
                }
            }
            return;
        }
        finally {
            this.latch.countDown();
        }
    }

    protected void destroyInternal() {
        this.acceptSelector.wakeup();
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.acceptSelector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getServerSocketPort() {
        return this.serverSocket.socket().getLocalPort();
    }

    public String toString() {
        try {
            if (this.serverSocket != null && this.serverSocket.socket() != null) {
                return this.serverSocket.socket().toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "no server socket information";
    }
}

