/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import jeus.io.impl.nio.util.BufferCache;
import jeus.util.ArrayListStack;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class ByteBufferCreator {
    public static final int DEFAULT_BUFFER_SIZE = JeusNetProperties.TCP_BUFFER_SIZE;
    public static final boolean useHeapByteBuffer = JeusNetProperties.USE_HEAP_BYTE_BUFFER;
    public static final boolean useConcurrentHeapBufferCache = JeusNetProperties.USE_CONCURRENT_HEAP_BUFFER_CACHE;
    public static final boolean useViewBuffer = JeusNetProperties.USE_VIEW_BUFFER;
    public static final ByteBuffer dummyBuffer = ByteBuffer.allocate(0);
    public static final ByteBuffer[] dummyBuffers = new ByteBuffer[]{dummyBuffer};
    private static final BufferCache directCache = new NewDirectBufferCache();
    private static final BufferCache heapCache = new ConcurrentHeapBufferCache();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public static ByteBuffer allocateDirectByteBuffer(int size) {
        return directCache.getByteBuffer(size);
    }

    public static ByteBuffer allocateByteBuffer(boolean isDirect, int size) {
        return ByteBufferCreator.allocateByteBuffer(isDirect, size, false);
    }

    public static ByteBuffer allocateByteBuffer(boolean isDirect, int size, boolean setLimitToSize) {
        ByteBuffer buffer = useHeapByteBuffer || !isDirect ? (useViewBuffer && useConcurrentHeapBufferCache ? heapCache.getByteBuffer(size) : ByteBuffer.allocate(size)) : directCache.getByteBuffer(size);
        if (setLimitToSize) {
            buffer.limit(size);
        }
        return buffer;
    }

    public static void freeByteBuffer(ByteBuffer buffer) {
        if (buffer == null || buffer.isReadOnly()) {
            return;
        }
        if (buffer.isDirect()) {
            directCache.release(buffer);
        } else {
            heapCache.release(buffer);
        }
    }

    public static int cachedDirectBuffer() {
        return directCache.cachedByteBuffer();
    }

    public static int totalDirectBuffer() {
        return directCache.totalByteBuffer();
    }

    public static int viewBufferCount() {
        return directCache.viewBufferCount();
    }

    public static int nonViewBufferCount() {
        return directCache.nonViewBufferCount();
    }

    public static void main(String[] args) {
        ByteBuffer buffer = ByteBufferCreator.allocateByteBuffer(true, 32, true);
        System.out.println("***** buffer capacity : " + buffer.capacity() + ", pos : " + buffer.position() + ", limit : " + buffer.limit());
    }

    private static class NewDirectBufferCache
    implements BufferCache {
        private final ConcurrentLinkedQueue<ByteBuffer>[] bufferQueues;
        private final int[] indexer;
        private volatile int total;
        public static int capacity = JeusNetProperties.VIEW_BUFFER_SIZE;
        public static int cacheFlushCapacity = JeusNetProperties.CACHE_FLUSH_BUFFER_SIZE;
        private ReentrantLock allocLock = new ReentrantLock();
        private ByteBuffer sourceBuffer;

        private NewDirectBufferCache() {
            this.bufferQueues = new ConcurrentLinkedQueue[31];
            this.indexer = new int[31];
            for (int i = 0; i < this.indexer.length; ++i) {
                this.indexer[i] = 1 << i;
                this.bufferQueues[i] = new ConcurrentLinkedQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer allocateView(int size) {
            try {
                this.allocLock.lockInterruptibly();
                if (this.sourceBuffer == null || this.sourceBuffer.capacity() - this.sourceBuffer.position() < size) {
                    if (size < capacity) {
                        this.sourceBuffer = this.allocateDirectBuffer(capacity);
                    } else {
                        ByteBuffer byteBuffer = this.allocateDirectBuffer(size);
                        return byteBuffer;
                    }
                }
                this.sourceBuffer.limit(this.sourceBuffer.position() + size);
                ByteBuffer view = this.sourceBuffer.slice();
                this.sourceBuffer.position(this.sourceBuffer.limit());
                ByteBuffer byteBuffer = view;
                return byteBuffer;
            }
            catch (InterruptedException e) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                return byteBuffer;
            }
            finally {
                this.allocLock.unlock();
            }
        }

        private void checkCacheFlush() {
            if (this.total > cacheFlushCapacity) {
                this.clearAll();
            }
        }

        public ByteBuffer getByteBuffer(int size) {
            int index = this.ceilIndex(size);
            int allocateSize = this.indexer[index];
            ConcurrentLinkedQueue<ByteBuffer> queue = this.bufferQueues[index];
            ByteBuffer buffer = queue.poll();
            if (buffer != null) {
                return buffer;
            }
            return this.allocateNew(allocateSize);
        }

        private ByteBuffer allocateNew(int allocateSize) {
            ByteBuffer buffer;
            if (JeusNetProperties.USE_VIEW_BUFFER) {
                buffer = this.allocateView(allocateSize);
            } else {
                try {
                    buffer = this.allocateDirectBuffer(allocateSize);
                }
                catch (InterruptedException e) {
                    buffer = ByteBuffer.allocate(allocateSize);
                }
            }
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer allocateDirectBuffer(int allocateSize) throws InterruptedException {
            this.allocLock.lockInterruptibly();
            try {
                ByteBuffer buffer;
                this.checkCacheFlush();
                try {
                    buffer = ByteBuffer.allocateDirect(allocateSize);
                    this.total += buffer.capacity();
                }
                catch (OutOfMemoryError error) {
                    if (logger.isLoggable(JeusMessage_Network._301_LEVEL)) {
                        logger.log(JeusMessage_Network._301_LEVEL, JeusMessage_Network._301, (Throwable)error);
                    }
                    buffer = ByteBuffer.allocate(allocateSize);
                }
                ByteBuffer byteBuffer = buffer;
                return byteBuffer;
            }
            finally {
                this.allocLock.unlock();
            }
        }

        public void release(ByteBuffer buffer) {
            if (logger.isLoggable(JeusMessage_Network._302_LEVEL)) {
                logger.log(JeusMessage_Network._302_LEVEL, JeusMessage_Network._302);
            }
            buffer.clear();
            int index = this.ceilIndex(buffer.capacity());
            ConcurrentLinkedQueue<ByteBuffer> bufferQueue = this.bufferQueues[index];
            bufferQueue.offer(buffer);
        }

        private int ceilIndex(int size) {
            int index = Arrays.binarySearch(this.indexer, size);
            return index < 0 ? -(index + 1) : index;
        }

        private void clearAll() {
            for (int i = 0; i < this.bufferQueues.length; ++i) {
                this.bufferQueues[i].clear();
            }
            this.total = 0;
        }

        public int totalByteBuffer() {
            return this.total;
        }

        public int cachedByteBuffer() {
            return 0;
        }

        public int viewBufferCount() {
            return 0;
        }

        public int nonViewBufferCount() {
            return 0;
        }
    }

    private static class HeapBufferCache
    implements BufferCache {
        public static int capacity = JeusNetProperties.VIEW_BUFFER_SIZE;
        private ByteBuffer byteBuffer;
        private int viewBufferNotUsed;
        private int viewBufferUsed;
        private final ReentrantLock lock = new ReentrantLock();

        private HeapBufferCache() {
        }

        public ByteBuffer getByteBuffer(int size) {
            if (JeusNetProperties.USE_VIEW_BUFFER) {
                return this.allocateView(size);
            }
            return ByteBuffer.allocate(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer allocateView(int size) {
            ByteBuffer buffer = null;
            if (size * 4 < capacity && this.lock.tryLock()) {
                try {
                    if (this.byteBuffer == null || this.byteBuffer.capacity() - this.byteBuffer.position() < size) {
                        this.byteBuffer = null;
                        this.byteBuffer = this.allocateHeapBuffer(capacity, true);
                    }
                    ++this.viewBufferUsed;
                    this.byteBuffer.limit(this.byteBuffer.position() + size);
                    buffer = this.byteBuffer.slice();
                    this.byteBuffer.position(this.byteBuffer.limit());
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (buffer == null) {
                buffer = this.allocateHeapBuffer(size, false);
            }
            return buffer;
        }

        private ByteBuffer allocateHeapBuffer(int allocateSize, boolean viewBuffer) {
            if (!viewBuffer) {
                ++this.viewBufferNotUsed;
            }
            return ByteBuffer.allocate(allocateSize);
        }

        public void release(ByteBuffer buffer) {
        }

        public int cachedByteBuffer() {
            return 0;
        }

        public int totalByteBuffer() {
            return 0;
        }

        public int viewBufferCount() {
            return this.viewBufferUsed;
        }

        public int nonViewBufferCount() {
            return this.viewBufferNotUsed;
        }
    }

    private static class ConcurrentHeapBufferCache
    implements BufferCache {
        private final int count = JeusNetProperties.HEAP_BUFFER_CACHE_COUNT <= 0 ? Runtime.getRuntime().availableProcessors() : JeusNetProperties.HEAP_BUFFER_CACHE_COUNT;
        private final HeapBufferCache[] caches = new HeapBufferCache[this.count];

        private ConcurrentHeapBufferCache() {
            for (int i = 0; i < this.count; ++i) {
                this.caches[i] = new HeapBufferCache();
            }
        }

        public ByteBuffer getByteBuffer(int size) {
            int index = Math.abs(Thread.currentThread().hashCode()) % this.count;
            return this.caches[index].getByteBuffer(size);
        }

        public void release(ByteBuffer buffer) {
        }

        public int cachedByteBuffer() {
            return 0;
        }

        public int totalByteBuffer() {
            return 0;
        }

        public int viewBufferCount() {
            return 0;
        }

        public int nonViewBufferCount() {
            return 0;
        }
    }

    private static class DirectBufferCache
    implements BufferCache {
        private HashMap<Integer, ArrayListStack> directBufferMap = new HashMap();
        private int[] indexer = new int[31];
        private int cached;
        private int total;
        public static int capacity = JeusNetProperties.VIEW_BUFFER_SIZE;
        public static int cacheFlushCapacity = JeusNetProperties.CACHE_FLUSH_BUFFER_SIZE;
        private ByteBuffer byteBuffer;
        private int viewBufferNotUsed;
        private int viewBufferUsed;

        private DirectBufferCache() {
            for (int i = 0; i < this.indexer.length; ++i) {
                this.indexer[i] = 1 << i;
            }
        }

        public synchronized ByteBuffer allocateView(int size) {
            if (this.byteBuffer == null || this.byteBuffer.capacity() - this.byteBuffer.position() < size) {
                if (size < capacity) {
                    this.byteBuffer = this.allocateDirectBuffer(capacity, true);
                } else {
                    return this.allocateDirectBuffer(size, false);
                }
            }
            ++this.viewBufferUsed;
            this.byteBuffer.limit(this.byteBuffer.position() + size);
            ByteBuffer view = this.byteBuffer.slice();
            this.byteBuffer.position(this.byteBuffer.limit());
            return view;
        }

        private synchronized void checkCacheFlush() {
            if (this.total > cacheFlushCapacity) {
                this.clearAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer getByteBuffer(int size) {
            int index = this.ceilIndex(size);
            int allocateSize = this.indexer[index];
            ArrayListStack bufferList = this.getBufferList(index);
            ByteBuffer buffer = null;
            Object object = bufferList;
            synchronized (object) {
                if (!bufferList.isEmpty()) {
                    buffer = (ByteBuffer)bufferList.pop();
                }
            }
            if (buffer != null) {
                object = this;
                synchronized (object) {
                    this.cached -= buffer.capacity();
                }
                return buffer;
            }
            return this.allocateNew(allocateSize);
        }

        private ByteBuffer allocateNew(int allocateSize) {
            ByteBuffer buffer;
            try {
                buffer = JeusNetProperties.USE_VIEW_BUFFER ? this.allocateView(allocateSize) : this.allocateDirectBuffer(allocateSize, false);
            }
            catch (OutOfMemoryError error) {
                if (logger.isLoggable(JeusMessage_Network._301_LEVEL)) {
                    logger.log(JeusMessage_Network._301_LEVEL, JeusMessage_Network._301, (Throwable)error);
                }
                this.clearAll();
                buffer = ByteBuffer.allocate(allocateSize);
            }
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer allocateDirectBuffer(int allocateSize, boolean viewBuffer) {
            DirectBufferCache directBufferCache = this;
            synchronized (directBufferCache) {
                if (!viewBuffer) {
                    ++this.viewBufferNotUsed;
                }
                this.checkCacheFlush();
                this.total += allocateSize;
            }
            return ByteBuffer.allocateDirect(allocateSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(ByteBuffer buffer) {
            ArrayListStack bufferList;
            if (logger.isLoggable(JeusMessage_Network._302_LEVEL)) {
                logger.log(JeusMessage_Network._302_LEVEL, JeusMessage_Network._302);
            }
            buffer.clear();
            int index = this.ceilIndex(buffer.capacity());
            ArrayListStack arrayListStack = bufferList = this.getBufferList(index);
            synchronized (arrayListStack) {
                bufferList.push(buffer);
                this.cached += buffer.capacity();
            }
        }

        private int ceilIndex(int size) {
            int index = Arrays.binarySearch(this.indexer, size);
            return index < 0 ? -(index + 1) : index;
        }

        private synchronized ArrayListStack getBufferList(int index) {
            Integer key = new Integer(index);
            ArrayListStack stack = this.directBufferMap.get(key);
            if (stack == null) {
                stack = new ArrayListStack();
                this.directBufferMap.put(key, stack);
            }
            return stack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void clearAll() {
            for (ArrayListStack stack : this.directBufferMap.values()) {
                if (stack == null) continue;
                ArrayListStack arrayListStack = stack;
                synchronized (arrayListStack) {
                    stack.clear();
                }
            }
            this.cached = 0;
            this.total = 0;
            this.directBufferMap.clear();
        }

        public int cachedByteBuffer() {
            return this.cached;
        }

        public int totalByteBuffer() {
            return this.total;
        }

        public int viewBufferCount() {
            return this.viewBufferUsed;
        }

        public int nonViewBufferCount() {
            return this.viewBufferNotUsed;
        }
    }
}

