/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util.aloc;

import java.nio.ByteBuffer;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.aloc.BufferAllocationStrategy;

public class FreeBufferAsapStrategy
implements BufferAllocationStrategy {
    private AdvancedByteBuffer buffer;

    public FreeBufferAsapStrategy(AdvancedByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer ensureBufferSize(int bufferSize) {
        int allocSize;
        if (this.buffer.getByteBuffer().capacity() > ByteBufferCreator.DEFAULT_BUFFER_SIZE) {
            allocSize = bufferSize < ByteBufferCreator.DEFAULT_BUFFER_SIZE && this.buffer.getByteBuffer().remaining() < ByteBufferCreator.DEFAULT_BUFFER_SIZE ? ByteBufferCreator.DEFAULT_BUFFER_SIZE : (bufferSize > this.buffer.getByteBuffer().remaining() ? bufferSize : this.buffer.getByteBuffer().remaining());
        } else if (bufferSize > this.buffer.getByteBuffer().capacity()) {
            allocSize = bufferSize;
        } else {
            return null;
        }
        ByteBuffer newInBuffer = ByteBufferCreator.allocateByteBuffer(true, allocSize);
        newInBuffer.put(this.buffer.getByteBuffer());
        return newInBuffer;
    }
}

