/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message;

import java.io.IOException;
import jeus.io.handler.StreamContentBuffer;
import jeus.util.properties.JeusNetProperties;

public abstract class ContentBuffer
implements StreamContentBuffer {
    private int appLength;

    protected abstract void prepareForData(int var1);

    public void resetBuffer(int size) throws IOException {
        if ((long)size > JeusNetProperties.MESSAGE_MAX_SIZ) {
            throw new IOException("This message length(" + size + ") is over the max limit(" + JeusNetProperties.MESSAGE_MAX_SIZ + "). Check the message or increase max size.");
        }
        this.resetBufferInternal(size);
        this.appLength = size;
    }

    protected abstract void resetBufferInternal(int var1);

    public boolean readBuffer() throws IOException {
        boolean result;
        if (this.position() >= this.appLength) {
            result = true;
        } else {
            int position = this.read();
            if (position < 0) {
                return false;
            }
            boolean bl = result = position >= this.appLength;
        }
        if (result) {
            this.setReadBufferState();
            return true;
        }
        return false;
    }

    protected abstract void setReadBufferState();

    protected abstract int read() throws IOException;

    public Object readObjectFromBuffer() throws IOException, ClassNotFoundException {
        return this.readObjectFromBuffer(this.appLength);
    }

    protected abstract Object readObjectFromBuffer(int var1) throws IOException, ClassNotFoundException;

    public byte[] readByteArrayFromBuffer() {
        return this.readByteArrayFromBuffer(this.appLength);
    }

    public byte[] readByteArrayFromBuffer(byte[] recvBuffer, int bufPosition) {
        return this.readByteArrayFromBuffer(recvBuffer, bufPosition, this.appLength);
    }

    protected abstract int position();

    public void decreaseAppLength(int headerLength) {
        this.appLength -= headerLength;
    }
}

