/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message.ssl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;

public class SSLConfiguration {
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean setSessionCreation;
    private boolean sessionCreation;
    public static String[] engineSetMethodNames;
    public static Method[] engineSetMethods;
    public static Method[] sslSocketSetMethods;

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public boolean isEnableSessionCreation() {
        return this.sessionCreation;
    }

    public void setEnableSessionCreation(boolean sessionCreation) {
        this.setSessionCreation = true;
        this.sessionCreation = sessionCreation;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public Map getSSLProperties(boolean useClientMode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("useClientMode", useClientMode ? Boolean.TRUE : Boolean.FALSE);
        if (this.cipherSuites != null) {
            props.put("enabledCipherSuites", this.cipherSuites);
        }
        if (this.protocols != null) {
            props.put("enabledProtocols", this.protocols);
        }
        if (this.setSessionCreation) {
            props.put("enableSessionCreation", this.sessionCreation ? Boolean.TRUE : Boolean.FALSE);
        }
        if (!useClientMode) {
            if (this.wantClientAuth) {
                props.put("wantClientAuth", Boolean.TRUE);
            }
            if (this.needClientAuth) {
                props.put("needClientAuth", Boolean.TRUE);
            }
        }
        return props;
    }

    public static void setSSLProperties(Object object, Map sslEngineProperties, String[] engineSetMethodNames, Method[] engineSetMethods) {
        if (sslEngineProperties != null && engineSetMethodNames.length > 0) {
            Set i = sslEngineProperties.entrySet();
            for (Map.Entry entry : i) {
                String key = (String)entry.getKey();
                boolean isSet = false;
                for (int j = 0; j < engineSetMethodNames.length; ++j) {
                    String enginesetmethodname = engineSetMethodNames[j];
                    if (!enginesetmethodname.equals(key)) continue;
                    try {
                        engineSetMethods[j].invoke(object, entry.getValue());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("The key " + key + " is not a set method of SSLEngine : " + e.toString());
                    }
                    isSet = true;
                    break;
                }
                if (isSet) continue;
                throw new IllegalArgumentException("The key " + key + " is not a set method of SSLEngine");
            }
        }
    }

    static {
        try {
            engineSetMethods = new Method[]{SSLEngine.class.getMethod("setEnabledCipherSuites", String[].class), SSLEngine.class.getMethod("setEnableSessionCreation", Boolean.TYPE), SSLEngine.class.getMethod("setNeedClientAuth", Boolean.TYPE), SSLEngine.class.getMethod("setUseClientMode", Boolean.TYPE), SSLEngine.class.getMethod("setEnabledProtocols", String[].class), SSLEngine.class.getMethod("setWantClientAuth", Boolean.TYPE)};
            engineSetMethodNames = new String[]{"enabledCipherSuites", "enableSessionCreation", "needClientAuth", "useClientMode", "enabledProtocols", "wantClientAuth"};
        }
        catch (Throwable ex) {
            engineSetMethods = null;
            engineSetMethodNames = new String[0];
        }
        try {
            sslSocketSetMethods = new Method[]{SSLSocket.class.getMethod("setEnabledCipherSuites", String[].class), SSLSocket.class.getMethod("setEnableSessionCreation", Boolean.TYPE), SSLSocket.class.getMethod("setNeedClientAuth", Boolean.TYPE), SSLSocket.class.getMethod("setUseClientMode", Boolean.TYPE), SSLSocket.class.getMethod("setEnabledProtocols", String[].class), SSLSocket.class.getMethod("setWantClientAuth", Boolean.TYPE)};
        }
        catch (Throwable ex) {
            try {
                sslSocketSetMethods = new Method[]{SSLSocket.class.getMethod("setEnabledCipherSuites", String[].class), SSLSocket.class.getMethod("setEnableSessionCreation", Boolean.TYPE), SSLSocket.class.getMethod("setNeedClientAuth", Boolean.TYPE), SSLSocket.class.getMethod("setUseClientMode", Boolean.TYPE)};
            }
            catch (Throwable ex1) {
                throw new RuntimeException(ex1);
            }
        }
    }
}

