/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message.ssl;

import java.io.IOException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import jeus.io.handler.StreamContentBuffer;
import jeus.io.handler.StreamContentBufferWrapper;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.blockingChannel.util.ssl.SSLBlockingChannelInputStreamBuffer;
import jeus.io.impl.nio.protocol.message.NIOContentBuffer;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.ssl.SSLChannelInputStreamBuffer;
import jeus.io.protocol.message.ssl.SSLContentWriter;
import jeus.io.protocol.message.ssl.SSLInputStreamBuffer;

public class SSLContentBufferWrapper
implements StreamContentBufferWrapper {
    private final Object lock;
    private final SSLEngine engine;

    public SSLContentBufferWrapper(SSLEngine sslEngine) {
        this(sslEngine, sslEngine);
    }

    public SSLContentBufferWrapper(SSLEngine sslEngine, Object lock) {
        this.engine = sslEngine;
        this.lock = lock;
    }

    public StreamContentBuffer createStreamContentBuffer(int selectorType, StreamContentBuffer delegateBuffer, StreamHandler streamHandler) {
        switch (selectorType) {
            case 2: {
                return delegateBuffer;
            }
            case 3: {
                SSLBlockingChannelInputStreamBuffer channelBuffer = new SSLBlockingChannelInputStreamBuffer((StreamHandlerImpl)streamHandler, this.engine, this.lock);
                ((NIOContentBuffer)delegateBuffer).setInputStreamBuffer(channelBuffer);
                return delegateBuffer;
            }
            case 1: {
                SSLChannelInputStreamBuffer channelBuffer = new SSLChannelInputStreamBuffer((StreamHandlerImpl)streamHandler, this.engine, this.lock);
                ((NIOContentBuffer)delegateBuffer).setInputStreamBuffer(channelBuffer);
                return delegateBuffer;
            }
        }
        throw new RuntimeException("no");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readSSL(SSLInputStreamBuffer streamBuffer) throws IOException {
        AdvancedByteBuffer sslInBuffer = streamBuffer.getSSLInBuffer();
        AdvancedByteBuffer inBuffer = streamBuffer.getInBuffer();
        SSLEngine engine = streamBuffer.getEngine();
        StreamHandlerImpl endpoint = streamBuffer.getEndpoint();
        Object lock = streamBuffer.getLock();
        int sslReadResult = SSLContentBufferWrapper.readSSLInputBuffer(streamBuffer);
        if (sslReadResult > 0) {
            while (true) {
                Object object = lock;
                synchronized (object) {
                    SSLEngineResult.Status status;
                    SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
                    boolean shouldNotifyAll = handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                    SSLEngineResult engineResult = engine.unwrap(sslInBuffer.getByteBuffer(), inBuffer.getByteBuffer());
                    if (shouldNotifyAll) {
                        lock.notifyAll();
                    }
                    if ((status = engineResult.getStatus()) == SSLEngineResult.Status.OK) {
                        SSLContentBufferWrapper.checkHandshake(endpoint, engine, streamBuffer);
                        if (!sslInBuffer.hasRemaining()) {
                            break;
                        }
                    } else {
                        if (status == SSLEngineResult.Status.CLOSED) {
                            endpoint.reportException(new IOException("SSLEngine closed"));
                            engine.closeInbound();
                            return -1;
                        }
                        if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            inBuffer.getByteBuffer().flip();
                            if (inBuffer.getByteBuffer().capacity() < engine.getSession().getApplicationBufferSize()) {
                                inBuffer.ensureWhileReadingBuffer(engine.getSession().getApplicationBufferSize());
                            } else {
                                inBuffer.ensureWhileReadingBuffer(inBuffer.getByteBuffer().capacity() * 2);
                            }
                        } else if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            break;
                        }
                    }
                }
            }
        }
        return sslReadResult < 0 ? -1 : inBuffer.position();
    }

    private static int readSSLInputBuffer(SSLInputStreamBuffer streamBuffer) throws IOException {
        AdvancedByteBuffer sslInBuffer = streamBuffer.getSSLInBuffer();
        int packetBufferSize = streamBuffer.getEngine().getSession().getPacketBufferSize();
        sslInBuffer.ensureWhileReadingBuffer(packetBufferSize);
        streamBuffer.readBuffer(sslInBuffer.getByteBuffer());
        sslInBuffer.flip();
        if (streamBuffer.getEndpoint().isClosed()) {
            return -1;
        }
        return sslInBuffer.remaining();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkHandshake(StreamHandlerImpl endpoint, SSLEngine engine, SSLInputStreamBuffer streamBuffer) throws IOException {
        var4_4 = lock = streamBuffer.getLock();
        synchronized (var4_4) {
            block3: while (true) {
                if ((handshakeStatus = engine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    return true;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    SSLContentWriter.writeSSLOutBuffer(engine, lock, streamBuffer.getEndpoint(), ByteBufferCreator.dummyBuffers);
                    continue;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    sslInBuffer = streamBuffer.getSSLInBuffer();
                    if (!sslInBuffer.hasRemaining()) {
                        return false;
                    }
                    position = sslInBuffer.position();
                    inBuffer = streamBuffer.getInBuffer();
                    result = engine.unwrap(sslInBuffer.getByteBuffer(), inBuffer.getByteBuffer());
                    status = result.getStatus();
                    if (status == SSLEngineResult.Status.OK) {
                        if (position != sslInBuffer.position()) continue;
                        return false;
                    }
                    if (status == SSLEngineResult.Status.CLOSED) {
                        endpoint.reportException(new IOException("SSLEngine closed"));
                        engine.closeInbound();
                        return false;
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        inBuffer.getByteBuffer().flip();
                        if (inBuffer.getByteBuffer().capacity() < engine.getSession().getApplicationBufferSize()) {
                            inBuffer.ensureWhileReadingBuffer(engine.getSession().getApplicationBufferSize());
                            continue;
                        }
                        inBuffer.ensureWhileReadingBuffer(inBuffer.getByteBuffer().capacity() * 2);
                        continue;
                    }
                    if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                    return false;
                }
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                runnable = engine.getDelegatedTask();
                while (true) {
                    if (runnable != null) ** break;
                    continue block3;
                    runnable.run();
                    runnable = engine.getDelegatedTask();
                }
                break;
            }
            throw new RuntimeException("never");
        }
    }
}

