/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.protocol.message.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import jeus.io.handler.ByteArrayIterator;
import jeus.io.handler.StreamContentWriter;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.protocol.message.ContentWriter;

public class SSLContentWriter
extends ContentWriter {
    private final Object lock;
    private volatile boolean closed;
    private final SSLEngine engine;
    private StreamContentWriter delegateContentWriter;
    private StreamHandler endpoint;
    private static final SSLContentWriterByteArrayIterator SHARED_BYTE_ITERATOR = new SSLContentWriterByteArrayIterator();

    public SSLContentWriter(SSLEngine engine, StreamContentWriter contentWriter, StreamHandler endpoint) {
        this(engine, engine, contentWriter, endpoint);
    }

    public SSLContentWriter(SSLEngine engine, Object lock, StreamContentWriter contentWriter, StreamHandler endpoint) {
        this.engine = engine;
        this.lock = lock;
        this.closed = false;
        this.delegateContentWriter = contentWriter;
        this.endpoint = endpoint;
    }

    public boolean canWriteAsByte(Object toBeWritten) {
        return this.delegateContentWriter.canWriteAsByte(toBeWritten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayIterator getBufferAsByte(Object toBeWrite, byte[] header) throws IOException {
        block9: {
            ByteArrayIterator iterator = this.delegateContentWriter.getBufferAsByte(toBeWrite, header);
            iterator.beginIteration();
            try {
                if (iterator.hasOneMore()) {
                    Object object = this.endpoint.getWriteLock();
                    synchronized (object) {
                        while (iterator.hasNext()) {
                            Object[] buffer = (Object[])iterator.next();
                            this.getSSLBuffer(buffer);
                        }
                        break block9;
                    }
                }
                if (iterator.hasNext()) {
                    Object[] buffer = (Object[])iterator.next();
                    this.getSSLBuffer(buffer);
                }
            }
            finally {
                iterator.endIteration();
            }
        }
        return SHARED_BYTE_ITERATOR;
    }

    public Object[] getBufferToBeWrite(Object toBeWrite, byte[] header) throws IOException {
        Object[] buffer = this.delegateContentWriter.getBufferToBeWrite(toBeWrite, header);
        return this.getSSLBuffer(buffer);
    }

    public Object[] getBufferToBeWrite(byte[] bytes, int offset, int length, byte[] header) throws IOException {
        Object[] buffer = this.delegateContentWriter.getBufferToBeWrite(bytes, offset, length, header);
        return this.getSSLBuffer(buffer);
    }

    public boolean canWritePiggybackDataAsByte(Object packet) {
        return this.delegateContentWriter.canWritePiggybackDataAsByte(packet);
    }

    public byte[] getPiggybackDataBuffer(Object packet) throws IOException {
        return this.delegateContentWriter.getPiggybackDataBuffer(packet);
    }

    public ObjectOutputStream makeOutputStream(OutputStream bbis) throws IOException {
        return this.delegateContentWriter.makeOutputStream(bbis);
    }

    public ObjectInputStream makeInputStream(InputStream bbis) throws IOException {
        return this.delegateContentWriter.makeInputStream(bbis);
    }

    public Object[] getBufferToBeWrite(ByteBuffer byteBuffer, byte[] header) throws IOException {
        Object[] buffer = this.delegateContentWriter.getBufferToBeWrite(byteBuffer, header);
        return this.getSSLBuffer(buffer);
    }

    private Object[] getSSLBuffer(Object[] buffer) throws IOException {
        SSLEngineResult.Status status;
        ByteBuffer[] buffers = (ByteBuffer[])buffer;
        ByteBuffer lastBuffer = buffers[buffers.length - 1];
        while (true) {
            SSLEngineResult engineResult;
            if ((status = (engineResult = SSLContentWriter.writeSSLOutBuffer(this.engine, this.lock, this.endpoint, buffers)).getStatus()) == SSLEngineResult.Status.OK) {
                if (!this.checkHandshake() || lastBuffer.hasRemaining()) continue;
                return null;
            }
            if (status != SSLEngineResult.Status.BUFFER_OVERFLOW && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
        }
        if (status == SSLEngineResult.Status.CLOSED) {
            throw new IOException("SSLEngine closed");
        }
        throw new RuntimeException("never");
    }

    public static SSLEngineResult writeSSLOutBuffer(SSLEngine engine, StreamHandler endpoint, ByteBuffer[] buffers) throws IOException {
        return SSLContentWriter.writeSSLOutBuffer(engine, engine, endpoint, buffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLEngineResult writeSSLOutBuffer(SSLEngine engine, Object lock, StreamHandler endpoint, ByteBuffer[] buffers) throws IOException {
        SSLEngineResult engineResult;
        ByteBuffer sslOutBuffer = ByteBufferCreator.allocateByteBuffer(true, engine.getSession().getPacketBufferSize());
        Object object = lock;
        synchronized (object) {
            engineResult = buffers.length == 1 ? engine.wrap(buffers[0], sslOutBuffer) : engine.wrap(buffers, sslOutBuffer);
            sslOutBuffer.flip();
            if (sslOutBuffer.hasRemaining()) {
                endpoint.writeInternal(new ByteBuffer[]{sslOutBuffer});
            }
        }
        return engineResult;
    }

    private boolean checkHandshake() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("failed to handshake.");
            }
            block5: while (true) {
                SSLEngineResult.HandshakeStatus handshakeStatus;
                if ((handshakeStatus = this.engine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    return true;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return false;
                }
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.closed) {
                        throw new IOException("failed to handshake.");
                    }
                    return true;
                }
                if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                Runnable runnable = this.engine.getDelegatedTask();
                while (true) {
                    if (runnable == null) continue block5;
                    runnable.run();
                    runnable = this.engine.getDelegatedTask();
                }
                break;
            }
            throw new RuntimeException("never");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preClose() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
    }

    private static class SSLContentWriterByteArrayIterator
    implements ByteArrayIterator {
        private SSLContentWriterByteArrayIterator() {
        }

        public void beginIteration() {
        }

        public boolean hasOneMore() {
            return false;
        }

        public void endIteration() throws IOException {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

