/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.JeusSQLException;
import jeus.jdbc.helper.ConnectionPoolDBAHelper;
import jeus.jdbc.info.DynamicPoolStatsAndInfo;
import jeus.jdbc.info.JDBCPooledConnectionInfo;
import jeus.transaction.GTID;
import jeus.transaction.TMCommonService;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.ScheduleTask;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public abstract class AbstractJeusPooledConnection
implements JeusPooledConnection {
    protected final ConnectionPoolImpl connectionPool;
    protected final PooledConnection actualPooledConn;
    protected Connection connectionHandle;
    protected volatile boolean isShared;
    protected boolean isRawConnection;
    private volatile int referenceCount = 0;
    private volatile boolean closable = true;
    private boolean reuseConnectionHandle;
    private volatile boolean shouldForciblyClosed;
    private volatile boolean closed;
    private final JDBCPooledConnectionInfo info;
    protected XAResourceWrapper xaResourceWrapper;
    protected final long stmtQueryTimeout;
    private long startToUseTime;
    private long lastValidatedTime;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    private final DynamicPoolStatsAndInfo stats;
    private volatile ConnectionEventListener connectionEventListener;
    private volatile boolean useForValidationOnly;
    private volatile boolean isAssociatedWithTx;
    private volatile GTID associatedTxId;
    private String dbSessionId;
    private volatile SessionKillTrigger sessionKillTrigger;
    private volatile String connName;
    private boolean initialAutoCommit;

    AbstractJeusPooledConnection(PooledConnection delegated, String connectionId, ConnectionPoolImpl cp, DynamicPoolStatsAndInfo statHolder, boolean disposable) throws SQLException {
        this.connectionPool = cp;
        this.actualPooledConn = delegated;
        this.stmtQueryTimeout = cp.getConnectionPoolInfo().getStmtQueryTimeout();
        this.info = new JDBCPooledConnectionInfo(this, connectionId, false, 0, System.currentTimeMillis(), -1, disposable, this.shouldUseSQLTrace());
        this.stats = statHolder;
        this.stats.addPooledConnectionInfo(this.info);
        if (cp.getConnectionPoolInfo().isKeepConnectionHandleOpen()) {
            this.setReuseConnectionHandle(true);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getJeusConnection();
    }

    public Connection getActualHandle() throws SQLException {
        if (this.connectionHandle == null) {
            this.connectionHandle = this.actualPooledConn.getConnection();
            this.initialAutoCommit = this.connectionHandle.getAutoCommit();
            if (!this.initialAutoCommit && logger.isLoggable(JeusMessage_JDBC._382_LEVEL)) {
                logger.log(JeusMessage_JDBC._382_LEVEL, JeusMessage_JDBC._382, new Object[]{this.getDataSourceId()});
            }
        }
        return this.connectionHandle;
    }

    public void closeConnectionHandle(JeusConnection connection) throws SQLException {
        this.connectionPool.removeConnectionResource(this, connection);
        if (this.decrementReferenceAndGet() <= 0 && this.closable) {
            this.closeActualHandle();
        }
    }

    public void closeConnectionHandleForcibly() throws SQLException {
        if (this.closable) {
            if (this.getReferenceCount() > 0) {
                this.closeActualHandle();
            } else {
                logger.log(JeusMessage_JDBC._366_LEVEL, JeusMessage_JDBC._366, (Object)this);
            }
        } else {
            throw new SQLException("Connection is not closable; associated transaction is not completed : " + this.associatedTxId);
        }
    }

    public void closeActualHandleDirectly() throws SQLException {
        if (this.connectionHandle != null) {
            this.connectionHandle.close();
            this.connectionHandle = null;
        }
    }

    public void closeConnectionHandleAfterTxCompletion() throws SQLException {
        if (logger.isLoggable(JeusMessage_JDBC._348_LEVEL)) {
            logger.log(JeusMessage_JDBC._348_LEVEL, JeusMessage_JDBC._348, (Object)this.toString());
        }
        this.setClosable(true);
        if (this.getReferenceCount() <= 0) {
            this.closeActualHandle();
        }
    }

    protected void closeActualHandle() throws SQLException {
        assert (this.connectionHandle != null);
        this.setReferenceCount(0);
        this.stats.addToUseTimeStat(this.startToUseTime);
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.reuseConnectionHandle) {
                if (this.initialAutoCommit != this.connectionHandle.getAutoCommit()) {
                    this.connectionHandle.setAutoCommit(this.initialAutoCommit);
                }
            } else {
                this.connectionHandle.close();
            }
        }
        catch (Throwable th) {
            if (!this.isRawConnection) {
                this.connectionPool.connectionErrorOccurred(this);
            }
            if (th instanceof SQLException) {
                throw (SQLException)th;
            }
            throw new JeusSQLException(th);
        }
        finally {
            if (!this.reuseConnectionHandle) {
                this.connectionHandle = null;
            }
        }
        if (this.isClosed()) {
            return;
        }
        if (this.isRawConnection) {
            return;
        }
        this.isShared = false;
        this.connectionPool.connectionClosed(this);
    }

    public void commitConnectionHandle() throws SQLException {
        if (this.connectionHandle != null) {
            this.connectionHandle.commit();
        }
    }

    public void rollbackConnectionHandle() throws SQLException {
        if (this.connectionHandle != null) {
            this.connectionHandle.rollback();
        }
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    public boolean isShared() {
        return this.isShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.setClosed(true);
            try {
                this.actualPooledConn.close();
            }
            finally {
                this.xaResourceWrapper = null;
                this.stats.removePooledConnectionInfo(this.info);
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.actualPooledConn.addConnectionEventListener(listener);
        this.connectionEventListener = listener;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.actualPooledConn.removeConnectionEventListener(listener);
        this.connectionEventListener = null;
    }

    public void removeConnectionEventListener() {
        if (this.connectionEventListener != null) {
            this.removeConnectionEventListener(this.connectionEventListener);
        }
    }

    public XAResource getXAResource() throws SQLException {
        return ((XAConnection)this.actualPooledConn).getXAResource();
    }

    public XAResourceWrapper getXaResourceWrapper() {
        return this.xaResourceWrapper;
    }

    public void setXaResourceWrapper(XAResourceWrapper wrapper) {
        this.xaResourceWrapper = wrapper;
    }

    public boolean isDisposable() {
        return this.info.isDisposable();
    }

    public void changeToActive() {
        this.info.compareAndSetIsActive(true);
    }

    public boolean isActive() {
        return this.info.isActive();
    }

    public boolean changeToIdle() {
        return this.info.compareAndSetIsActive(false);
    }

    public void setLastValidTime(long lastValidatedTime) {
        this.lastValidatedTime = lastValidatedTime;
    }

    public long getLastValidTime() {
        return this.lastValidatedTime;
    }

    public void incUseCount() {
        this.info.incUseCount();
    }

    public int getUseCount() {
        return this.info.getUseCount();
    }

    public long getStateChangedTime() {
        return this.info.getStateChangedTime();
    }

    public void setStateChangedTime(long time) {
        this.info.setStateChangedTime(time);
    }

    public void setConnectionId(String id) {
        this.info.setConnectionId(id);
    }

    public String getConnectionId() {
        return this.info.getConnectionId();
    }

    public int getGeneration() {
        return this.info.getGeneration();
    }

    public void setGeneration(int generation) {
        this.info.setGeneration(generation);
    }

    protected void incrementReferenceCount() {
        if (this.referenceCount == 0) {
            this.startToUseTime = System.currentTimeMillis();
        }
        ++this.referenceCount;
    }

    protected int decrementReferenceAndGet() {
        return --this.referenceCount;
    }

    protected void setReferenceCount(int count) {
        this.referenceCount = count;
    }

    protected int getReferenceCount() {
        return this.referenceCount;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    protected boolean isReuseConnectionHandle() {
        return this.reuseConnectionHandle;
    }

    protected void setReuseConnectionHandle(boolean reuseConnectionHandle) {
        this.reuseConnectionHandle = reuseConnectionHandle;
    }

    public boolean isRawConnection() {
        return this.isRawConnection;
    }

    public void setRawConnection(boolean rawConnection) {
        this.isRawConnection = rawConnection;
    }

    public boolean shouldForciblyClosed() {
        return this.shouldForciblyClosed;
    }

    public void setShouldForciblyClosed(boolean b) {
        this.shouldForciblyClosed = b;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void setConnectionTrace(JeusConnectionImpl jeusConn) {
        this.info.setConnectionTrace(jeusConn);
    }

    public void unsetConnectionTrace(JeusConnectionImpl jeusConn) {
        this.info.unsetConnectionTrace(jeusConn);
    }

    public void clearAllConnectionTraces() {
        this.info.clearAllConnectionTraces();
    }

    public String toString() {
        String name = this.connName;
        if (name == null) {
            this.connName = name = "JeusPooledConnection[ID=" + this.info.getConnectionId() + (this.info.isDisposable() ? ",disposable" : "") + ",actual=" + this.actualPooledConn + "]";
        }
        return name;
    }

    public String getDataSourceId() {
        return this.connectionPool.getDataSourceId();
    }

    public String getPoolExportName() {
        return this.connectionPool.getConnectionPoolInfo().getJndiExportName();
    }

    public void setSQLStatement(String sql, long startingTime) {
        this.info.setSQLStatement(sql, startingTime);
    }

    public boolean shouldUseStatementWrapper() {
        return this.connectionPool.getConnectionPoolInfo().shouldUseStatementWrapper();
    }

    public boolean shouldUseSQLTrace() {
        return this.connectionPool.getConnectionPoolInfo().isSqlTraceEnabled();
    }

    public boolean shouldUseSetAutoCommitTrace() {
        return this.connectionPool.getConnectionPoolInfo().isUseSetAutoCommitTrace();
    }

    public void setUseForValidationOnly(boolean useForValidationOnly) {
        this.useForValidationOnly = useForValidationOnly;
    }

    public boolean getUseForValidationOnly() {
        return this.useForValidationOnly;
    }

    public boolean isAssociatedWithTransaction() {
        return this.isAssociatedWithTx;
    }

    public void setAssociatedTransaction(boolean b, GTID assosiatedTxId) {
        this.isAssociatedWithTx = b;
        this.associatedTxId = assosiatedTxId;
    }

    public void checkAssociatedTxStatus() throws SQLException {
        if (this.associatedTxId != null) {
            if (!TMCommonService.isTxAlive(this.associatedTxId)) {
                throw new SQLException("the associated transaction is already completed: " + this.associatedTxId);
            }
            if (TMCommonService.isTxTimeout(this.associatedTxId)) {
                throw new SQLException("the associated transaction is already timed out: " + this.associatedTxId);
            }
        }
    }

    public GTID getAssociatedTxId() {
        return this.associatedTxId;
    }

    public int getActionOnConnectionLeak() {
        return this.connectionPool.getConnectionPoolInfo().getActionOnConnectionLeak();
    }

    public void setThreadNameInUse(String name) {
        this.info.setThreadNameInUse(name);
    }

    public void setDatabaseSessionId(String sid) {
        this.dbSessionId = sid;
    }

    public void scheduleSessionKillTrigger(long sessionKillTimeout) {
        if (this.sessionKillTrigger == null && this.dbSessionId != null && !this.dbSessionId.equals("") && sessionKillTimeout > 0L) {
            this.sessionKillTrigger = new SessionKillTrigger();
            ScheduledExecutor.getInstance().schedule(this.sessionKillTrigger, sessionKillTimeout);
        }
    }

    public void cancelSessionKillTrigger() {
        if (this.sessionKillTrigger != null) {
            this.sessionKillTrigger.cancel();
            this.sessionKillTrigger = null;
        }
    }

    public String getThreadNameInUse() {
        return this.info.getThreadNameInUse();
    }

    public void destroyPhysicalConnectionForcibly() {
        if (this.changeToIdle()) {
            try {
                this.killAssociatedDatabaseSession();
            }
            catch (Throwable th) {
                logger.log(JeusMessage_JDBC._307_LEVEL, JeusMessage_JDBC._307, this.getConnectionId(), th);
            }
            this.connectionPool.destroyConnectionDirectly(this);
            logger.log(JeusMessage_JDBC._374_LEVEL, JeusMessage_JDBC._374, (Object)this.getConnectionId());
        }
    }

    private void killAssociatedDatabaseSession() throws SQLException {
        if (this.connectionPool.getConnectionPoolInfo().isDbaDataSourceUsed() && this.dbSessionId != null) {
            ConnectionPoolDBAHelper dbaHelper = this.connectionPool.getDbaHelper();
            if (dbaHelper != null) {
                dbaHelper.killDatabaseSession(this.dbSessionId);
            }
            this.dbSessionId = null;
        }
    }

    private class SessionKillTrigger
    extends ScheduleTask {
        private SessionKillTrigger() {
        }

        public void run() {
            if (AbstractJeusPooledConnection.this.isActive()) {
                AbstractJeusPooledConnection.this.setShouldForciblyClosed(true);
                try {
                    AbstractJeusPooledConnection.this.killAssociatedDatabaseSession();
                }
                catch (Throwable th) {
                    logger.log(JeusMessage_JDBC._307_LEVEL, JeusMessage_JDBC._307, AbstractJeusPooledConnection.this.getConnectionId(), th);
                }
            }
        }
    }
}

