/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import jeus.jdbc.common.JeusCachePooledConnection;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.stmt.PreparedStatementWrapper;
import jeus.jdbc.util.CacheHashtable;

public class JeusCacheConnection
extends JeusConnectionImpl {
    private CacheHashtable cache;

    public JeusCacheConnection(Connection connection, CacheHashtable cache, JeusCachePooledConnection pcon) throws SQLException {
        this(connection, cache, pcon, 0L);
    }

    public JeusCacheConnection(Connection con, CacheHashtable cache, JeusCachePooledConnection pcon, long stmtQueryTimeout) throws SQLException {
        super(con, pcon, stmtQueryTimeout);
        this.shouldUseStatementWrapper = true;
        this.cache = cache;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatementWrapper jps = (PreparedStatementWrapper)this.cache.get(sql);
        if (jps == null) {
            jps = (PreparedStatementWrapper)super.prepareStatement(sql);
            jps.setCacheEnabled(true);
            this.cache.put(sql, jps);
        } else {
            jps.setJeusConnection(this);
            jps.setIsClosed(false);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkStatus(true, true);
        String key = sql + "$$" + resultSetType + "$$" + resultSetConcurrency;
        PreparedStatementWrapper jps = (PreparedStatementWrapper)this.cache.get(key);
        if (jps == null) {
            jps = (PreparedStatementWrapper)super.prepareStatement(sql, resultSetType, resultSetConcurrency);
            jps.setCacheEnabled(true);
            this.cache.put(key, jps);
        } else {
            jps.setJeusConnection(this);
            jps.setIsClosed(false);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkStatus(true, true);
        String key = sql + "$$" + autoGeneratedKeys;
        PreparedStatementWrapper jps = (PreparedStatementWrapper)this.cache.get(key);
        if (jps == null) {
            jps = (PreparedStatementWrapper)super.prepareStatement(sql, autoGeneratedKeys);
            jps.setCacheEnabled(true);
            this.cache.put(key, jps);
        } else {
            jps.setJeusConnection(this);
            jps.setIsClosed(false);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String sql, String[] arg1) throws SQLException {
        this.checkStatus(true, true);
        String key = sql + this.getArrayKey(arg1);
        PreparedStatementWrapper jps = (PreparedStatementWrapper)this.cache.get(key);
        if (jps == null) {
            jps = (PreparedStatementWrapper)super.prepareStatement(sql, arg1);
            jps.setCacheEnabled(true);
            this.cache.put(key, jps);
        } else {
            jps.setJeusConnection(this);
            jps.setIsClosed(false);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String sql, int arg1, int arg2, int arg3) throws SQLException {
        this.checkStatus(true, true);
        String key = sql + "$$" + arg1 + "$$" + arg2 + "$$" + arg3;
        PreparedStatementWrapper jps = (PreparedStatementWrapper)this.cache.get(key);
        if (jps == null) {
            jps = (PreparedStatementWrapper)super.prepareStatement(sql, arg1, arg2, arg3);
            jps.setCacheEnabled(true);
            this.cache.put(key, jps);
        } else {
            jps.setJeusConnection(this);
            jps.setIsClosed(false);
        }
        return jps;
    }

    public PreparedStatement prepareStatement(String sql, int[] arg1) throws SQLException {
        this.checkStatus(true, true);
        String key = sql + this.getArrayKey(arg1);
        PreparedStatementWrapper jps = (PreparedStatementWrapper)this.cache.get(key);
        if (jps == null) {
            jps = (PreparedStatementWrapper)super.prepareStatement(sql, arg1);
            jps.setCacheEnabled(true);
            this.cache.put(key, jps);
        } else {
            jps.setJeusConnection(this);
            jps.setIsClosed(false);
        }
        return jps;
    }

    private String getArrayKey(int[] arg1) {
        StringBuffer result = new StringBuffer();
        for (int anArg1 : arg1) {
            result.append("$$");
            result.append(anArg1);
        }
        return result.toString();
    }

    private String getArrayKey(String[] arg1) {
        StringBuffer result = new StringBuffer();
        for (String anArg1 : arg1) {
            result.append("$$");
            result.append(anArg1);
        }
        return result.toString();
    }

    public void close() throws SQLException {
        this.cache = null;
        super.close();
    }
}

