/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.common;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jeus.jdbc.common.AbstractJeusPooledConnection;
import jeus.jdbc.common.JeusConnection;
import jeus.jdbc.connectionpool.JDBCResource;
import jeus.jdbc.stmt.CallableStatementWrapper;
import jeus.jdbc.stmt.PreparedStatementWrapper;
import jeus.jdbc.stmt.StatementWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusJDBCProperties;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.trace.ManagedResource;

public class JeusConnectionImpl
implements JeusConnection {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc");
    protected final AbstractJeusPooledConnection jeusPooledConn;
    protected final Connection actualConn;
    private int queryTimeout = 0;
    private int fetchSize = -1;
    private final JDBCResource managedResource;
    protected boolean shouldUseStatementWrapper;
    private boolean isClosed;
    private Throwable trace;
    private boolean useSetAutoCommitTrace;

    public JeusConnectionImpl(Connection actualConn, AbstractJeusPooledConnection pcon) throws SQLException {
        this.actualConn = actualConn;
        this.managedResource = new JDBCResource(this, pcon.getActionOnConnectionLeak());
        this.jeusPooledConn = pcon;
        this.shouldUseStatementWrapper = pcon.shouldUseStatementWrapper();
        this.useSetAutoCommitTrace = pcon.shouldUseSetAutoCommitTrace();
        if (!actualConn.getAutoCommit() && !this.jeusPooledConn.isAssociatedWithTransaction()) {
            this.managedResource.setShouldRollbackAutomatically(true);
        }
    }

    public JeusConnectionImpl(Connection delegated, AbstractJeusPooledConnection pcon, long queryTimeout) throws SQLException {
        this(delegated, pcon);
        this.queryTimeout = (int)(queryTimeout / 1000L);
    }

    public void setDefaultRowPrefetch(int i) {
        this.fetchSize = i;
    }

    protected void checkStatus(boolean checkTxStatus, boolean checkInterrupted) throws SQLException {
        if (JeusJDBCProperties.CHECK_CONNECTION_CLOSED && this.isClosed) {
            throw new SQLException("connection is already closed");
        }
        if (checkTxStatus) {
            this.checkAssociatedTxStatus();
        }
        if (JeusManagerProperties.CHECK_INTERRUPTED_STATUS && checkInterrupted && Thread.interrupted()) {
            throw new SQLException("the current thread is interrupted");
        }
    }

    public void checkAssociatedTxStatus() throws SQLException {
        this.jeusPooledConn.checkAssociatedTxStatus();
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.setReadOnly(arg0);
    }

    public boolean isReadOnly() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.isReadOnly();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.trace != null) {
            this.jeusPooledConn.unsetConnectionTrace(this);
        }
        this.jeusPooledConn.closeConnectionHandle(this);
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    private void setStmtInfo(Statement st) throws SQLException {
        if (this.queryTimeout > 0) {
            st.setQueryTimeout(this.queryTimeout);
        }
        if (this.fetchSize > 0) {
            st.setFetchSize(this.fetchSize);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkStatus(true, true);
        Statement stmt = this.actualConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.shouldUseStatementWrapper) {
            stmt = new StatementWrapper(this, stmt, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(stmt);
        return stmt;
    }

    public Statement createStatement() throws SQLException {
        this.checkStatus(true, true);
        Statement stmt = this.actualConn.createStatement();
        if (this.shouldUseStatementWrapper) {
            stmt = new StatementWrapper(this, stmt, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(stmt);
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkStatus(true, true);
        Statement stmt = this.actualConn.createStatement(resultSetType, resultSetConcurrency);
        if (this.shouldUseStatementWrapper) {
            stmt = new StatementWrapper(this, stmt, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatement pstmt = this.actualConn.prepareStatement(sql, autoGeneratedKeys);
        if (this.shouldUseStatementWrapper) {
            pstmt = new PreparedStatementWrapper(this, pstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatement pstmt = this.actualConn.prepareStatement(sql, columnNames);
        if (this.shouldUseStatementWrapper) {
            pstmt = new PreparedStatementWrapper(this, pstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatement pstmt = this.actualConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.shouldUseStatementWrapper) {
            pstmt = new PreparedStatementWrapper(this, pstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatement pstmt = this.actualConn.prepareStatement(sql);
        if (this.shouldUseStatementWrapper) {
            pstmt = new PreparedStatementWrapper(this, pstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatement pstmt = this.actualConn.prepareStatement(sql, columnIndexes);
        if (this.shouldUseStatementWrapper) {
            pstmt = new PreparedStatementWrapper(this, pstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkStatus(true, true);
        PreparedStatement pstmt = this.actualConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        if (this.shouldUseStatementWrapper) {
            pstmt = new PreparedStatementWrapper(this, pstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(pstmt);
        return pstmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkStatus(true, true);
        CallableStatement cstmt = this.actualConn.prepareCall(sql, resultSetType, resultSetConcurrency);
        if (this.shouldUseStatementWrapper) {
            cstmt = new CallableStatementWrapper(this, cstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(cstmt);
        return cstmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkStatus(true, true);
        CallableStatement cstmt = this.actualConn.prepareCall(sql);
        if (this.shouldUseStatementWrapper) {
            cstmt = new CallableStatementWrapper(this, cstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(cstmt);
        return cstmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkStatus(true, true);
        CallableStatement cstmt = this.actualConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.shouldUseStatementWrapper) {
            cstmt = new CallableStatementWrapper(this, cstmt, sql, this.jeusPooledConn.shouldUseSQLTrace());
        }
        this.setStmtInfo(cstmt);
        return cstmt;
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        JeusLogger logger;
        this.checkStatus(true, true);
        this.actualConn.setAutoCommit(autoCommit);
        if (this.useSetAutoCommitTrace && (logger = (JeusLogger)JeusLogger.getLogger("jeus.jdbc.connection-trace")).isLoggable(JeusMessage_JDBC._383_LEVEL)) {
            logger.log(JeusMessage_JDBC._383_LEVEL, JeusMessage_JDBC._383, (Object)autoCommit);
            Thread.dumpStack();
        }
        if (autoCommit) {
            this.managedResource.setShouldRollbackAutomatically(false);
        } else if (!this.jeusPooledConn.isAssociatedWithTransaction()) {
            this.managedResource.setShouldRollbackAutomatically(true);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.checkStatus(true, false);
        this.actualConn.commit();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkStatus(false, false);
        this.actualConn.rollback(savepoint);
    }

    public void rollback() throws SQLException {
        this.checkStatus(false, false);
        this.actualConn.rollback();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getMetaData();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getCatalog();
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.setTransactionIsolation(arg0);
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getTypeMap();
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.setTypeMap(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.setHoldability(arg0);
    }

    public int getHoldability() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkStatus(true, true);
        return this.actualConn.setSavepoint(name);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkStatus(true, true);
        this.actualConn.releaseSavepoint(savepoint);
    }

    public Connection getActualHandle() {
        return this.actualConn;
    }

    public ManagedResource getManagedResource() {
        return this.managedResource;
    }

    public String getConnectionId() {
        return this.jeusPooledConn.getConnectionId();
    }

    public String toString() {
        return "JeusConnection@" + Integer.toHexString(this.hashCode()) + "[PHY_ID=" + this.jeusPooledConn.getConnectionId() + ",actual=" + this.actualConn + "]";
    }

    public void setConnectionTrace(Throwable trace) {
        this.trace = trace;
    }

    public Throwable getConnectionTrace() {
        return this.trace;
    }

    public String getPoolExportName() {
        return this.jeusPooledConn.getPoolExportName();
    }

    public void setSQLStatement(String sql, long startingTime) {
        this.jeusPooledConn.setSQLStatement(sql, startingTime);
    }

    public AbstractJeusPooledConnection getPhysicalConnection() {
        return this.jeusPooledConn;
    }

    public void setUseForValidationOnly(boolean validationOnly) {
        this.jeusPooledConn.setUseForValidationOnly(validationOnly);
    }

    public String getThreadNameInUse() {
        return this.jeusPooledConn.getThreadNameInUse();
    }
}

