/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolInitializer;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.management.JMXUtility;
import jeus.management.RemoteMBeanServerFactory;
import jeus.server.service.JDBCClusterDataSourceServiceMBean;

public class ClientSideClusteredConnectionPoolInitializer
implements ConnectionPoolInitializer {
    public Object makeConnectionPool(String dataSourceId, Hashtable env) throws ConnectionPoolException {
        try {
            MBeanServerConnection serverConn = RemoteMBeanServerFactory.getMBeanServer(env);
            ObjectName[] jdbcDataSourceServices = JMXUtility.queryJDBCClusterDataSourceServices(serverConn, dataSourceId);
            if (jdbcDataSourceServices.length == 0) {
                throw new ConnectionPoolException("ClusterDataSource is not bound to JNDI : " + dataSourceId);
            }
            JDBCClusterDataSourceServiceMBean serviceInstance = MBeanServerInvocationHandler.newProxyInstance(serverConn, jdbcDataSourceServices[0], JDBCClusterDataSourceServiceMBean.class, false);
            ClusterDSBindInfo bindInfo = serviceInstance.getDescriptor();
            ClusteredConnectionPool pool = new ClusteredConnectionPool(bindInfo, env);
            pool.initializePool();
            return pool;
        }
        catch (Throwable th) {
            if (th instanceof ConnectionPoolException) {
                throw (ConnectionPoolException)th;
            }
            throw new ConnectionPoolException("failed to make the ClusterConnectionPool(" + dataSourceId + ")", th);
        }
    }

    public void destroyMBean() {
    }
}

